/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.remoteproxy.client.impl;

import com.sap.sdm.is.cs.cmd.CmdError;
import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.client.CmdClient;
import com.sap.sdm.is.cs.filetransfer.client.FileTransfer;
import com.sap.sdm.is.cs.filetransfer.client.FileTransferResult;
import com.sap.sdm.is.cs.remoteproxy.client.impl.ClientExceptionFactory;
import com.sap.sdm.is.cs.remoteproxy.client.impl.RemoteProxyClientImpl;
import com.sap.sdm.is.cs.remoteproxy.common.ArrayElem;
import com.sap.sdm.is.cs.remoteproxy.common.CmdFactory;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteCall;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteCallXMLizerString;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteException;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteReturn;
import com.sap.sdm.is.cs.remoteproxy.common.InterfaceID;
import com.sap.sdm.is.cs.remoteproxy.common.InterfaceIDFactory;
import com.sap.sdm.util.log.Trace;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class ClientInvocationHandler
implements InvocationHandler {
    private static final Trace trace = Trace.getTrace(class$com$sap$sdm$is$cs$remoteproxy$client$impl$ClientInvocationHandler == null ? (class$com$sap$sdm$is$cs$remoteproxy$client$impl$ClientInvocationHandler = ClientInvocationHandler.class$("com.sap.sdm.is.cs.remoteproxy.client.impl.ClientInvocationHandler")) : class$com$sap$sdm$is$cs$remoteproxy$client$impl$ClientInvocationHandler);
    private final InterfaceID clIFID;
    private final RemoteProxyClientImpl remoteProxyClient;
    private final boolean hasCacheableNoArgMethods;
    private final Map methodInvocationCache = new HashMap();
    private Object proxyInstance = null;
    static /* synthetic */ Class class$com$sap$sdm$is$cs$remoteproxy$client$impl$ClientInvocationHandler;
    static /* synthetic */ Class class$java$lang$Object;

    ClientInvocationHandler(InterfaceID id, RemoteProxyClientImpl remoteProxyClient, boolean hasCacheableNoArgMethods) {
        this.clIFID = id;
        this.remoteProxyClient = remoteProxyClient;
        this.hasCacheableNoArgMethods = hasCacheableNoArgMethods;
        trace.debug("Created ClientInvocationHandler(InterfaceID: " + id + " / hasCacheableNoArgMethods: " + hasCacheableNoArgMethods);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        Object object;
        trace.entering("invoke(Object, Method, Object[])");
        try {
            if (this.remoteProxyClient.getProxyLockHandler() == null || this.remoteProxyClient.getProxyLockHandler().getLock() == null) {
                Object object2 = this.doInvoke(proxy, method, args);
                Object var8_6 = null;
                trace.exiting("invoke(Object, Method, Object[])");
                return object2;
            }
            Object object3 = this.remoteProxyClient.getProxyLockHandler().getLock();
            synchronized (object3) {
                object = this.doInvoke(proxy, method, args);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            trace.exiting("invoke(Object, Method, Object[])");
            throw throwable;
        }
        Object var8_7 = null;
        trace.exiting("invoke(Object, Method, Object[])");
        return object;
    }

    private Object doInvoke(Object proxy, Method method, Object[] args) throws Exception {
        Object resultObject;
        CmdIF answerCmd;
        trace.debug("Invocation of method \"" + method.getName() + "\"");
        if (method.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = ClientInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object)) {
            if (method.getName().equals("hashCode")) {
                return new Integer(42);
            }
            if (method.getName().equals("equals")) {
                return new Boolean(proxy == this.proxyInstance);
            }
        }
        if (this.isResultCacheable(method)) {
            if (this.methodInvocationCache.containsKey(method)) {
                trace.debug("Method has been invoked before. Return result from cache");
                return this.methodInvocationCache.get(method);
            }
            trace.debug("Method has not been invoked before");
        } else {
            trace.debug("Method result not cacheable");
        }
        CmdClient cmdClient = this.remoteProxyClient.getCmdClient();
        String id = this.clIFID != null ? this.clIFID.getInstanceID() : null;
        String clientClassName = this.clIFID != null ? this.clIFID.getClientClassName() : null;
        InterfaceID[] delArr = this.remoteProxyClient.getIDDeletionArr();
        CmdRemoteCall cmdRC = CmdFactory.createCmdRemoteCall(this.remoteProxyClient.getID(), clientClassName, method.getName(), id, args, method.getParameterTypes(), delArr);
        try {
            String output = CmdRemoteCallXMLizerString.getInstance().toXMLString(cmdRC);
        }
        catch (Exception toAPIStringExc) {
            throw new RuntimeException("Runtime Exception: " + toAPIStringExc.getMessage());
        }
        File[] fileTransferArr = cmdRC.getFileArrForTransfer();
        if (fileTransferArr != null) {
            int i = 0;
            while (i < fileTransferArr.length) {
                FileTransferResult transferResult = FileTransfer.transfer(cmdClient, fileTransferArr[i]);
                if (!transferResult.isOK()) {
                    Exception e = this.remoteProxyClient.getExceptionFactory().create("Filetransfer failed: " + transferResult.getErrorText());
                    throw e;
                }
                ++i;
            }
        }
        if ((answerCmd = cmdClient.processCommand(cmdRC)) instanceof CmdError) {
            CmdError error = (CmdError)answerCmd;
            Exception e = this.remoteProxyClient.getExceptionFactory().create(error.getErrorText());
            throw e;
        }
        if (answerCmd instanceof CmdRemoteException) {
            throw ClientExceptionFactory.getInstance().createClientException(((CmdRemoteException)answerCmd).getExceptionName(), ((CmdRemoteException)answerCmd).getExceptionMsg());
        }
        if (!(answerCmd instanceof CmdRemoteReturn)) {
            throw new RuntimeException("Received unexpected answer from server: " + answerCmd);
        }
        CmdRemoteReturn newReturn = (CmdRemoteReturn)answerCmd;
        if (newReturn.containsArray()) {
            Object resultArray = null;
            try {
                resultArray = this.buildArrayObject(newReturn);
            }
            catch (ClassNotFoundException buildArrExc) {
                throw new RuntimeException("Runtime Exception: " + buildArrExc.getMessage());
            }
            resultObject = resultArray;
        } else {
            Object newProxy;
            InterfaceID newID;
            Object knownProxy;
            resultObject = newReturn.isJavaImmutable() ? newReturn.getValueAsObject() : ((knownProxy = this.remoteProxyClient.searchInstanceByID(newID = InterfaceIDFactory.getInstance().createInterfaceID(newReturn.getInterfaceName(), newReturn.getInstanceID()))) != null ? knownProxy : (newProxy = this.remoteProxyClient.buildNewProxy(newReturn.getInterfaceName(), newID, newReturn.hasCacheableNoArgMethods())));
        }
        if (this.isResultCacheable(method)) {
            trace.debug("Storing result object in cache");
            this.methodInvocationCache.put(method, resultObject);
        }
        return resultObject;
    }

    void setProxyInstance(Object pInst) {
        this.proxyInstance = pInst;
    }

    public InterfaceID getClientInterfaceID() {
        return this.clIFID;
    }

    private boolean isResultCacheable(Method method) {
        return this.hasCacheableNoArgMethods && method.getParameterTypes().length == 0 && !method.getReturnType().getClass().equals(Void.TYPE);
    }

    private Object buildArrayObject(CmdRemoteReturn arrayReturn) throws ClassNotFoundException {
        ArrayElem[] arrElemArr;
        if (arrayReturn == null) {
            return null;
        }
        if (!arrayReturn.containsArray()) {
            return null;
        }
        String ifName = arrayReturn.getInterfaceName();
        if (ifName == null) {
            return null;
        }
        String compTypeName = null;
        if (ifName.startsWith("[L")) {
            compTypeName = ifName.substring(2);
        }
        if (compTypeName.endsWith(";")) {
            compTypeName = compTypeName.substring(0, compTypeName.length() - 1);
        }
        if ((arrElemArr = arrayReturn.getArrElementArray()) == null) {
            return null;
        }
        Object resultingArray = Array.newInstance(Class.forName(compTypeName), arrElemArr.length);
        int i = 0;
        while (i < arrElemArr.length) {
            ArrayElem arrElem = arrElemArr[i];
            if (arrElemArr[i] == null) {
                Array.set(resultingArray, i, null);
            } else if (arrElem.isJavaImmutable() && arrElem.getValue() == null) {
                Array.set(resultingArray, i, null);
            } else if (arrElem.getInterfaceName().equals("java.lang.Boolean")) {
                Array.set(resultingArray, i, new Boolean(arrElem.getValue()));
            } else if (arrElem.getInterfaceName().equals("java.lang.Byte")) {
                Array.set(resultingArray, i, new Byte(arrElem.getValue()));
            } else if (arrElem.getInterfaceName().equals("java.lang.Double")) {
                Array.set(resultingArray, i, new Double(arrElem.getValue()));
            } else if (arrElem.getInterfaceName().equals("java.lang.Float")) {
                Array.set(resultingArray, i, new Float(arrElem.getValue()));
            } else if (arrElem.getInterfaceName().equals("java.lang.Integer")) {
                Array.set(resultingArray, i, new Integer(arrElem.getValue()));
            } else if (arrElem.getInterfaceName().equals("java.lang.Long")) {
                Array.set(resultingArray, i, new Long(arrElem.getValue()));
            } else if (arrElem.getInterfaceName().equals("java.lang.Short")) {
                Array.set(resultingArray, i, new Short(arrElem.getValue()));
            } else if (arrElem.getInterfaceName().equals("java.lang.String")) {
                Array.set(resultingArray, i, new String(arrElem.getValue()));
            } else if (arrElem.getInstanceID() == null) {
                Array.set(resultingArray, i, null);
            } else {
                InterfaceID newID = InterfaceIDFactory.getInstance().createInterfaceID(arrElem.getInterfaceName(), arrElem.getInstanceID());
                Object knownProxy = this.remoteProxyClient.searchInstanceByID(newID);
                if (knownProxy != null) {
                    Array.set(resultingArray, i, knownProxy);
                } else {
                    Object newProxy = this.remoteProxyClient.buildNewProxy(arrElem.getInterfaceName(), newID, arrElem.hasCacheableNoArgMethods());
                    Array.set(resultingArray, i, newProxy);
                }
            }
            ++i;
        }
        return resultingArray;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.remoteProxyClient.registerIDForDeletion(this.clIFID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

