/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.filetransfer.common.string;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferResponse;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferResponseXMLizer;
import com.sap.sdm.is.stringxml.StringFinder;
import com.sap.sdm.util.log.Logger;

public class CmdFileTransferResponseXMLizerString
extends CmdFileTransferResponseXMLizer {
    private static final CmdFileTransferResponseXMLizerString instance = new CmdFileTransferResponseXMLizerString();
    private static final Logger log = Logger.getLogger();

    private CmdFileTransferResponseXMLizerString() {
    }

    public static CmdFileTransferResponseXMLizerString getInstance() {
        return instance;
    }

    public CmdIF fromXMLString(String input) throws CmdReconstructionException {
        try {
            String remoteFilePath = StringFinder.findAttrForXMLElem("FileTransferResponse", input, "fn");
            long remoteFileSize = Long.parseLong(StringFinder.findAttrForXMLElem("FileTransferResponse", input, "fs"));
            return new CmdFileTransferResponse(remoteFilePath, remoteFileSize);
        }
        catch (Exception exc) {
            String strErrMsg = "CmdFileTransferResponseXMLizerString could not reconstruct the command";
            StringBuffer sbErrMsg = new StringBuffer();
            sbErrMsg.append(strErrMsg).append(". \nThe exception is: \"").append(exc.getMessage()).append("\".");
            log.error(sbErrMsg.toString(), exc);
            throw new CmdReconstructionException(strErrMsg);
        }
    }
}

