/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.filetransfer.common.string;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferRequest;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferRequestXMLizer;
import com.sap.sdm.is.stringxml.StringFinder;
import com.sap.sdm.util.log.Logger;

public class CmdFileTransferRequestXMLizerString
extends CmdFileTransferRequestXMLizer {
    private static final CmdFileTransferRequestXMLizerString instance = new CmdFileTransferRequestXMLizerString();
    private static final Logger log = Logger.getLogger();

    private CmdFileTransferRequestXMLizerString() {
    }

    public static CmdFileTransferRequestXMLizerString getInstance() {
        return instance;
    }

    public CmdIF fromXMLString(String input) throws CmdReconstructionException {
        try {
            String absoluteFilePath = StringFinder.findAttrForXMLElem("FileTransferRequest", input, "afp");
            String fileName = StringFinder.findAttrForXMLElem("FileTransferRequest", input, "fn");
            String strFileSize = StringFinder.findAttrForXMLElem("FileTransferRequest", input, "fs");
            return new CmdFileTransferRequest(absoluteFilePath, fileName, Long.parseLong(strFileSize));
        }
        catch (Exception exc) {
            String strErrMsg = "CmdFileTransferRequestXMLizerString could not reconstruct the command";
            StringBuffer sbErrMsg = new StringBuffer();
            sbErrMsg.append(strErrMsg).append(". \nThe exception is: \"").append(exc.getMessage()).append("\".");
            log.error(sbErrMsg.toString(), exc);
            throw new CmdReconstructionException(strErrMsg);
        }
    }
}

