/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.filetransfer.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.cmd.CmdXMLizer;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferResponse;
import com.sap.sdm.is.stringxml.StringXMLizer;
import com.sap.sdm.is.stringxml.StringXMLizerFactory;
import java.util.ArrayList;

public abstract class CmdFileTransferResponseXMLizer
implements CmdXMLizer {
    protected static final String REMOTE_FILE_NAME_ATTRIBUTE = "fn";
    protected static final String REMOTE_FILE_SIZE_ATTRIBUTE = "fs";

    public String toXMLString(CmdIF cmd) {
        CmdFileTransferResponse cmdFileTransferResponse = (CmdFileTransferResponse)cmd;
        StringXMLizerFactory factory = StringXMLizerFactory.getInstance();
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        if (cmdFileTransferResponse.getRemoteFilePath() != null) {
            attributes.add(REMOTE_FILE_NAME_ATTRIBUTE);
            values.add(cmdFileTransferResponse.getRemoteFilePath());
        }
        attributes.add(REMOTE_FILE_SIZE_ATTRIBUTE);
        values.add(String.valueOf(cmdFileTransferResponse.getFileSize()));
        String[] attributeArr = new String[attributes.size()];
        String[] valueArr = new String[values.size()];
        attributes.toArray(attributeArr);
        values.toArray(valueArr);
        StringXMLizer sXML = factory.createStringXMLizer("FileTransferResponse", attributeArr, valueArr);
        sXML.endRootElem();
        return sXML.getString();
    }

    public abstract CmdIF fromXMLString(String var1) throws CmdReconstructionException;
}

