/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.filetransfer.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.cmd.CmdXMLizer;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferRequest;
import com.sap.sdm.is.stringxml.StringXMLizer;
import com.sap.sdm.is.stringxml.StringXMLizerFactory;
import java.util.ArrayList;

public abstract class CmdFileTransferRequestXMLizer
implements CmdXMLizer {
    protected static final String ABSOLUTE_FILE_PATH_ATTRIBUTE = "afp";
    protected static final String FILE_NAME_ATTRIBUTE = "fn";
    protected static final String FILE_SIZE_ATTRIBUTE = "fs";

    public String toXMLString(CmdIF cmd) {
        CmdFileTransferRequest cmdFileTransferRequest = (CmdFileTransferRequest)cmd;
        StringXMLizerFactory factory = StringXMLizerFactory.getInstance();
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        if (cmdFileTransferRequest.getAbsoluteFilePath() != null) {
            attributes.add(ABSOLUTE_FILE_PATH_ATTRIBUTE);
            values.add(cmdFileTransferRequest.getAbsoluteFilePath());
        }
        if (cmdFileTransferRequest.getFileName() != null) {
            attributes.add(FILE_NAME_ATTRIBUTE);
            values.add(cmdFileTransferRequest.getFileName());
        }
        attributes.add(FILE_SIZE_ATTRIBUTE);
        values.add(String.valueOf(cmdFileTransferRequest.getFileSize()));
        String[] attributeArr = new String[attributes.size()];
        String[] valueArr = new String[values.size()];
        attributes.toArray(attributeArr);
        values.toArray(valueArr);
        StringXMLizer sXML = factory.createStringXMLizer("FileTransferRequest", attributeArr, valueArr);
        sXML.endRootElem();
        return sXML.getString();
    }

    public abstract CmdIF fromXMLString(String var1) throws CmdReconstructionException;
}

