/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.filetransfer.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.cmd.CmdXMLizer;
import com.sap.sdm.is.cs.filetransfer.common.CmdFilePackageTransfer;
import com.sap.sdm.is.security.Base64;
import com.sap.sdm.is.stringxml.StringXMLizer;
import com.sap.sdm.is.stringxml.StringXMLizerFactory;
import java.util.Iterator;

public abstract class CmdFilePackageTransferXMLizer
implements CmdXMLizer {
    protected static final String XML_PACKAGE_NUMBER_ATTR = "PackNo";
    protected static final String XML_LAST_PACKAGE_ATTR = "LastPack";
    protected static final String XML_FILE_DATA = "Data";
    protected static final String XML_DATA_LINE = "Li";
    protected static final String XML_FILENAME_ATTR = "name";
    protected static final String XML_REPLY_ATTR = "reply";

    public String toXMLString(CmdIF cmd) {
        CmdFilePackageTransfer cmdFile = (CmdFilePackageTransfer)cmd;
        StringXMLizerFactory factory = StringXMLizerFactory.getInstance();
        StringXMLizer sXML = null;
        String[] attrs = new String[]{XML_FILENAME_ATTR, XML_PACKAGE_NUMBER_ATTR, XML_LAST_PACKAGE_ATTR, XML_REPLY_ATTR};
        String[] values = new String[]{cmdFile.getFileName(), new Integer(cmdFile.getPackageNumber()).toString(), new Boolean(cmdFile.isLastPackage()).toString(), new Boolean(cmdFile.reply()).toString()};
        sXML = factory.createStringXMLizer("FilePackageTransfer", attrs, values);
        sXML.startElem(XML_FILE_DATA);
        Iterator it = cmdFile.getData();
        while (it.hasNext()) {
            byte[] dataArr = (byte[])it.next();
            sXML.addElemWithContentCDATA(XML_DATA_LINE, Base64.encode(dataArr));
        }
        sXML.endCurrentElem();
        sXML.endRootElem();
        return sXML.getString();
    }

    public abstract CmdIF fromXMLString(String var1) throws CmdReconstructionException;
}

