/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.filetransfer.common;

import com.sap.sdm.is.cs.cmd.NoResponseCmdIF;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CmdFilePackageTransfer
implements NoResponseCmdIF {
    public static final String NAME = "FilePackageTransfer";
    private static final int BYTESPERLINE = 8192;
    private static final int MAXNUMBEROFLINES = 64;
    private String fileName = null;
    private boolean lastPackage = false;
    private int packageNumber = -1;
    private boolean reply = false;
    private List dataArrList = null;

    public CmdFilePackageTransfer(String fileName, int packageNumber, boolean lastPackage, boolean reply, List dataArrList) {
        this.fileName = fileName;
        this.packageNumber = packageNumber;
        this.lastPackage = lastPackage;
        this.dataArrList = dataArrList;
        this.reply = reply;
    }

    public CmdFilePackageTransfer(String fileName, String lastName, int packageNumber, boolean reply) throws FileNotFoundException, IOException {
        long reallySkipped;
        this.fileName = lastName;
        this.packageNumber = packageNumber;
        this.reply = reply;
        FileInputStream fis = new FileInputStream(fileName);
        this.dataArrList = new ArrayList();
        int numberOfLines = 0;
        byte[] dataArr = new byte[8192];
        int bytesRead = 0;
        long bytesToBeSkipped = packageNumber * 64 * 8192;
        if (bytesToBeSkipped > 0L && (reallySkipped = fis.skip(bytesToBeSkipped)) != bytesToBeSkipped) {
            fis.close();
            fis = new FileInputStream(fileName);
            int i = 0;
            while (i < packageNumber) {
                int j = 0;
                while (j < 64) {
                    bytesRead = fis.read(dataArr);
                    ++j;
                }
                ++i;
            }
        }
        bytesRead = fis.read(dataArr);
        while (bytesRead == 8192 && numberOfLines < 64) {
            this.dataArrList.add(dataArr);
            dataArr = new byte[8192];
            ++numberOfLines;
            bytesRead = fis.read(dataArr);
        }
        if (numberOfLines == 64) {
            this.lastPackage = false;
        } else {
            this.lastPackage = true;
            this.reply = true;
            if (bytesRead > -1) {
                byte[] dataArr2 = new byte[bytesRead];
                int i = 0;
                while (i < bytesRead) {
                    dataArr2[i] = dataArr[i];
                    ++i;
                }
                this.dataArrList.add(dataArr2);
            }
        }
        fis.close();
    }

    public Iterator getData() {
        return this.dataArrList.iterator();
    }

    public boolean isLastPackage() {
        return this.lastPackage;
    }

    public int getPackageNumber() {
        return this.packageNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMyName() {
        return NAME;
    }

    public boolean reply() {
        return this.reply;
    }
}

