/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.filetransfer.client;

import com.sap.sdm.is.cs.cmd.CmdConnectionHandler;
import com.sap.sdm.is.cs.cmd.CmdErrorFactory;
import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.client.CmdClientPostProcessor;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileOK;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileTransferClientPostProcessor
extends CmdClientPostProcessor {
    public static final int ARRAYSIZE = 65536;

    public FileTransferClientPostProcessor(String cmdName) {
        super(cmdName);
    }

    protected CmdIF doProcess(CmdIF request, CmdIF response, CmdConnectionHandler connHandler) {
        if (!(response instanceof CmdFileOK)) {
            return CmdErrorFactory.createCmdError("Could not transfer file. The responsed command has to be of type CmdFileOK, but is of type " + response == null ? "null" : request.getClass().getName());
        }
        if (!(request instanceof CmdFileTransferRequest)) {
            return CmdErrorFactory.createCmdError("Could not transfer file. The requested command has to be of type CmdFileTransferRequest, but is of type " + request == null ? "null" : request.getClass().getName());
        }
        String absoluteFilePath = ((CmdFileTransferRequest)request).getAbsoluteFilePath();
        try {
            this.transferFile(absoluteFilePath, connHandler);
        }
        catch (IOException ioe) {
            return CmdErrorFactory.createCmdError("Could not transfer file. IOException occured on client side: " + ioe.getMessage());
        }
        return connHandler.receiveWithTimeout();
    }

    private void transferFile(String absoluteFilePath, CmdConnectionHandler connHandler) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(absoluteFilePath);
            OutputStream out = connHandler.getOutputStream();
            byte[] byteArray = new byte[65536];
            int bytesread = -1;
            while ((bytesread = ((InputStream)is).read(byteArray)) != -1) {
                out.write(byteArray, 0, bytesread);
            }
            Object var8_7 = null;
            this.closeInputStream(is);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.closeInputStream(is);
            throw throwable;
        }
    }

    private void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

