/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.filetransfer.client;

import com.sap.sdm.is.cs.cmd.CmdError;
import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.client.CmdClient;
import com.sap.sdm.is.cs.filetransfer.client.FileTransferResult;
import com.sap.sdm.is.cs.filetransfer.common.CmdFilePackageAccepted;
import com.sap.sdm.is.cs.filetransfer.common.CmdFilePackageTransfer;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferRequest;
import com.sap.sdm.is.cs.filetransfer.common.CmdFileTransferResponse;
import com.sap.sdm.util.log.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FileTransfer {
    private static final Trace trace = Trace.getTrace(class$com$sap$sdm$is$cs$filetransfer$client$FileTransfer == null ? (class$com$sap$sdm$is$cs$filetransfer$client$FileTransfer = FileTransfer.class$("com.sap.sdm.is.cs.filetransfer.client.FileTransfer")) : class$com$sap$sdm$is$cs$filetransfer$client$FileTransfer);
    private static final SimpleDateFormat formatter;
    private static long lastTime;
    private static long currentTime;
    private static String currentTimestamp;
    static /* synthetic */ Class class$com$sap$sdm$is$cs$filetransfer$client$FileTransfer;

    public static FileTransferResult transfer(CmdClient cmdClient, File localFile) {
        FileTransferResult fileTransferResult;
        trace.entering("transfer(CmdClient, File \"" + (localFile != null ? localFile.getAbsolutePath() : "null") + "\")");
        try {
            FileTransferResult transferResult = FileTransfer.transferDataAsBytes(cmdClient, localFile);
            if (!transferResult.isOK()) {
                FileTransferResult fileTransferResult2 = FileTransfer.transferAsText(cmdClient, localFile);
                Object var5_5 = null;
                trace.exiting();
                return fileTransferResult2;
            }
            fileTransferResult = transferResult;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            trace.exiting();
            throw throwable;
        }
        Object var5_6 = null;
        trace.exiting();
        return fileTransferResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileTransferResult transferDataAsBytes(CmdClient cmdClient, File localFile) {
        FileTransferResult fileTransferResult;
        block5: {
            FileTransferResult fileTransferResult2;
            block4: {
                try {
                    trace.entering("transferDataAsBytes");
                    CmdFileTransferRequest cmdFileTransferRequest = new CmdFileTransferRequest(localFile.getAbsolutePath(), localFile.getName(), localFile.length());
                    CmdIF answerCmd = null;
                    FileTransfer.mytrace("start file transferring");
                    answerCmd = cmdClient.processCommand(cmdFileTransferRequest);
                    if (answerCmd instanceof CmdFileTransferResponse) {
                        FileTransfer.mytrace("file transferred");
                        FileTransferResult fileTransferResult3 = new FileTransferResult("file transferred", ((CmdFileTransferResponse)answerCmd).getRemoteFilePath(), true);
                        Object var6_7 = null;
                        trace.exiting();
                        return fileTransferResult3;
                    }
                    if (answerCmd instanceof CmdError) {
                        FileTransfer.mytrace("error in file transfer");
                        fileTransferResult2 = new FileTransferResult("Error received from server: " + ((CmdError)answerCmd).getErrorText(), null, false);
                        break block4;
                    }
                    FileTransfer.mytrace("file could not be transferred");
                    fileTransferResult = new FileTransferResult("Error received from server: Unknown response command " + answerCmd == null ? "null" : answerCmd.getMyName() + "!", null, false);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    trace.exiting();
                    throw throwable;
                }
            }
            Object var6_8 = null;
            trace.exiting();
            return fileTransferResult2;
        }
        Object var6_9 = null;
        trace.exiting();
        return fileTransferResult;
    }

    private static FileTransferResult transferAsText(CmdClient cmdClient, File localFile) {
        FileTransferResult fileTransferResult;
        trace.entering("transferAsText(CmdClient, File \"" + (localFile != null ? localFile.getAbsolutePath() : "null") + "\")");
        try {
            String remoteFileName = null;
            String errorText = null;
            FileTransferResult result = null;
            CmdIF answerCmd = null;
            boolean lastPack = false;
            boolean copyError = false;
            try {
                int packNumber = 0;
                while (!lastPack && !copyError) {
                    FileTransfer.mytrace("{ new CmdFilePackageTransfer()");
                    CmdFilePackageTransfer filePack = new CmdFilePackageTransfer(localFile.getAbsolutePath(), localFile.getName(), packNumber, true);
                    FileTransfer.mytrace("done }");
                    if (filePack.isLastPackage()) {
                        lastPack = true;
                    }
                    trace.debug("Transferring package number: " + packNumber);
                    FileTransfer.mytrace("{ processCommand()");
                    answerCmd = cmdClient.processCommand(filePack);
                    FileTransfer.mytrace("done }");
                    if (answerCmd instanceof CmdError) {
                        FileTransferResult fileTransferResult2 = new FileTransferResult("Error received from server: " + ((CmdError)answerCmd).getErrorText(), remoteFileName, false);
                        Object var12_14 = null;
                        trace.exiting();
                        return fileTransferResult2;
                    }
                    if (answerCmd instanceof CmdFilePackageAccepted) {
                        trace.debug("package was accepted!");
                        ++packNumber;
                        continue;
                    }
                    errorText = "Received unexpected Answer from Server - Expected <FilePackageAccepted> got " + answerCmd;
                    result = new FileTransferResult(errorText, remoteFileName, false);
                    copyError = true;
                    break;
                }
                if (!copyError && lastPack) {
                    remoteFileName = ((CmdFilePackageAccepted)answerCmd).getRemoteFileName();
                }
            }
            catch (FileNotFoundException e1) {
                errorText = e1.getMessage();
                result = new FileTransferResult(errorText, remoteFileName, false);
            }
            catch (IOException e2) {
                errorText = e2.getMessage();
                result = new FileTransferResult(errorText, remoteFileName, false);
            }
            if (null == result) {
                result = new FileTransferResult(errorText, remoteFileName, !copyError);
            }
            fileTransferResult = result;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            trace.exiting();
            throw throwable;
        }
        Object var12_15 = null;
        trace.exiting();
        return fileTransferResult;
    }

    private static void mytrace(String msg) {
        currentTime = System.currentTimeMillis();
        currentTimestamp = formatter.format(new Date(currentTime));
        trace.debug(currentTimestamp + "/" + (currentTime - lastTime) + " Client: " + msg);
        lastTime = currentTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        lastTime = 0L;
        currentTime = 0L;
        currentTimestamp = null;
        formatter = new SimpleDateFormat("yyyyMMddHHmmss SSSS");
        formatter.setTimeZone(TimeZone.getDefault());
        lastTime = currentTime = System.currentTimeMillis();
    }
}

