/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.cmd.client.impl.ni;

public class SapRouteSubString {
    private String host;
    private String port;
    private String password;

    public SapRouteSubString(String hostname) {
        this.initialize(hostname, "", "");
    }

    public SapRouteSubString(String hostname, String port) {
        this.initialize(hostname, port, "");
    }

    public SapRouteSubString(String hostname, String port, String passwd) {
        this.initialize(hostname, port, passwd);
    }

    private void initialize(String hostname, String port, String passwd) {
        this.host = new String(hostname);
        this.port = new String(port);
        this.password = new String(passwd);
    }

    public String getHost() {
        return this.host;
    }

    public String getPortAsString() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() throws NumberFormatException {
        if (this.port.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(this.port);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("SapRouteSubString: Cannot convert port name to an integer");
        }
    }

    public String toString() {
        String retval = "/H/" + this.getHost();
        if (this.getPortAsString().length() > 0) {
            retval = retval + "/S/" + this.getPortAsString();
        }
        if (this.getPassword().length() > 0) {
            retval = retval + "/W/" + this.getPassword();
        }
        return new String(retval);
    }
}

