/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.cmd.client.impl.ni;

import com.sap.sdm.is.cs.cmd.client.impl.ni.SapRouteStringFormatException;
import com.sap.sdm.is.cs.cmd.client.impl.ni.SapRouteSubString;
import com.sap.sdm.is.cs.cmd.client.impl.ni.Trace;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class SapRouteStringParser
implements Enumeration {
    private static final int DEFAULT_SAPROUTE_PORT = 3299;
    protected static final String HOST_TAG = "/H/";
    protected static final String PORT_TAG = "/S/";
    protected static final String PASSWORD_TAG = "/W/";
    protected static final String PASSWORD_TAG_OLD = "/P/";
    private boolean isSapRouteString;
    private String currentHostname = "";
    private String currentPort = "";
    private String currentPassword = "";
    private String previousHostname = "";
    private String previousPort = "";
    private String previousPassword = "";
    private String host;
    private int port;
    private String restStr;
    private String passwdTag = "/W/";
    private boolean lastSubStringReturned = false;
    private boolean oldStyle = false;

    public SapRouteStringParser(String host, int port) throws SapRouteStringFormatException {
        if (host == null) {
            throw new SapRouteStringFormatException("Malformed SAP route string: string must not be a null reference");
        }
        this.isSapRouteString = host.startsWith(HOST_TAG);
        if (this.isSapRouteString) {
            if (host.indexOf(PASSWORD_TAG) > 0) {
                if (host.indexOf(PASSWORD_TAG_OLD) > 0) {
                    throw new SapRouteStringFormatException("Malformed SAP route string: it is not allowed to mix /W/ and /P/");
                }
            } else if (host.indexOf(PASSWORD_TAG_OLD) > 0) {
                this.passwdTag = PASSWORD_TAG_OLD;
                this.oldStyle = true;
            }
            this.restStr = host.substring(HOST_TAG.length());
            this.analyzeRestString();
            this.saveSapRouteSubString();
        }
        this.port = port;
        this.host = host;
    }

    public final boolean hasMoreElements() {
        return !this.lastSubStringReturned;
    }

    public final Object nextElement() throws NoSuchElementException {
        if (!this.isSapRouteString && !this.lastSubStringReturned) {
            this.lastSubStringReturned = true;
            return new SapRouteSubString(this.host, String.valueOf(this.port));
        }
        if (this.isSapRouteString && !this.lastSubStringReturned) {
            boolean moreSubStrings = this.analyzeRestString();
            if (!moreSubStrings) {
                this.lastSubStringReturned = true;
            }
            if (this.previousPort.length() == 0) {
                this.previousPort = !moreSubStrings ? String.valueOf(this.port) : String.valueOf(3299);
            }
            return this.createSapRouteSubString();
        }
        throw new NoSuchElementException();
    }

    private boolean analyzeRestString() {
        if (this.restStr.length() != 0) {
            int beginOfPasswd;
            String workStr;
            int endOfHost = this.restStr.indexOf(HOST_TAG);
            if (endOfHost >= 0) {
                workStr = this.restStr.substring(0, endOfHost);
                this.restStr = this.restStr.substring(endOfHost + HOST_TAG.length());
            } else {
                workStr = new String(this.restStr);
                this.restStr = "";
            }
            int beginOfPort = workStr.indexOf(PORT_TAG);
            if (beginOfPort >= 0) {
                this.currentHostname = workStr.substring(0, beginOfPort);
                workStr = workStr.substring(beginOfPort + PORT_TAG.length());
            }
            if ((beginOfPasswd = workStr.indexOf(this.passwdTag)) >= 0) {
                if (beginOfPort < 0) {
                    this.currentHostname = workStr.substring(0, beginOfPasswd);
                } else {
                    this.currentPort = workStr.substring(0, beginOfPasswd);
                }
                if (this.oldStyle) {
                    this.previousPassword = workStr.substring(beginOfPasswd + this.passwdTag.length());
                } else {
                    this.currentPassword = workStr.substring(beginOfPasswd + this.passwdTag.length());
                }
            } else if (beginOfPort < 0) {
                this.currentHostname = new String(workStr);
            } else {
                this.currentPort = new String(workStr);
            }
            return true;
        }
        return false;
    }

    private SapRouteSubString createSapRouteSubString() {
        SapRouteSubString retval = new SapRouteSubString(this.previousHostname, this.previousPort, this.previousPassword);
        this.saveSapRouteSubString();
        Trace.print(4, "SapRouteStringParser.createSapRouteSubString(): SapRouteSubString created:\n" + retval);
        return retval;
    }

    private void saveSapRouteSubString() {
        this.previousHostname = this.currentHostname;
        this.previousPort = this.currentPort;
        this.previousPassword = this.currentPassword;
        this.currentHostname = "";
        this.currentPort = "";
        this.currentPassword = "";
    }
}

