/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.cmd.client.impl.ni;

import com.sap.sdm.is.cs.cmd.client.impl.ni.ErrInfo;
import com.sap.sdm.is.cs.cmd.client.impl.ni.SapRouteString;
import com.sap.sdm.is.cs.cmd.client.impl.ni.SapRouteStringFormatException;
import com.sap.sdm.is.cs.cmd.client.impl.ni.SapRouteSubString;
import com.sap.sdm.is.cs.cmd.client.impl.ni.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NiSocket {
    private static final int SO_TIMEOUT = 30000;
    private static final byte NI_IROUTE_VS = 2;
    private static final byte NI_VERSION = 27;
    private static final byte[] NI_ROUTE_EYEC = new byte[]{78, 73, 95, 82, 79, 85, 84, 69, 0};
    private static final byte[] NI_ROUTE_ERROR = new byte[]{78, 73, 95, 82, 84, 69, 82, 82, 0};
    private static final byte[] NI_PONG = new byte[]{78, 73, 95, 80, 79, 78, 71, 0};
    private static final byte NI_IROUTE_TALKMODE = 1;
    private static final byte NI_IROUTE_OPTIONS = 0;
    private static final byte NI_IROUTE_UNUSED = 0;
    private static final int NI_IROUT_HEADER_SIZE = 24;
    private static final int NIROUT_ERR_HEADER_SIZE = 20;
    private static final int SAP_ERR_INFO_LN = 500;
    private static final String ENCODING = "iso-8859-1";
    private Socket impl;
    private OutputStream outStream = null;
    private InputStream inStream = null;
    private SapRouteString sapRoute;

    public NiSocket(String host, int port) throws UnknownHostException, IOException, SapRouteStringFormatException {
        this.sapRoute = new SapRouteString(host, port);
        this.initializeSapRoute(this.sapRoute, port, null, 0);
    }

    public NiSocket(InetAddress address, int port) throws IOException {
        this.impl = new Socket(address, port);
        Trace.print(3, "NiSocket.NiSocket(InetAddress): Socket constructed: " + this.impl);
        this.sapRoute = new SapRouteString();
    }

    public NiSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException, SapRouteStringFormatException {
        this.sapRoute = new SapRouteString(host, port);
        this.initializeSapRoute(this.sapRoute, port, localAddr, localPort);
    }

    public NiSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this.impl = new Socket(address, port, localAddr, localPort);
        Trace.print(3, "NiSocket.NiSocket(InetAddress): Socket constructed: " + this.impl);
        this.sapRoute = new SapRouteString();
    }

    private void initializeSapRoute(SapRouteString routeStr, int port, InetAddress localAddr, int localPort) throws UnknownHostException, IOException, SapRouteStringFormatException {
        int routePort;
        SapRouteSubString substr = routeStr.getFirstRoute();
        try {
            routePort = substr.getPort();
        }
        catch (NumberFormatException e) {
            throw new SapRouteStringFormatException("Service specification of the first SAP route substring must be a number");
        }
        this.impl = new Socket(substr.getHost(), routePort, localAddr, localPort);
        Trace.print(3, "NiSocket.initializeSapRoute(): Socket constructed: " + this.impl);
        if (routeStr.getNuOfRoutes() > 1) {
            try {
                int saveTimeout = this.getSoTimeout();
                this.setSoTimeout(30000);
                this.sendHandshakePacket(this.makeHandshakePacket(routeStr));
                this.receiveReplyPacket();
                this.setSoTimeout(saveTimeout);
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }

    private byte[] makeHandshakePacket(SapRouteString route) throws ProtocolException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte tot_entries = new Integer(route.getNuOfRoutes()).byteValue();
        int SpaceLength = 0;
        SapRouteSubString substr = route.getFirstRoute();
        int next_entry = substr.getHost().length() + substr.getPortAsString().length() + 3;
        String TmpPasswd = "";
        Enumeration e = route.getRoutes();
        while (e.hasMoreElements()) {
            SapRouteSubString str = (SapRouteSubString)e.nextElement();
            SpaceLength += str.getHost().length();
            SpaceLength += str.getPortAsString().length();
            SpaceLength += TmpPasswd.length();
            SpaceLength += 3;
            TmpPasswd = str.getPassword();
        }
        int PacketLength = SpaceLength + 24;
        byteStream.write(PacketLength >>> 24 & 0xFF);
        byteStream.write(PacketLength >>> 16 & 0xFF);
        byteStream.write(PacketLength >>> 8 & 0xFF);
        byteStream.write(PacketLength >>> 0 & 0xFF);
        byteStream.write(NI_ROUTE_EYEC, 0, NI_ROUTE_EYEC.length);
        byteStream.write(2);
        byteStream.write(27);
        byteStream.write(tot_entries);
        byteStream.write(1);
        byteStream.write(0);
        byteStream.write(0);
        byteStream.write(tot_entries - 1);
        byteStream.write(SpaceLength >>> 24 & 0xFF);
        byteStream.write(SpaceLength >>> 16 & 0xFF);
        byteStream.write(SpaceLength >>> 8 & 0xFF);
        byteStream.write(SpaceLength >>> 0 & 0xFF);
        byteStream.write(next_entry >>> 24 & 0xFF);
        byteStream.write(next_entry >>> 16 & 0xFF);
        byteStream.write(next_entry >>> 8 & 0xFF);
        byteStream.write(next_entry >>> 0 & 0xFF);
        String KeepPasswd = "";
        Enumeration e2 = route.getRoutes();
        while (e2.hasMoreElements()) {
            byte[] buf;
            byte[] NullByte = new byte[]{0};
            SapRouteSubString str = (SapRouteSubString)e2.nextElement();
            try {
                buf = str.getHost().getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ProtocolException("Cannot generate handshake packet: cannot convert hostname to iso-8859-1");
            }
            byteStream.write(buf, 0, str.getHost().length());
            byteStream.write(NullByte, 0, 1);
            try {
                buf = str.getPortAsString().getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ProtocolException("Cannot generate handshake packet: cannot convert port to iso-8859-1");
            }
            byteStream.write(buf, 0, str.getPortAsString().length());
            byteStream.write(NullByte, 0, 1);
            try {
                buf = KeepPasswd.getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ProtocolException("Cannot generate handshake packet: cannot convert password to iso-8859-1");
            }
            byteStream.write(buf, 0, KeepPasswd.length());
            byteStream.write(NullByte, 0, 1);
            KeepPasswd = str.getPassword();
        }
        Trace.print(3, "NiSocket.makeHandshakePacket(): Handshake packet built");
        if (Trace.getLevel() == 4) {
            byte[] packet = byteStream.toByteArray();
            String message = "Handshake packet:\n";
            int i = 0;
            while (i < packet.length) {
                message = message + "|" + packet[i];
                ++i;
            }
            message = message + "|";
            Trace.print(4, message);
        }
        return byteStream.toByteArray();
    }

    private void sendHandshakePacket(byte[] packet) throws IOException {
        OutputStream out = this.getOutputStream();
        Trace.print(4, "NiSocket.sendHandshakePacket(): Output stream opened.");
        out.write(packet);
        out.flush();
        Trace.print(3, "NiSocket.sendHandshakePacket(): Handshake packet sent.");
    }

    private void receiveReplyPacket() throws IOException {
        int i;
        InputStream in = this.getInputStream();
        Trace.print(4, "NiSocket.receiveReplyPacket(): Input stream opened.");
        int PacketSize = 0;
        int shift = 24;
        int i2 = 0;
        while (i2 < 4) {
            int tmp = in.read();
            if (tmp == -1) {
                throw new ProtocolException("Malformed reply from saprouter");
            }
            PacketSize += tmp << shift;
            shift -= 8;
            ++i2;
        }
        Trace.print(4, "NiSocket.receiveReplyPacket(): Size of reply packet: " + PacketSize);
        int[] inBuffer = new int[PacketSize];
        int i3 = 0;
        while (i3 < PacketSize) {
            inBuffer[i3] = in.read();
            if (inBuffer[i3] == -1) {
                throw new ProtocolException("Malformed reply from saprouter");
            }
            ++i3;
        }
        Trace.print(3, "NiSocket.receiveReplyPacket(): Reply packet received.");
        if (Trace.getLevel() == 4) {
            String message = "Reply packet from saprouter (without first 4 bytes containing the packet size):\n";
            i = 0;
            while (i < inBuffer.length) {
                message = message + "|" + inBuffer[i];
                ++i;
            }
            message = message + "|";
            Trace.print(4, message);
        }
        boolean niPongRec = true;
        i = 0;
        while (i < NI_PONG.length) {
            if (NI_PONG[i] != inBuffer[i]) {
                niPongRec = false;
                break;
            }
            ++i;
        }
        if (niPongRec) {
            Trace.print(4, "NiSocket.receiveReplyPacket(): NI_PONG received.");
            return;
        }
        boolean niRouteErrorRec = true;
        int i4 = 0;
        while (i4 < NI_ROUTE_ERROR.length) {
            if (NI_ROUTE_ERROR[i4] != inBuffer[i4]) {
                niRouteErrorRec = false;
                break;
            }
            ++i4;
        }
        if (!niRouteErrorRec) {
            this.close();
            throw new ProtocolException("Malformed reply from saprouter");
        }
        Trace.print(4, "NiSocket.receiveReplyPacket(): NI_ROUTE_ERROR received.");
        ErrInfo reason = null;
        try {
            reason = this.analyzeNiRouteError(inBuffer);
        }
        catch (Exception ex) {
            Trace.print(2, ex.toString());
            this.close();
            throw new ProtocolException("Malformed reply from saprouter");
        }
        this.close();
        Trace.print(2, reason.getDescription());
        throw new IOException("Connect via saprouter failed: " + reason.getDescription());
    }

    private ErrInfo analyzeNiRouteError(int[] inBuffer) throws ErrInfo.ParseException {
        int shift = 24;
        int nirc = 0;
        int datalen = 0;
        char[] data = null;
        Object err = null;
        int i = 12;
        while (i < 16) {
            nirc += inBuffer[i] << shift;
            shift -= 8;
            ++i;
        }
        shift = 24;
        int i2 = 16;
        while (i2 < 20) {
            datalen += inBuffer[i2] << shift;
            shift -= 8;
            ++i2;
        }
        data = new char[datalen + 1];
        int i3 = 20;
        while (i3 < datalen + 20) {
            data[i3 - 20] = (char)inBuffer[i3];
            ++i3;
        }
        Trace.print(3, "NiSocket.analyzeNiRouteError(): " + String.valueOf(nirc));
        return new ErrInfo(data);
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.impl.getLocalAddress();
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public int getTargetPort() throws NumberFormatException {
        if (this.sapRoute.getNuOfRoutes() > 1) {
            return this.sapRoute.getLastRoute().getPort();
        }
        return this.getPort();
    }

    public String getTargetHost() {
        if (this.sapRoute.getNuOfRoutes() > 1) {
            return this.sapRoute.getLastRoute().getHost();
        }
        return this.getInetAddress().getHostName();
    }

    public InputStream getInputStream() throws IOException {
        if (this.inStream == null) {
            this.inStream = this.impl.getInputStream();
        }
        return this.inStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outStream == null) {
            this.outStream = this.impl.getOutputStream();
        }
        return this.outStream;
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.impl.setTcpNoDelay(on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.impl.getTcpNoDelay();
    }

    public void setSoLinger(boolean on, int val) throws SocketException {
        this.impl.setSoLinger(on, val);
    }

    public int getSoLinger() throws SocketException {
        return this.impl.getSoLinger();
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.impl.setSoTimeout(timeout);
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.impl.getSoTimeout();
    }

    public synchronized void close() throws IOException {
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.impl.close();
    }

    public String toString() {
        String retval = this.sapRoute.getNuOfRoutes() > 1 ? "NiSocket[route = " + this.sapRoute + "\n" + "direct Sap router addr=" + this.impl.getInetAddress() + "\n" + "direct Sap router port=" + this.impl.getPort() + "\n" + "localport=" + this.impl.getLocalPort() + "]" : "Socket[addr=" + this.impl.getInetAddress() + ",port=" + this.impl.getPort() + ",localport=" + this.impl.getLocalPort() + "]";
        return new String(retval);
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        Socket.setSocketImplFactory(fac);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

