/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.cmd.client.impl;

import com.sap.sdm.is.cs.cmd.CmdConnectionHandler;
import com.sap.sdm.is.cs.cmd.CmdError;
import com.sap.sdm.is.cs.cmd.CmdErrorFactory;
import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdNoReply;
import com.sap.sdm.is.cs.cmd.CmdXMLFactory;
import com.sap.sdm.is.cs.cmd.NoResponseCmdIF;
import com.sap.sdm.is.cs.cmd.client.CmdClient;
import com.sap.sdm.is.cs.cmd.client.CmdClientPostProcessor;
import com.sap.sdm.is.cs.cmd.client.impl.ni.NiSocket;
import com.sap.sdm.is.cs.ncwrapper.NCWrapperFactory;
import com.sap.sdm.is.cs.ncwrapper.NetComm;
import com.sap.sdm.util.log.Logger;
import com.sap.sdm.util.log.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

final class CmdClientImpl
extends CmdClient
implements CmdConnectionHandler {
    private static final int LOGIN_TIMEOUT_DEFAULT = 50000;
    private static final Trace trace = Trace.getTrace(class$com$sap$sdm$is$cs$cmd$client$impl$CmdClientImpl == null ? (class$com$sap$sdm$is$cs$cmd$client$impl$CmdClientImpl = CmdClientImpl.class$("com.sap.sdm.is.cs.cmd.client.impl.CmdClientImpl")) : class$com$sap$sdm$is$cs$cmd$client$impl$CmdClientImpl);
    private static final Logger log = Logger.getLogger();
    private static final SimpleDateFormat formatter;
    private static long lastTime;
    private static long currentTime;
    private static String currentTimestamp;
    private String host = null;
    private int port = 0;
    private boolean ioExceptionThrown = false;
    private boolean suppressErrorMessages = false;
    private NiSocket server = null;
    private NetComm nc = null;
    private static int loginTimeout;
    static /* synthetic */ Class class$com$sap$sdm$is$cs$cmd$client$impl$CmdClientImpl;

    CmdClientImpl(int _port, String _host, boolean suppressErrorMessages, int lTimeout) throws IOException {
        CmdClient.setInstance(this);
        this.host = _host;
        this.port = _port;
        this.suppressErrorMessages = suppressErrorMessages;
        loginTimeout = lTimeout;
        this.init();
    }

    CmdClientImpl(int _port, String _host) throws IOException {
        this(_port, _host, false, 50000);
    }

    CmdClientImpl(int _port, String _host, boolean suppressErrorMessages) throws IOException {
        this(_port, _host, suppressErrorMessages, 50000);
    }

    CmdClientImpl(int _port, String _host, int lTimeout) throws IOException {
        this(_port, _host, false, lTimeout);
    }

    CmdClientImpl(int _port) throws IOException {
        this(_port, null, false, 50000);
    }

    CmdClientImpl(int _port, boolean suppressErrorMessages) throws IOException {
        this(_port, null, suppressErrorMessages, 50000);
    }

    private void init() throws IOException {
        OutputStream out = null;
        InputStream in = null;
        try {
            String lHost = this.host;
            if (lHost == null) {
                lHost = "localhost";
            }
            this.server = new NiSocket(lHost, this.port);
            this.server.setTcpNoDelay(true);
            out = this.server.getOutputStream();
            in = this.server.getInputStream();
        }
        catch (IOException ioe) {
            if (!this.suppressErrorMessages) {
                log.error("ERROR: Could not establish connection to server " + this.host + " at port " + this.port + ": " + ioe.getMessage());
            }
            throw new IOException(ioe.getMessage());
        }
        this.nc = NCWrapperFactory.getInstance().createNetComm(in, out);
    }

    public CmdIF processCommandWithTimeout(CmdIF _outboundCommand) {
        return this.processCommand(_outboundCommand, true);
    }

    public CmdIF processCommand(CmdIF _outboundCommand) {
        return this.processCommand(_outboundCommand, false);
    }

    private CmdIF processCommand(CmdIF _outboundCommand, boolean withTimeout) {
        if (this.isClosed()) {
            return this.onCommunicationClosed();
        }
        try {
            trace.entering("processCommand(CmdIF " + _outboundCommand.getMyName() + ", withTimeout " + withTimeout + ")");
            CmdIF result = null;
            if (_outboundCommand != null) {
                boolean reply = true;
                if (_outboundCommand instanceof NoResponseCmdIF) {
                    reply = ((NoResponseCmdIF)_outboundCommand).reply();
                }
                CmdClientImpl.mytrace("sendAndReceive");
                result = this.sendAndReceive(CmdXMLFactory.getInstance(), _outboundCommand, withTimeout, reply);
                CmdClientImpl.mytrace("finshed sendAndReceive");
            }
            CmdIF cmdIF = result;
            Object var6_6 = null;
            trace.exiting();
            return cmdIF;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            trace.exiting();
            throw throwable;
        }
    }

    private CmdError onCommunicationClosed() {
        if (CmdClient.errorHandler != null) {
            CmdClient.errorHandler.onError();
        }
        return CmdErrorFactory.createCmdError("Connection between SDM client and server is broken");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized CmdIF sendAndReceive(CmdXMLFactory factory, CmdIF outboundCommand, boolean withTimeout, boolean receive) {
        CmdIF cmdIF;
        try {
            void var7_10;
            block7: {
                block6: {
                    trace.entering("sendAndReceive(CmdXMLFactory ...,CmdIF " + outboundCommand.getMyName() + ", withTimeout " + withTimeout + ", receive " + receive + ")");
                    CmdClientImpl.mytrace("xmlize");
                    String output = factory.getXMLizer(outboundCommand.getMyName()).toXMLString(outboundCommand);
                    CmdClientImpl.mytrace("xmlized --- start send and receive");
                    String input = null;
                    CmdClientImpl.mytrace("send String part");
                    this.nc.send(output);
                    CmdClientImpl.mytrace("finished sending string part");
                    Object var7_7 = null;
                    if (!receive) break block6;
                    CmdClientImpl.mytrace("receive String part from Server");
                    input = withTimeout ? this.receiveFromServerWithTimeout(this.nc, this.server) : this.receiveFromServer(this.nc);
                    if (input != null && !this.isIOExceptionThrown()) {
                        CmdClientImpl.mytrace("finished receiving String part from Server");
                        CmdIF cmdIF2 = factory.fromXmlString(input);
                        CmdClientImpl.mytrace("returning " + cmdIF2.getMyName());
                        CmdIF cmdIF3 = cmdIF2;
                        break block7;
                    } else {
                        CmdClientImpl.mytrace("connection was broken");
                        try {
                            this.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        CmdError cmdError = this.onCommunicationClosed();
                        Object var10_16 = null;
                        trace.exiting();
                        return cmdError;
                    }
                }
                CmdClientImpl.mytrace("returning CmdNoReply");
                CmdNoReply cmdNoReply = new CmdNoReply();
            }
            CmdClientImpl.mytrace("start post processing");
            CmdIF cmdIF4 = CmdClientPostProcessor.process(outboundCommand, (CmdIF)var7_10, this);
            CmdClientImpl.mytrace("finished post processing");
            cmdIF = cmdIF4;
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            trace.exiting();
            throw throwable;
        }
        Object var10_17 = null;
        trace.exiting();
        return cmdIF;
    }

    private String receiveFromServer(NetComm _nc) {
        try {
            trace.entering("receiveFromServer(NetComm ..)");
            StringBuffer inputBuffer = new StringBuffer(100);
            String oneInput = null;
            String result = null;
            this.ioExceptionThrown = false;
            boolean goon = true;
            do {
                try {
                    oneInput = _nc.receive();
                    if (oneInput.equals(_nc.getEOCS())) {
                        goon = false;
                        continue;
                    }
                    inputBuffer.append(oneInput);
                }
                catch (IOException ioe) {
                    System.err.println("An IOException occured while reading from the Server: " + ioe.getMessage());
                    this.ioExceptionThrown = true;
                    String string = null;
                    Object var9_9 = null;
                    trace.exiting();
                    return string;
                }
            } while (goon);
            String string = result = inputBuffer.toString();
            Object var9_10 = null;
            trace.exiting();
            return string;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            trace.exiting();
            throw throwable;
        }
    }

    private String receiveFromServerWithTimeout(NetComm _nc, NiSocket socket) {
        String string;
        trace.entering("receiveFromServerWithTimeout(NetComm ...)");
        int oldTimeout = 0;
        try {
            StringBuffer inputBuffer = new StringBuffer(100);
            String oneInput = null;
            String result = null;
            this.ioExceptionThrown = false;
            boolean goon = true;
            try {
                oldTimeout = socket.getSoTimeout();
                socket.setSoTimeout(loginTimeout);
            }
            catch (SocketException soE) {
                trace.debug("Caught SocketException: " + soE.getMessage());
                log.error("Caught SocketException: " + soE.getMessage());
                String string2 = null;
                Object var12_14 = null;
                try {
                    socket.setSoTimeout(oldTimeout);
                }
                catch (SocketException sE) {
                    trace.debug("Caught SocketException: " + sE.getMessage());
                    log.error("Caught SocketException: " + sE.getMessage());
                }
                trace.exiting();
                return string2;
            }
            do {
                try {
                    oneInput = _nc.receive();
                    if (oneInput.equals(_nc.getEOCS())) {
                        goon = false;
                        continue;
                    }
                    inputBuffer.append(oneInput);
                }
                catch (InterruptedIOException interruptE) {
                    this.ioExceptionThrown = true;
                    String string3 = null;
                    Object var12_15 = null;
                    try {
                        socket.setSoTimeout(oldTimeout);
                    }
                    catch (SocketException sE) {
                        trace.debug("Caught SocketException: " + sE.getMessage());
                        log.error("Caught SocketException: " + sE.getMessage());
                    }
                    trace.exiting();
                    return string3;
                }
                catch (IOException ioe) {
                    System.err.println("An IOException occured while reading from the Server: " + ioe.getMessage());
                    this.ioExceptionThrown = true;
                    String string4 = null;
                    Object var12_16 = null;
                    try {
                        socket.setSoTimeout(oldTimeout);
                    }
                    catch (SocketException sE) {
                        trace.debug("Caught SocketException: " + sE.getMessage());
                        log.error("Caught SocketException: " + sE.getMessage());
                    }
                    trace.exiting();
                    return string4;
                }
            } while (goon);
            string = result = inputBuffer.toString();
            Object var12_17 = null;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            try {
                socket.setSoTimeout(oldTimeout);
            }
            catch (SocketException sE) {
                trace.debug("Caught SocketException: " + sE.getMessage());
                log.error("Caught SocketException: " + sE.getMessage());
            }
            trace.exiting();
            throw throwable;
        }
        try {
            socket.setSoTimeout(oldTimeout);
        }
        catch (SocketException sE) {
            trace.debug("Caught SocketException: " + sE.getMessage());
            log.error("Caught SocketException: " + sE.getMessage());
        }
        trace.exiting();
        return string;
    }

    public boolean isIOExceptionThrown() {
        return this.ioExceptionThrown;
    }

    public boolean isClosed() {
        return this.server == null && this.nc == null;
    }

    public void close() throws IOException {
        this.server.close();
        this.server = null;
        this.nc = null;
    }

    private static void mytrace(String msg) {
        currentTime = System.currentTimeMillis();
        currentTimestamp = formatter.format(new Date(currentTime));
        trace.debug(currentTimestamp + "/" + (currentTime - lastTime) + " Client: " + msg);
        lastTime = currentTime;
    }

    public InputStream getInputStream() {
        return this.nc != null ? this.nc.getInputStream() : null;
    }

    public OutputStream getOutputStream() {
        return this.nc != null ? this.nc.getOutputStream() : null;
    }

    public CmdIF receive() {
        if (!this.isClosed()) {
            String strReceived = this.receiveFromServer(this.nc);
            if (strReceived != null) {
                return CmdXMLFactory.getInstance().fromXmlString(strReceived);
            }
            if (this.isIOExceptionThrown()) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.onCommunicationClosed();
            }
            return CmdErrorFactory.createCmdError("Not a valid data has been received!");
        }
        return this.onCommunicationClosed();
    }

    public CmdIF receiveWithTimeout() {
        if (!this.isClosed()) {
            String strReceived = this.receiveFromServerWithTimeout(this.nc, this.server);
            if (strReceived != null) {
                return CmdXMLFactory.getInstance().fromXmlString(strReceived);
            }
            if (this.isIOExceptionThrown()) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.onCommunicationClosed();
            }
            return CmdErrorFactory.createCmdError("Not a valid data has been received!");
        }
        return this.onCommunicationClosed();
    }

    public void send(CmdIF command) {
        String xmlizedCommand = CmdXMLFactory.getInstance().getXMLizer(command.getMyName()).toXMLString(command);
        this.nc.send(xmlizedCommand);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        lastTime = 0L;
        currentTime = 0L;
        currentTimestamp = null;
        formatter = new SimpleDateFormat("yyyyMMddHHmmss SSSS");
        formatter.setTimeZone(TimeZone.getDefault());
        lastTime = currentTime = System.currentTimeMillis();
        loginTimeout = 0;
    }
}

