/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.cmd;

import com.sap.sdm.is.cs.cmd.CmdError;
import com.sap.sdm.is.cs.cmd.CmdErrorFactory;
import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.cmd.CmdXMLizer;
import com.sap.sdm.is.stringxml.StringFinder;
import com.sap.sdm.util.log.Logger;
import java.util.HashMap;
import java.util.Map;

public final class CmdXMLFactory {
    private static final CmdXMLFactory INSTANCE = new CmdXMLFactory();
    private static final Logger log = Logger.getLogger();
    private final Map xmlizerMap = new HashMap();

    private CmdXMLFactory() {
    }

    public static CmdXMLFactory getInstance() {
        return INSTANCE;
    }

    public CmdIF fromXmlString(String xmlString) {
        String topElement = StringFinder.getNameOfTopXMLElement(xmlString);
        if (topElement == null) {
            CmdError resultCmd = CmdErrorFactory.createCmdError("CmdXmlFactory could not find Top Element within String: \"" + xmlString + "\".");
            return resultCmd;
        }
        CmdXMLizer xmlizer = (CmdXMLizer)this.xmlizerMap.get(topElement);
        if (xmlizer == null) {
            CmdError resultCmd = CmdErrorFactory.createCmdError("CmdXmlFactory got unknown XML element: \"" + topElement + "\".");
            return resultCmd;
        }
        try {
            return xmlizer.fromXMLString(xmlString);
        }
        catch (CmdReconstructionException xmlre) {
            String strErrMsg = "Error in command reconstruction. \nAdditional information: \n";
            StringBuffer sbErrMsg = new StringBuffer();
            sbErrMsg.append("CmdXmlFactory could not reconstruct the command: \"").append(topElement).append(". \nThe exception is: \"").append(xmlre.getMessage());
            log.error(strErrMsg + sbErrMsg.toString(), xmlre);
            CmdError errCmd = CmdErrorFactory.createCmdError(strErrMsg + xmlre.getMessage());
            return errCmd;
        }
    }

    public void addXmlizer(String topElementName, CmdXMLizer xmlizer) {
        this.xmlizerMap.put(topElementName, xmlizer);
    }

    public CmdXMLizer getXMLizer(String topElementName) {
        if (topElementName == null) {
            return null;
        }
        return (CmdXMLizer)this.xmlizerMap.get(topElementName);
    }
}

