/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.cmd;

import com.sap.sdm.is.cs.cmd.CmdErrorFactory;
import com.sap.sdm.is.cs.cmd.CmdErrorXMLizer;
import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.stringxml.StringFinder;
import com.sap.sdm.is.stringxml.StringPos;
import com.sap.sdm.util.log.Logger;
import com.sap.sdm.util.xml.XMLFilter;

public class CmdErrorXMLizerString
extends CmdErrorXMLizer {
    private static final CmdErrorXMLizer INSTANCE = new CmdErrorXMLizerString();
    private static final Logger log = Logger.getLogger();

    private CmdErrorXMLizerString() {
    }

    public static CmdErrorXMLizer getInstance() {
        return INSTANCE;
    }

    public CmdIF fromXMLString(String input) throws CmdReconstructionException {
        boolean wrongPasswordSupplied = false;
        String errText = null;
        StringPos textPos = null;
        try {
            StringPos excPos = StringFinder.findXMLElemOpen("Error", input);
            String wPS = StringFinder.findAttrForXMLElem("Error", input, "wP");
            if (wPS != null) {
                wrongPasswordSupplied = new Boolean(wPS);
            }
            textPos = StringFinder.findOptXMLElem("Er", input);
        }
        catch (Exception exc) {
            String strErrMsg = "CmdErrorXMLizerString could not reconstruct the command";
            StringBuffer sbErrMsg = new StringBuffer();
            sbErrMsg.append(strErrMsg).append(". \nThe exception is: \"").append(exc.getMessage());
            log.error(sbErrMsg.toString(), exc);
            throw new CmdReconstructionException(strErrMsg);
        }
        if (textPos != null) {
            errText = XMLFilter.checkAndFilterInput(input.substring(textPos.beginPos + 4, textPos.endPos));
        }
        return CmdErrorFactory.createCmdError(errText, wrongPasswordSupplied);
    }
}

