/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cache.impl;

import com.sap.sdm.is.cache.Cache;
import com.sap.sdm.util.log.Trace;
import java.util.HashMap;
import java.util.Map;

final class LruCache
implements Cache {
    private static final Trace trace = Trace.getTrace(class$com$sap$sdm$is$cache$impl$LruCache == null ? (class$com$sap$sdm$is$cache$impl$LruCache = LruCache.class$("com.sap.sdm.is.cache.impl.LruCache")) : class$com$sap$sdm$is$cache$impl$LruCache);
    private final int maxSize;
    private Map newMap = new HashMap();
    private Map oldMap = new HashMap();
    static /* synthetic */ Class class$com$sap$sdm$is$cache$impl$LruCache;

    LruCache(int maxSize) {
        this.maxSize = maxSize;
        trace.debug("LruCache created with maxSize=" + maxSize);
    }

    public synchronized Object put(Object key, Object value) {
        trace.debug("Associate key '" + key + "' to some value");
        Object previous = this.get(key);
        this.newMap.put(key, value);
        if (this.getCacheSize() >= this.maxSize) {
            trace.debug("Max cache size reached");
            this.rotateMaps();
        }
        return previous;
    }

    public synchronized Object get(Object key) {
        Object value;
        if (this.newMap.containsKey(key)) {
            trace.debug("Key '" + key + "' contained in new map");
            value = this.newMap.get(key);
        } else if (this.oldMap.containsKey(key)) {
            trace.debug("Key '" + key + "' contained in old map");
            value = this.oldMap.get(key);
            this.oldMap.remove(key);
            this.newMap.put(key, value);
        } else {
            trace.debug("Cache miss for key '" + key + "'");
            value = null;
        }
        return value;
    }

    private int getCacheSize() {
        return this.oldMap.size() + this.newMap.size();
    }

    private void rotateMaps() {
        trace.debug("Rotate maps. Old map: " + this.oldMap.size() + ", new map: " + this.newMap.size());
        Map tmp = this.newMap;
        this.oldMap = this.newMap;
        this.newMap = new HashMap();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

