/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.apiimpl.remote.client;

import com.sap.sdm.api.remote.Client;
import com.sap.sdm.api.remote.ClientSession;
import com.sap.sdm.api.remote.ClientSessionFactory;
import com.sap.sdm.api.remote.RemoteException;
import com.sap.sdm.api.remote.WrongPasswordException;
import com.sap.sdm.apiimpl.remote.client.APIRemoteExceptionImpl;
import com.sap.sdm.apiimpl.remote.client.APIWrongPasswordExceptionImpl;
import com.sap.sdm.is.cs.cmd.CmdError;
import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.client.CmdClient;
import com.sap.sdm.is.cs.cmd.client.CmdClientFactory;
import com.sap.sdm.is.cs.remoteproxy.client.CmdClientGetter;
import com.sap.sdm.is.cs.remoteproxy.client.ExceptionFactory;
import com.sap.sdm.is.cs.remoteproxy.client.ProxyLockHandler;
import com.sap.sdm.is.cs.remoteproxy.client.RemoteProxyClient;
import com.sap.sdm.is.cs.remoteproxy.client.RemoteProxyClientFactory;
import com.sap.sdm.is.cs.session.common.CmdCloseConnection;
import com.sap.sdm.is.cs.session.common.CmdCloseSession;
import com.sap.sdm.is.cs.session.common.CmdCloseSessionAccepted;
import com.sap.sdm.is.cs.session.common.CmdFactory;
import com.sap.sdm.is.cs.session.common.CmdLoginAccepted;
import com.sap.sdm.is.cs.session.common.CmdLoginRequest;
import com.sap.sdm.is.cs.session.common.CmdReopenConnection;
import com.sap.sdm.is.cs.session.common.CmdReopenConnectionAccepted;
import com.sap.sdm.is.security.SecurityFactory;
import com.sap.sdm.util.log.Trace;
import java.io.IOException;
import java.util.HashMap;

class APIClientSessionImpl
implements ClientSession {
    private static final Trace trace = Trace.getTrace(class$com$sap$sdm$apiimpl$remote$client$APIClientSessionImpl == null ? (class$com$sap$sdm$apiimpl$remote$client$APIClientSessionImpl = APIClientSessionImpl.class$("com.sap.sdm.apiimpl.remote.client.APIClientSessionImpl")) : class$com$sap$sdm$apiimpl$remote$client$APIClientSessionImpl);
    private static int STATEUNKNOWN = 1;
    private static int STATEACTIVE = 2;
    private static int STATEINACTIVE = 4;
    private static int STATECLOSED = 8;
    private static int TIMEOUT_DEFAULT = 30000;
    private boolean connectionOK = false;
    private CmdClient cmdClient = null;
    private String sessionID = null;
    private int apiServerVersion = -1;
    private int port = -1;
    private String host = null;
    private int loginTimeout = 30000;
    private int sessionState = STATEUNKNOWN;
    private RemoteProxyClient remoteProxyClient = null;
    private Client clientInstance = null;
    private static HashMap SDMServerToSession = new HashMap(1);
    private Object proxyLock = new Object();
    static /* synthetic */ Class class$com$sap$sdm$apiimpl$remote$client$APIClientSessionImpl;
    static /* synthetic */ Class class$com$sap$sdm$api$remote$Client;

    private static SDMServer getSDMServer(String host, int port) {
        return new SDMServer(host, port);
    }

    private APIClientSessionImpl(int remotePort, String remoteHost, String pw) throws RemoteException, WrongPasswordException {
        this.initData(remotePort, remoteHost, pw);
    }

    private void initData(int port, String host, String password) throws RemoteException, WrongPasswordException {
        trace.entering("initData(" + port + ", " + host + ")");
        try {
            boolean pwExceptionWanted;
            boolean isHashed;
            this.port = port;
            this.host = host;
            String initCommResult = this.initCommunication(host, port);
            if (initCommResult != null) {
                throw new APIRemoteExceptionImpl("Server " + host + " did not accept login request as admin on port " + port + ". Details: " + initCommResult);
            }
            this.connectionOK = true;
            if (password != null) {
                password = SecurityFactory.getInstance().createHashedString(password).getSHAString();
                isHashed = true;
                pwExceptionWanted = true;
            } else {
                password = "apisdm";
                isHashed = false;
                pwExceptionWanted = false;
            }
            CmdLoginRequest cmdLoginRequest = CmdFactory.createCmdLoginRequest(Integer.toString(ClientSessionFactory.getAPIClientVersion()), "apiadmin", password, isHashed, "", pwExceptionWanted);
            CmdIF answerCmd = this.cmdClient.processCommandWithTimeout(cmdLoginRequest);
            if (answerCmd == null || !(answerCmd instanceof CmdLoginAccepted)) {
                StringBuffer errText = new StringBuffer("Server ");
                errText.append(host);
                errText.append(" did not accept login request as apiadmin on port ");
                errText.append(String.valueOf(port));
                try {
                    this.cmdClient.close();
                }
                catch (IOException e) {
                    trace.debug("The socket connection could not be closed after unsuccessful login: " + e.getMessage());
                }
                if (answerCmd != null && answerCmd instanceof CmdError) {
                    errText.append(" - ");
                    errText.append(((CmdError)answerCmd).getErrorText());
                    if (((CmdError)answerCmd).isWrongPasswordSupplied()) {
                        throw new APIWrongPasswordExceptionImpl(errText.toString());
                    }
                    if (((CmdError)answerCmd).getErrorText().startsWith("Wrong password supplied")) {
                        throw new APIWrongPasswordExceptionImpl(errText.toString());
                    }
                } else {
                    errText.append(" - received unknown answer from server!");
                }
                throw new APIRemoteExceptionImpl(errText.toString());
            }
            CmdLoginAccepted login = (CmdLoginAccepted)answerCmd;
            this.sessionID = login.getSessionID();
            this.apiServerVersion = login.getAPIServerVersionAsInt();
            this.remoteProxyClient = RemoteProxyClientFactory.getInstance().createNewClient(this.sessionID, (class$com$sap$sdm$api$remote$Client == null ? (class$com$sap$sdm$api$remote$Client = APIClientSessionImpl.class$("com.sap.sdm.api.remote.Client")) : class$com$sap$sdm$api$remote$Client).getClassLoader(), new CmdClientGetterImpl(), new ProxyLockHandlerImpl(), new ExceptionFactory(){

                public Exception create(String message) {
                    return new APIRemoteExceptionImpl(message);
                }
            }, 100);
            this.sessionState = STATEACTIVE;
            this.clientInstance = null;
            Object var12_12 = null;
            trace.exiting("initData(" + port + ", " + host + ")");
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            trace.exiting("initData(" + port + ", " + host + ")");
            throw throwable;
        }
    }

    static synchronized ClientSession newInstance(int port, String host, String password, int lTimeout) throws RemoteException {
        try {
            return APIClientSessionImpl.newInstanceIDE(port, host, password, lTimeout);
        }
        catch (WrongPasswordException pwExc) {
            throw new APIRemoteExceptionImpl(pwExc.getMessage());
        }
    }

    static synchronized ClientSession newInstanceIDE(int port, String host, String password, int lTimeout) throws RemoteException, WrongPasswordException {
        SDMServer server = APIClientSessionImpl.getSDMServer(host, port);
        APIClientSessionImpl session = (APIClientSessionImpl)SDMServerToSession.get(server);
        if (session == null) {
            session = new APIClientSessionImpl(port, host, password);
            SDMServerToSession.put(server, session);
        } else if (session.sessionState == STATECLOSED) {
            session.initData(port, host, password);
        } else {
            if (session.sessionState == STATEACTIVE || session.sessionState == STATEINACTIVE) {
                throw new APIRemoteExceptionImpl("Another " + session.toString() + " is still valid - cannot create a new one");
            }
            throw new APIRemoteExceptionImpl(session.toString() + " has unknown state - cannot proceed");
        }
        session.loginTimeout = lTimeout;
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Client getClient() throws RemoteException {
        Client client;
        trace.entering("getClient()");
        try {
            try {
                if (this.sessionState == STATECLOSED) {
                    throw new APIRemoteExceptionImpl("This Session (" + this.sessionID + ") was invalidated and cannot be used anymore");
                }
                if (this.sessionState == STATEUNKNOWN) {
                    throw new APIRemoteExceptionImpl("This Session (" + this.sessionID + ") was not initialized properly and cannot be used");
                }
                if (this.clientInstance != null) {
                    Client client2 = this.clientInstance;
                    Object var3_4 = null;
                    trace.exiting("getClient()");
                    return client2;
                }
                this.reopenConnectionIfNeeded();
                client = this.clientInstance = (Client)this.remoteProxyClient.createInitialProxy((class$com$sap$sdm$api$remote$Client == null ? (class$com$sap$sdm$api$remote$Client = APIClientSessionImpl.class$("com.sap.sdm.api.remote.Client")) : class$com$sap$sdm$api$remote$Client).getName(), "create");
            }
            catch (Exception e) {
                throw new APIRemoteExceptionImpl(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            trace.exiting("getClient()");
            throw throwable;
        }
        Object var3_5 = null;
        trace.exiting("getClient()");
        return client;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void passivateSession() throws RemoteException {
        trace.entering("passivateSession()");
        try {
            if (this.sessionState == STATEINACTIVE) {
                Object var5_1 = null;
                trace.exiting("passivateSession()");
                return;
            }
            if (this.sessionState == STATECLOSED) {
                throw new APIRemoteExceptionImpl("This session (" + this.sessionID + ") was closed already - cannot close connection");
            }
            if (this.sessionState == STATEUNKNOWN) {
                throw new APIRemoteExceptionImpl("This session (" + this.sessionID + ") was not initialized properly - cannot close connection");
            }
            if (this.sessionState != STATEACTIVE) throw new APIRemoteExceptionImpl(this.toString() + " has unknown state - cannot proceed");
            CmdCloseConnection closeConnRequest = CmdFactory.createCmdCloseConnection(this.sessionID);
            CmdIF answerCmd = this.cmdClient.processCommand(closeConnRequest);
            if (answerCmd instanceof CmdError) {
                StringBuffer errText = new StringBuffer();
                errText.append("Could not close connection for session (");
                errText.append(this.sessionID);
                errText.append(") - ");
                errText.append(((CmdError)answerCmd).getErrorText());
                throw new APIRemoteExceptionImpl(errText.toString());
            }
            try {
                this.cmdClient.close();
            }
            catch (IOException e) {
                throw new APIRemoteExceptionImpl("The socket connection could not be closed: " + e.getMessage());
            }
            this.sessionState = STATEINACTIVE;
            this.cmdClient = null;
            this.connectionOK = false;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            trace.exiting("passivateSession()");
            throw throwable;
        }
        Object var5_2 = null;
        trace.exiting("passivateSession()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void closeSession() throws RemoteException {
        block7: {
            block6: {
                trace.entering("closeSession()");
                try {
                    if (this.sessionState == STATECLOSED) {
                        Object var5_1 = null;
                        trace.exiting("closeSession()");
                        this.sessionState = STATECLOSED;
                        SDMServerToSession.remove(APIClientSessionImpl.getSDMServer(this.host, this.port));
                        break block6;
                    }
                    if (this.sessionState != STATEACTIVE && this.sessionState != STATEINACTIVE) break block7;
                    this.reopenConnectionIfNeeded();
                    CmdCloseSession closeCall = CmdFactory.createCmdCloseSession(this.sessionID);
                    CmdIF answerCmd = this.cmdClient.processCommand(closeCall);
                    try {
                        this.cmdClient.close();
                    }
                    catch (IOException e) {
                        throw new APIRemoteExceptionImpl("The socket connection could not be closed: " + e.getMessage());
                    }
                    if (answerCmd instanceof CmdError) {
                        throw new APIRemoteExceptionImpl("Close session failed: " + ((CmdError)answerCmd).getErrorText());
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    trace.exiting("closeSession()");
                    this.sessionState = STATECLOSED;
                    SDMServerToSession.remove(APIClientSessionImpl.getSDMServer(this.host, this.port));
                    this.remoteProxyClient = null;
                    this.cmdClient = null;
                    this.connectionOK = false;
                    throw throwable;
                }
            }
            this.remoteProxyClient = null;
            this.cmdClient = null;
            this.connectionOK = false;
            return;
        }
        Object var5_2 = null;
        trace.exiting("closeSession()");
        this.sessionState = STATECLOSED;
        SDMServerToSession.remove(APIClientSessionImpl.getSDMServer(this.host, this.port));
        this.remoteProxyClient = null;
        this.cmdClient = null;
        this.connectionOK = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reopenConnectionIfNeeded() throws RemoteException {
        trace.entering("reopenConnectionIfNeeded()");
        try {
            if (this.sessionState == STATECLOSED) {
                throw new APIRemoteExceptionImpl("Session (" + this.sessionID + ") is closed - Connection cannot be reopened");
            }
            if (this.sessionState != STATEINACTIVE) {
                Object var6_1 = null;
                trace.exiting("reopenConnectionIfNeeded()");
                return;
            }
            String initCommResult = this.initCommunication(this.host, this.port);
            if (initCommResult != null) {
                throw new APIRemoteExceptionImpl("Server " + this.host + " did not accept reopen request as admin on port " + this.port + ". Details: " + initCommResult);
            }
            this.connectionOK = true;
            CmdReopenConnection reopenRequest = CmdFactory.createCmdReopenConnection(this.sessionID);
            CmdIF answerCmd = this.cmdClient.processCommand(reopenRequest);
            if (answerCmd instanceof CmdError) {
                StringBuffer errText = new StringBuffer();
                errText.append("Server ");
                errText.append(this.host);
                errText.append(" did not accept reopen request as apiadmin on port ");
                errText.append(String.valueOf(this.port));
                errText.append(" - ");
                errText.append(((CmdError)answerCmd).getErrorText());
                throw new APIRemoteExceptionImpl(errText.toString());
            }
            if (!(answerCmd instanceof CmdReopenConnectionAccepted)) throw new APIRemoteExceptionImpl("Server " + this.host + " did not accept reopen request as apiadmin on port " + this.port);
            this.sessionState = STATEACTIVE;
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            trace.exiting("reopenConnectionIfNeeded()");
            throw throwable;
        }
        Object var6_2 = null;
        trace.exiting("reopenConnectionIfNeeded()");
    }

    private String initCommunication(String host, int port) {
        trace.entering("initCommunication()");
        try {
            String lHost = host;
            if (lHost == null) {
                lHost = "localhost";
            }
            try {
                this.cmdClient = CmdClientFactory.getInstance().create(port, lHost, this.loginTimeout);
            }
            catch (IOException e) {
                String errText = "ERROR: Could not establish connection to server " + host + " at port " + port + ": " + e.getMessage();
                trace.debug(errText);
                String string = errText;
                Object var8_8 = null;
                trace.exiting("initCommunication()");
                return string;
            }
            String string = null;
            Object var8_9 = null;
            trace.exiting("initCommunication()");
            return string;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            trace.exiting("initCommunication()");
            throw throwable;
        }
    }

    public String toString() {
        return "Session=[Host:" + this.host + ", Port:" + this.port + ", SessionID:" + this.sessionID + "]";
    }

    protected void finalize() {
        CmdCloseSession closeCall;
        CmdIF answerCmd;
        try {
            super.finalize();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if ((this.sessionState == STATEACTIVE || this.sessionState == STATEINACTIVE) && (answerCmd = this.cmdClient.processCommand(closeCall = CmdFactory.createCmdCloseSession(this.sessionID))) != null && answerCmd instanceof CmdCloseSessionAccepted) {
            this.remoteProxyClient = null;
            this.sessionState = STATECLOSED;
            this.cmdClient = null;
            this.connectionOK = false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProxyLockHandlerImpl
    implements ProxyLockHandler {
        private ProxyLockHandlerImpl() {
        }

        public Object getLock() {
            return APIClientSessionImpl.this.proxyLock;
        }
    }

    private class CmdClientGetterImpl
    implements CmdClientGetter {
        private CmdClientGetterImpl() {
        }

        public CmdClient get() throws CmdClientGetter.Exception {
            try {
                APIClientSessionImpl.this.reopenConnectionIfNeeded();
                return APIClientSessionImpl.this.cmdClient;
            }
            catch (RemoteException e) {
                throw new CmdClientGetter.Exception(e.getMessage());
            }
        }
    }

    private static class SDMServer {
        int port;
        String host;

        public SDMServer(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SDMServer)) {
                return false;
            }
            SDMServer _obj = (SDMServer)obj;
            if (this.port != _obj.port) {
                return false;
            }
            return this.host.equals(_obj.host);
        }
    }
}

