/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.api.remote;

import com.sap.sdm.api.remote.ClientSession;
import com.sap.sdm.api.remote.RemoteException;
import com.sap.sdm.api.remote.WrongPasswordException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClientSessionFactory {
    private static final String IMPLCLASSNAME = "com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl";
    private static final String IMPLMETHODNAME = "createAPIClientSession";
    private static final String IMPLMETHODNAMEIDE = "createAPIClientSessionIDE";
    private static final Class[] IMPLPARAMARRNEW = new Class[]{Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = ClientSessionFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ClientSessionFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
    private static final int API_CLIENT_VERSION = 5;
    private static int loginTimeout = 30000;
    static /* synthetic */ Class class$java$lang$String;

    public static ClientSession createRemoteClientSession(int port, String host) throws RemoteException {
        return ClientSessionFactory.createRemoteClientSession(port, host, null);
    }

    public static ClientSession createRemoteClientSession(int port, String host, String password) throws RemoteException {
        ClientSession result = null;
        Class<?> factoryClass = null;
        ClientSessionFactory.checkHostAndPort(port, host);
        try {
            factoryClass = Class.forName(IMPLCLASSNAME);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException("Cannot load Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e1.getMessage());
        }
        Method factoryMethod = null;
        try {
            factoryMethod = factoryClass.getMethod(IMPLMETHODNAME, IMPLPARAMARRNEW);
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException("Cannot find Method createAPIClientSession of Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e2.getMessage());
        }
        try {
            result = (ClientSession)factoryMethod.invoke(null, new Integer(port), host, password, new Integer(loginTimeout));
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException("Exception occured while calling createAPIClientSession of Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e3.getMessage());
        }
        catch (InvocationTargetException e4) {
            if (e4.getTargetException() instanceof RemoteException) {
                throw (RemoteException)e4.getTargetException();
            }
            if (e4.getTargetException() != null) {
                throw new RuntimeException("Exception occured while calling createAPIClientSession of Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e4.getTargetException().getClass().getName() + ": " + e4.getTargetException().getMessage());
            }
            throw new RuntimeException("Exception occured while calling createAPIClientSession of Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e4.getMessage());
        }
        return result;
    }

    public static ClientSession createRemoteClientSessionIDE(int port, String host, String password) throws RemoteException, WrongPasswordException {
        ClientSession result = null;
        Class<?> factoryClass = null;
        ClientSessionFactory.checkHostAndPort(port, host);
        try {
            factoryClass = Class.forName(IMPLCLASSNAME);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException("Cannot load Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e1.getMessage());
        }
        Method factoryMethod = null;
        try {
            factoryMethod = factoryClass.getMethod(IMPLMETHODNAMEIDE, IMPLPARAMARRNEW);
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException("Cannot find Method createAPIClientSessionIDE of Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e2.getMessage());
        }
        try {
            result = (ClientSession)factoryMethod.invoke(null, new Integer(port), host, password, new Integer(loginTimeout));
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException("Exception occured while calling createAPIClientSession of Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e3.getMessage());
        }
        catch (InvocationTargetException e4) {
            if (e4.getTargetException() instanceof RemoteException) {
                throw (RemoteException)e4.getTargetException();
            }
            if (e4.getTargetException() instanceof WrongPasswordException) {
                throw (WrongPasswordException)e4.getTargetException();
            }
            if (e4.getTargetException() != null) {
                throw new RuntimeException("Exception occured while calling createAPIClientSession of Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e4.getTargetException().getClass().getName() + ": " + e4.getTargetException().getMessage());
            }
            throw new RuntimeException("Exception occured while calling createAPIClientSession of Class com.sap.sdm.apiimpl.remote.client.APIClientSessionFactoryImpl - " + e4.getMessage());
        }
        return result;
    }

    public static int getAPIClientVersion() {
        return 5;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static void setLoginTimeout(int newTimeout) {
        if (newTimeout < 0) {
            newTimeout = 0;
        }
        loginTimeout = newTimeout;
    }

    private static void checkHostAndPort(int port, String host) {
        if (host == null) {
            throw new NullPointerException("Cannot create a remote ClientSession with host \"null\"");
        }
        if (port < 0 || port > 65536) {
            throw new IllegalArgumentException("Cannot create a remote ClientSession with port \"" + port + "\"");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

