/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.ui.actions;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.UnaryElementCondition;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class OpenOnAction
extends AbstractSelectionAwareAction
implements IExecutableExtension {
    private String myTargetToOpenOn;
    private IWorkbenchPage myActivePage;
    private static final String SUFFIX_FOR_EJBS = "AsIType";
    private static final String SUFFIX_FOR_EJB_METHODS = "Method";
    private static final Collection EJB_METACLASSES = new HashSet<String>(Arrays.asList("com.tssap.j2ee.core.ejb.EntityBean", "com.tssap.j2ee.core.ejb.SessionBean", "com.tssap.j2ee.core.ejb.MessageDrivenBean"));
    private static final Collection EJB_METHOD_METACLASSES = new HashSet<String>(Arrays.asList("com.tssap.j2ee.core.ejb.method.Business", "com.tssap.j2ee.core.ejb.method.Create", "com.tssap.j2ee.core.ejb.method.Find", "com.tssap.j2ee.core.ejb.method.Home", "com.tssap.j2ee.core.ejb.method.Select"));
    static /* synthetic */ Class class$com$tssap$selena$model$elements$Element;

    protected boolean customIsEnabled() {
        if (this.getSelection() == null || this.getSelection().size() != 1) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryElementCondition(){

            public boolean check(Element element) {
                return OpenOnAction.this.canOpenOn(element);
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                Iterator elements = OpenOnAction.super.selectedModelElementsIterator();
                while (elements.hasNext()) {
                    Element curElement = (Element)elements.next();
                    OpenOnAction.this.openOn(curElement);
                }
            }
        });
    }

    private boolean canOpenOn(Element element) {
        String metaclass = element.getPropertyValue("$metaclass");
        if (OpenOnAction.isEjb(metaclass)) {
            Element desiredElement;
            IJavaElement javaElement = this.getTarget(element, SUFFIX_FOR_EJBS);
            if (javaElement != null && (desiredElement = (Element)javaElement.getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = OpenOnAction.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element)) != null) {
                return desiredElement.hasProperty("$source");
            }
            return false;
        }
        if (OpenOnAction.isEjbMethod(metaclass)) {
            return this.getTarget(element, SUFFIX_FOR_EJB_METHODS) != null;
        }
        if (OpenOnAction.isEjbField(metaclass)) {
            return "beanClass".equals(this.myTargetToOpenOn);
        }
        return false;
    }

    private void openOn(Element element) {
        String metaclass = element.getPropertyValue("$metaclass");
        IJavaElement javaElement = null;
        if (OpenOnAction.isEjb(metaclass)) {
            javaElement = this.getTarget(element, SUFFIX_FOR_EJBS);
        } else if (OpenOnAction.isEjbMethod(metaclass)) {
            javaElement = this.getTarget(element, SUFFIX_FOR_EJB_METHODS);
        }
        if (javaElement != null) {
            element = (Element)javaElement.getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = OpenOnAction.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
        }
        if (element != null) {
            ModelUIPlugin.getDefault().openEditor(element, this.myActivePage, true);
        }
    }

    private IJavaElement getTarget(Element element, String propertySuffix) {
        if ("beanClassPostMethod".equals(this.myTargetToOpenOn)) {
            return (IJavaElement)element.getObjectPropertyValue(this.myTargetToOpenOn);
        }
        return (IJavaElement)element.getObjectPropertyValue(this.myTargetToOpenOn + propertySuffix);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.myTargetToOpenOn = config.getAttribute("role");
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        super.setActivePart(action, targetPart);
        this.myActivePage = targetPart.getSite().getPage();
    }

    private static boolean isEjb(String metaclass) {
        return EJB_METACLASSES.contains(metaclass);
    }

    private static boolean isEjbMethod(String metaclass) {
        return EJB_METHOD_METACLASSES.contains(metaclass);
    }

    private static boolean isEjbField(String metaclass) {
        return "com.tssap.j2ee.core.ejb.field.Persistent".equals(metaclass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

