/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.viewmaps.web;

import com.tssap.j2ee.internal.core.viewmaps.compartments.GenericCompartment;
import com.tssap.j2ee.internal.core.viewmaps.compartments.GenericModelCompartments;
import com.tssap.j2ee.internal.core.viewmaps.compartments.OrderingByPropertyKeyboardSupport;
import com.tssap.j2ee.internal.core.viewmaps.compartments.PropertyComparator;
import com.tssap.j2ee.internal.core.viewmaps.web.Messages;
import java.util.HashMap;
import java.util.Map;

public class WebCompartments
extends GenericModelCompartments {
    public static final String SERVLET_COMPARTMENT = Messages.getString("WebModelCompartments.servlets");
    public static final String FILTER_COMPARTMENT = Messages.getString("WebModelCompartments.filters");
    public static final String LISTENER_COMPARTMENT = Messages.getString("WebModelCompartments.listeners");
    public static final String JSP_COMPARTMENT = Messages.getString("WebModelCompartments.jsps");
    public static final String HTML_COMPARTMENT = Messages.getString("WebModelCompartments.htmls");
    public static final String WEB_FOLDER_COMPARTMENT = Messages.getString("WebModelCompartments.web_folders");
    public static final String WEB_RESOURCE_COMPARTMENT = Messages.getString("WebModelCompartments.resources");
    public static final String WEB_METHOD_COMPARTMENT = Messages.getString("WebModelCompartments.web_methods");
    public static final String INIT_PARAM_COMPARTMENT = Messages.getString("WebModelCompartments.init_params");
    public static final String MAPPING_COMPARTMENT = Messages.getString("WebModelCompartments.mappings");
    public static final String SECURITY_ROLE_REF_COMPARTMENT = Messages.getString("WebModelCompartments.srr");
    private static final Map ourMetaclassCompartmentNames = new HashMap();

    public WebCompartments() {
    }

    public WebCompartments(String[] defaultCompartments) {
        super(defaultCompartments);
    }

    protected GenericCompartment createCompartment(String name) {
        GenericCompartment compartment = super.createCompartment(name);
        if (MAPPING_COMPARTMENT.equals(name)) {
            compartment.setComparator(new PropertyComparator("mappingOrder"));
            compartment.setOrdering(true);
            compartment.setKeyboardSupport(new OrderingByPropertyKeyboardSupport("mappingOrder"));
        }
        return compartment;
    }

    protected String getCompartmentName(String metaclass) {
        return (String)ourMetaclassCompartmentNames.get(metaclass);
    }

    static {
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.Servlet", SERVLET_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.Filter", FILTER_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.ServletContextAttributeListener", LISTENER_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.ServletContextListener", LISTENER_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.HttpSessionAttributeListener", LISTENER_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.HttpSessionActivationListener", LISTENER_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.HttpSessionBindingListener", LISTENER_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.HttpSessionListener", LISTENER_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.JSP", JSP_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.HTML", HTML_COMPARTMENT);
        ourMetaclassCompartmentNames.put("WebContentDiagram", WEB_FOLDER_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.Resource", WEB_RESOURCE_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.web.WebMethod", WEB_METHOD_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.webapp.InitParameter", INIT_PARAM_COMPARTMENT);
        ourMetaclassCompartmentNames.put("com.tssap.j2ee.core.webapp.SecurityRoleRefNode", SECURITY_ROLE_REF_COMPARTMENT);
    }
}

