/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.viewmaps.ejbjar;

import com.tssap.j2ee.internal.core.viewmaps.J2eeViewmapsPlugin;
import com.tssap.selena.draw2d.InvisibleRectangle;
import com.tssap.selena.gde.DefaultNodeViewMap;
import com.tssap.selena.gde.GdeListener;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.figures.GridBagLayout;
import com.tssap.selena.gde.viewmap.IViewMapParameters;
import com.tssap.selena.internal.viewmaps.EditorSupport;
import com.tssap.selena.internal.viewmaps.GridBagConstraintsUtil;
import com.tssap.selena.internal.viewmaps.figures.NameLabel;
import com.tssap.selena.internal.viewmaps.figures.shadows.ShadowShape;
import com.tssap.selena.model.elements.PropertyMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.Color;

public class ContainerTransactionViewMap
extends DefaultNodeViewMap {
    public IFigure createFigure(ModelElementEditPart editPart, IViewMapParameters parameters) {
        ModelNodeEditPart modelNodeEditPart = (ModelNodeEditPart)editPart;
        modelNodeEditPart.addGdeListener((GdeListener)new EditorSupport((ModelElementEditPart)modelNodeEditPart));
        InvisibleRectangle mainFigure = new InvisibleRectangle();
        mainFigure.setLayoutManager((LayoutManager)new GridBagLayout());
        ContainerTransactionShape ct = new ContainerTransactionShape((PropertyMap)modelNodeEditPart.getElement(), this.is3dLook(modelNodeEditPart), this.getBackgroundColor((ModelElementEditPart)modelNodeEditPart, parameters, ColorConstants.white), this.getForegroundColor((ModelElementEditPart)modelNodeEditPart, parameters, ColorConstants.black), J2eeViewmapsPlugin.getPreferredSize(parameters));
        mainFigure.add((IFigure)ct, (Object)GridBagConstraintsUtil.vertically((boolean)true));
        NameLabel name = new NameLabel((PropertyMap)this.getModelElement((GraphicalEditPart)editPart), "transactionAttribute");
        mainFigure.add((IFigure)name, (Object)GridBagConstraintsUtil.vertically((boolean)false));
        return mainFigure;
    }

    private static class ContainerTransactionShape
    extends ShadowShape {
        private static final float DEFAULT_W2H_RATIO = 0.71428573f;
        private static final int BASE_SIZE = 5;

        public ContainerTransactionShape(PropertyMap propertyMap, boolean dLook, Color backGround, Color foreGround, Dimension preferredSize) {
            super(dLook, backGround, foreGround);
            if (preferredSize != null) {
                this.setW2HRatio((float)preferredSize.width / (float)preferredSize.height);
            } else {
                this.setW2HRatio(0.71428573f);
            }
        }

        protected void outlineShape(Graphics graphics, Rectangle bounds) {
            Cube cube = new Cube(bounds);
            graphics.drawPolygon(cube.getFrontFace());
            graphics.drawPolygon(cube.getTopFace());
            graphics.drawPolygon(cube.getRightFace());
            this.drawLeftArrow(graphics, cube);
            this.drawRightArrow(graphics, cube);
        }

        protected void fillShape(Graphics graphics, Rectangle bounds) {
            Cube cube = new Cube(bounds);
            graphics.fillPolygon(cube.getFrontFace());
            graphics.fillPolygon(cube.getTopFace());
            graphics.fillPolygon(cube.getRightFace());
        }

        private void drawLeftArrow(Graphics graphics, Cube cube) {
            PointList pl = this.getArrow(1);
            Point p = new Point(cube.getLeftBound(), cube.getBaseH() + cube.getTopOffset() + 5);
            pl.translate(p);
            this.drawArrowPolygon(graphics, pl);
            graphics.setLineWidth(2);
            graphics.drawLine(p, new Point(p.x + cube.getCubeBase(), p.y));
        }

        private void drawRightArrow(Graphics graphics, Cube cube) {
            PointList pl = this.getArrow(-1);
            Point p = new Point(cube.getLeftBound() + cube.getTotalWidth(), cube.getBaseH() + cube.getTopOffset() - 5);
            pl.translate(p);
            this.drawArrowPolygon(graphics, pl);
            graphics.setLineWidth(2);
            graphics.drawLine(p, new Point(cube.getLeftBound() + cube.getCubeBase() / 2, p.y));
        }

        private void drawArrowPolygon(Graphics graphics, PointList pl) {
            Color old = graphics.getBackgroundColor();
            graphics.setBackgroundColor(graphics.getForegroundColor());
            graphics.fillPolygon(pl);
            graphics.setBackgroundColor(old);
        }

        private PointList getArrow(int scaledOrientation) {
            int t = Math.abs(scaledOrientation);
            PointList pl = new PointList(3);
            pl.addPoint(0, 0);
            pl.addPoint(scaledOrientation * 5, t * 5);
            pl.addPoint(scaledOrientation * 5, -5 * t);
            return pl;
        }

        private static class Cube {
            private final int myCubeBase;
            private final int myBaseH;
            private final Rectangle myBounds;
            private static final int CUBE_PERSPECTIVE_DIVIDER = 3;

            private Cube(Rectangle bounds) {
                this.myCubeBase = Math.min(bounds.height / 2, bounds.width / 2);
                this.myBaseH = (bounds.height - this.getTotalWidth()) / 2;
                this.myBounds = bounds;
            }

            int getBaseH() {
                return this.myBaseH;
            }

            int getCubeBase() {
                return this.myCubeBase;
            }

            int getLeftBound() {
                return this.myBounds.x + this.myCubeBase / 4;
            }

            int getTopOffset() {
                return this.myBounds.y;
            }

            int getTotalWidth() {
                return this.myCubeBase + this.getPerspectiveWidth();
            }

            int getPerspectiveWidth() {
                return this.myCubeBase / 3;
            }

            PointList getFrontFace() {
                PointList rv = new PointList(4);
                rv.addPoint(0, this.myBounds.height - this.myCubeBase);
                rv.addPoint(this.myCubeBase, this.myBounds.height - this.myCubeBase);
                rv.addPoint(this.myCubeBase, this.myBounds.height);
                rv.addPoint(0, this.myBounds.height);
                rv.translate(this.getLeftBound(), this.getTopOffset());
                return rv;
            }

            PointList getTopFace() {
                PointList rv = new PointList(4);
                rv.addPoint(0, this.myBounds.height - this.myCubeBase);
                rv.addPoint(this.myCubeBase / 2, this.myBounds.height - this.getTotalWidth());
                rv.addPoint(this.getTotalWidth(), this.myBounds.height - this.getTotalWidth());
                rv.addPoint(this.myCubeBase, this.myBounds.height - this.myCubeBase);
                rv.translate(this.getLeftBound(), this.getTopOffset());
                return rv;
            }

            PointList getRightFace() {
                PointList rv = new PointList(4);
                rv.addPoint(this.myCubeBase, this.myBounds.height - this.myCubeBase);
                rv.addPoint(this.getTotalWidth(), this.myBounds.height - this.getTotalWidth());
                rv.addPoint(this.getTotalWidth(), this.myBounds.height - this.getPerspectiveWidth());
                rv.addPoint(this.myCubeBase, this.myBounds.height);
                rv.translate(this.getLeftBound(), this.getTopOffset());
                return rv;
            }
        }
    }
}

