/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.viewmaps.compartments;

import com.tssap.j2ee.internal.core.viewmaps.compartments.GenericCompartment;
import com.tssap.j2ee.internal.core.viewmaps.compartments.ListPositionShifter;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.events.KeyEvent;

public class NavigationKeyboardSupport
implements GenericCompartment.KeyboardSupport {
    private static NavigationKeyboardSupport ourInstance;

    protected NavigationKeyboardSupport() {
    }

    public static NavigationKeyboardSupport getInstance() {
        if (ourInstance == null) {
            ourInstance = new NavigationKeyboardSupport();
        }
        return ourInstance;
    }

    public boolean keyPressed(KeyEvent event, GraphicalEditPart selectedPart, GenericCompartment compartment) {
        return (0x40000 & event.stateMask) == 0 && (0x1000001 == event.keyCode ? this.handleArrowUp(event, selectedPart, compartment) : (0x1000002 == event.keyCode ? this.handleArrowDown(event, selectedPart, compartment) : (0x1000007 == event.keyCode ? this.handleHome(event, selectedPart, compartment) : 0x1000008 == event.keyCode && this.handleEnd(event, selectedPart, compartment))));
    }

    protected boolean handleArrowUp(KeyEvent event, GraphicalEditPart selectedPart, GenericCompartment compartment) {
        return this.navigate(ListPositionShifter.UP, event, selectedPart, compartment);
    }

    protected boolean handleArrowDown(KeyEvent event, GraphicalEditPart selectedPart, GenericCompartment compartment) {
        return this.navigate(ListPositionShifter.DOWN, event, selectedPart, compartment);
    }

    protected boolean handleHome(KeyEvent event, GraphicalEditPart selectedPart, GenericCompartment compartment) {
        return this.navigate(ListPositionShifter.TOP, event, selectedPart, compartment);
    }

    protected boolean handleEnd(KeyEvent event, GraphicalEditPart selectedPart, GenericCompartment compartment) {
        return this.navigate(ListPositionShifter.BOTTOM, event, selectedPart, compartment);
    }

    protected boolean navigate(ListPositionShifter shifter, KeyEvent event, GraphicalEditPart selectedPart, GenericCompartment compartment) {
        IFigure figure = selectedPart.getFigure();
        if (figure == null) {
            return false;
        }
        List children = compartment.getChildren();
        if (children == null || children.isEmpty()) {
            return false;
        }
        int i = children.indexOf(figure);
        if ((i = shifter.nextPosition(children, i)) < 0 || i > children.size() - 1) {
            return false;
        }
        figure = (IFigure)children.get(i);
        EditPartViewer viewer = selectedPart.getRoot().getViewer();
        Map map = viewer.getVisualPartMap();
        if (map == null || map.isEmpty()) {
            return false;
        }
        EditPart part = (EditPart)map.get(figure);
        if (part == null) {
            return false;
        }
        if (!this.apply(event, viewer, (EditPart)selectedPart, part)) {
            return false;
        }
        compartment.scrollTo(figure);
        return true;
    }

    protected boolean apply(KeyEvent event, EditPartViewer viewer, EditPart selectedPart, EditPart part) {
        if ((0x20000 & event.stateMask) > 0) {
            if (viewer.getSelectedEditParts().contains(part)) {
                viewer.deselect(selectedPart);
            } else {
                viewer.appendSelection(part);
            }
        } else {
            viewer.select(part);
        }
        return true;
    }
}

