/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.viewmaps.compartments;

import com.tssap.j2ee.internal.core.viewmaps.compartments.GenericCompartment;
import com.tssap.selena.draw2d.layouts.ShrinkablePileLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.events.MouseEvent;

public class GenericCompartments
extends Figure {
    private Map myCompartments;

    private final void init() {
        super.setLayoutManager((LayoutManager)new ShrinkablePileLayout());
    }

    public GenericCompartments() {
        this.init();
    }

    public GenericCompartments(String[] defaultCompartments) {
        this.init();
        if (defaultCompartments != null) {
            int dci = 0;
            while (dci < defaultCompartments.length) {
                this.getCompartment(defaultCompartments[dci]);
                ++dci;
            }
        }
    }

    public void setLayoutManager(LayoutManager lm) {
        throw new UnsupportedOperationException();
    }

    public final GenericCompartment getCompartment(String name) {
        GenericCompartment compartment;
        if (this.myCompartments == null) {
            this.myCompartments = this.createCompartmentsContainer();
        }
        if ((compartment = (GenericCompartment)this.myCompartments.get(name)) == null) {
            compartment = this.createCompartment(name);
            this.myCompartments.put(name, compartment);
        }
        return compartment;
    }

    protected Map createCompartmentsContainer() {
        return new HashMap();
    }

    protected GenericCompartment createCompartment(String name) {
        return new GenericCompartment((IFigure)this, name);
    }

    public GenericCompartment getCompartment(IFigure figure) {
        if (this.myCompartments == null) {
            return null;
        }
        Iterator compartments = this.myCompartments.values().iterator();
        while (compartments.hasNext()) {
            GenericCompartment compartment = (GenericCompartment)compartments.next();
            if (!compartment.containsFigure(figure)) continue;
            return compartment;
        }
        return null;
    }

    public void setDecorationsVisible(boolean visible) {
        if (this.myCompartments == null) {
            return;
        }
        Iterator compartments = this.myCompartments.values().iterator();
        while (compartments.hasNext()) {
            ((GenericCompartment)compartments.next()).setDecorationsVisible(visible);
        }
    }

    public boolean propagateMouseReleased(MouseEvent me) {
        if (this.myCompartments == null) {
            return false;
        }
        Iterator compartments = this.myCompartments.values().iterator();
        while (compartments.hasNext()) {
            GenericCompartment compartment = (GenericCompartment)compartments.next();
            if (!compartment.handleMouseReleased(me)) continue;
            return true;
        }
        return false;
    }

    protected final Map getCompartments() {
        return this.myCompartments;
    }
}

