/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.viewmaps.compartments;

import com.tssap.j2ee.internal.core.viewmaps.compartments.GenericCompartment;
import com.tssap.j2ee.internal.core.viewmaps.compartments.GenericCompartments;
import com.tssap.selena.gde.ModelNodeEditPart;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.KeyHandler;
import org.eclipse.swt.events.KeyEvent;

public final class GenericCompartmentKeyHandler
extends KeyHandler {
    private final EditPartViewer myViewer;
    private static Map ourHookedViewers = new WeakHashMap();

    public static void hook(EditPartViewer viewer) {
        if (ourHookedViewers.containsKey(viewer)) {
            return;
        }
        GenericCompartmentKeyHandler handler = new GenericCompartmentKeyHandler(viewer);
        handler.setParent(viewer.getKeyHandler());
        viewer.setKeyHandler((KeyHandler)handler);
    }

    private GenericCompartmentKeyHandler(EditPartViewer viewer) {
        this.myViewer = viewer;
    }

    public boolean keyPressed(KeyEvent event) {
        EditPart part = this.getSelectedEditPart();
        if (!(part instanceof GraphicalEditPart)) {
            return super.keyPressed(event);
        }
        IFigure figure = ((GraphicalEditPart)part).getFigure();
        if (figure == null) {
            return super.keyPressed(event);
        }
        GenericCompartments compartments = GenericCompartmentKeyHandler.getCompartments(part.getParent());
        if (compartments == null) {
            return super.keyPressed(event);
        }
        GenericCompartment compartment = compartments.getCompartment(figure);
        if (compartment == null) {
            return super.keyPressed(event);
        }
        GenericCompartment.KeyboardSupport support = compartment.getKeyboardSupport();
        if (support != null && support.keyPressed(event, (GraphicalEditPart)part, compartment)) {
            return true;
        }
        return super.keyPressed(event);
    }

    protected static GenericCompartments getCompartments(EditPart part) {
        if (!(part instanceof ModelNodeEditPart)) {
            return null;
        }
        IFigure content = ((ModelNodeEditPart)part).getContentPane();
        if (!(content instanceof GenericCompartments)) {
            return null;
        }
        return (GenericCompartments)content;
    }

    protected EditPart getSelectedEditPart() {
        List parts = this.myViewer.getSelectedEditParts();
        int i = parts.size() - 1;
        while (i >= 0) {
            EditPart part = (EditPart)parts.get(i);
            if (part.getSelected() == 2) {
                return part;
            }
            --i;
        }
        return null;
    }
}

