/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.viewmaps.compartments;

import com.tssap.j2ee.internal.core.viewmaps.compartments.CompartmentLabel;
import com.tssap.j2ee.internal.core.viewmaps.compartments.NavigationKeyboardSupport;
import com.tssap.selena.draw2d.InvisibleRectangle;
import com.tssap.selena.draw2d.layouts.ShrinkablePileLayout;
import com.tssap.selena.internal.viewmaps.figures.compartments.CompartmentScrollPane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class GenericCompartment {
    private IFigure myParent;
    private IFigure myMarker;
    private IFigure myGlue;
    private CompartmentLabel myLabel;
    private ScrollPane myChildrenPane;
    private IFigure myChildren;
    private Comparator myComparator;
    private boolean myOrdering;
    private KeyboardSupport myKeyboardSupport = NavigationKeyboardSupport.getInstance();
    private static final Border BOTTOM_FIX = new MarginBorder(0, 0, 1, 0);

    public GenericCompartment(IFigure parent, String name) {
        this.myParent = parent;
        this.myMarker = new MarkerFigure();
        this.myParent.add(this.myMarker);
        this.myLabel = new CompartmentLabel(name, true);
        this.myLabel.setDecorationsVisible(false);
        FlowLayout layout = new FlowLayout(false);
        layout.setFill(true);
        layout.setMajorSpacing(0);
        layout.setMinorSpacing(0);
        this.myChildren = this.createChildrenContainer();
        this.myChildren.setLayoutManager((LayoutManager)layout);
        this.myGlue = new GlueFigure();
        this.myChildren.add(this.myGlue);
        this.myChildrenPane = new CompartmentScrollPane();
        this.myChildrenPane.setHorizontalScrollBarVisibility(0);
        this.myChildrenPane.setView(this.myChildren);
        this.myChildrenPane.getViewport().setBorder(BOTTOM_FIX);
    }

    protected IFigure createChildrenContainer() {
        return new ShrinkableFigure();
    }

    public String getName() {
        return this.myLabel.getText();
    }

    public void setDecorationsVisible(boolean visible) {
        this.myLabel.setDecorationsVisible(visible);
    }

    public void toggle() {
        this.myLabel.toggle();
        this.update();
    }

    public List getChildren() {
        List children = this.myChildren.getChildren();
        if (!(children instanceof CopiedArrayList)) {
            children = new CopiedArrayList(children);
        }
        children.remove(this.myGlue);
        return children;
    }

    public boolean isEmpty() {
        return this.myChildren.getChildren().size() == 1;
    }

    public void scrollTo(IFigure figure) {
        if (!this.containsFigure(figure)) {
            return;
        }
        if (this.myChildrenPane.getParent() == null) {
            return;
        }
        Rectangle window = this.myChildrenPane.getBounds();
        Rectangle internal = figure.getBounds();
        if (internal.y < window.y) {
            int y = this.myChildrenPane.getViewport().getVerticalRangeModel().getValue();
            this.myChildrenPane.scrollVerticalTo(y -= window.y - internal.y);
            return;
        }
        int internalBottom = internal.y + internal.height;
        int windowBottom = window.y + window.height;
        if (internalBottom > windowBottom && internal.height <= window.height) {
            int y = this.myChildrenPane.getViewport().getVerticalRangeModel().getValue();
            this.myChildrenPane.scrollVerticalTo(y += internalBottom - windowBottom);
            return;
        }
    }

    public boolean containsFigure(IFigure figure) {
        return this.myChildren.getChildren().contains(figure);
    }

    public final void add(IFigure figure, Object constraint) {
        this.add(figure, constraint, -1);
    }

    public final void add(IFigure figure) {
        this.add(figure, null, -1);
    }

    public final void add(IFigure figure, int index) {
        this.add(figure, null, index);
    }

    public void add(IFigure figure, Object constraints, int index) {
        if (!this.myLabel.isOn()) {
            this.myLabel.toggle();
        }
        this.myChildren.add(figure, constraints, index);
        this.update();
    }

    public void addAfter(IFigure figure, IFigure reference) {
        if (!this.myLabel.isOn()) {
            this.myLabel.toggle();
        }
        GenericCompartment.addAfter(this.myChildren, figure, reference, null);
        this.update();
    }

    private static void addAfter(IFigure container, IFigure figure, IFigure reference, Object constraint) {
        if (reference == null) {
            container.add(figure, constraint, 0);
            return;
        }
        List children = container.getChildren();
        int referenceIndex = children.indexOf(reference);
        container.add(figure, constraint, referenceIndex < 0 ? -1 : referenceIndex + 1);
    }

    public void remove(IFigure figure) {
        this.myChildren.remove(figure);
        this.update();
    }

    boolean handleMouseReleased(MouseEvent me) {
        if (this.myLabel.getParent() == null) {
            return false;
        }
        if (!this.myLabel.isDecorationsVisible()) {
            return false;
        }
        if (me.button != 1) {
            return false;
        }
        Point el = new Point(me.x, me.y);
        this.myLabel.translateToRelative((Translatable)el);
        if (!this.myLabel.getIconBounds().contains(el)) {
            return false;
        }
        this.toggle();
        return true;
    }

    protected void update() {
        if (this.isEmpty()) {
            this.removeChildren();
            this.removeLabel();
        } else {
            this.addLabel();
            if (this.myLabel.isOn()) {
                this.addChildren();
            } else {
                this.removeChildren();
            }
        }
    }

    protected void addLabel() {
        if (this.myLabel.getParent() == null) {
            GenericCompartment.addAfter(this.myParent, (IFigure)this.myLabel, this.myMarker, null);
        }
    }

    protected void addChildren() {
        if (this.myChildrenPane.getParent() == null) {
            GenericCompartment.addAfter(this.myParent, (IFigure)this.myChildrenPane, (IFigure)this.myLabel, this.myChildren);
        }
    }

    protected void removeLabel() {
        if (this.myLabel.getParent() != null) {
            this.myParent.remove((IFigure)this.myLabel);
        }
    }

    protected void removeChildren() {
        if (this.myChildrenPane.getParent() != null) {
            this.myParent.remove((IFigure)this.myChildrenPane);
        }
    }

    protected final IFigure getParent() {
        return this.myParent;
    }

    protected final CompartmentLabel getLabel() {
        return this.myLabel;
    }

    protected final IFigure getChildrenContainer() {
        return this.myChildren;
    }

    public final Comparator getComparator() {
        return this.myComparator;
    }

    public void setComparator(Comparator comparator) {
        this.myComparator = comparator;
    }

    public final boolean isOrdering() {
        return this.myOrdering;
    }

    public void setOrdering(boolean ordering) {
        this.myOrdering = ordering;
    }

    public final KeyboardSupport getKeyboardSupport() {
        return this.myKeyboardSupport;
    }

    public void setKeyboardSupport(KeyboardSupport support) {
        this.myKeyboardSupport = support;
    }

    public static interface KeyboardSupport {
        public boolean keyPressed(KeyEvent var1, GraphicalEditPart var2, GenericCompartment var3);
    }

    public class ShrinkableFigure
    extends Figure
    implements ShrinkablePileLayout.ShrinkableConstraint {
        public boolean canShrink() {
            return ShrinkableFigure.super.getChildren().size() > 2;
        }

        public List getChildren() {
            List children = ShrinkableFigure.super.getChildren();
            if (!GenericCompartment.this.myOrdering) {
                return children;
            }
            children = new CopiedArrayList(children);
            try {
                Collections.sort(children, GenericCompartment.this.myComparator);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return children;
        }
    }

    public static class MarkerFigure
    extends InvisibleRectangle {
        private static final Dimension SIZE = new Dimension(0, 0);

        public MarkerFigure() {
            this.setSize(SIZE);
        }

        public Dimension getMinimumSize() {
            return SIZE;
        }

        public Dimension getMaximumSize() {
            return SIZE;
        }

        public Dimension getPreferredSize() {
            return SIZE;
        }

        public Dimension getPreferredSize(int w, int h) {
            return SIZE;
        }
    }

    private static class GlueFigure
    extends InvisibleRectangle {
        private GlueFigure() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.getParent().getBounds().width, 0);
        }
    }

    private static class CopiedArrayList
    extends ArrayList {
        public CopiedArrayList(List list) {
            super(list);
        }
    }
}

