/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.viewmaps;

import com.tssap.selena.gde.DefaultNodeViewMap;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.viewmap.IViewMapParameters;
import com.tssap.selena.internal.model.ui.navigator.ModelLabelProvider;
import com.tssap.selena.internal.viewmaps.figures.TextLabel;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import java.util.Comparator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class InnerViewMapBase
extends DefaultNodeViewMap {
    public static final String NO_IMAGE_PARAMETER = "noImage";
    protected static ModelLabelProvider ourLabelProvider = new ModelLabelProvider();
    protected static final Comparator ourComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = ((TextLabel)o1).getText();
            String s2 = ((TextLabel)o2).getText();
            return s1.compareTo(s2);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    private static final MarginBorder ICON_BORDER = new MarginBorder(0, 3, 0, 3);

    public IFigure createFigure(final ModelElementEditPart editPart, final IViewMapParameters parameters) {
        Entity resolved;
        ModelNodeEditPart modelNodeEditPart = (ModelNodeEditPart)editPart;
        final Boolean noImage = Boolean.valueOf(parameters.get(NO_IMAGE_PARAMETER));
        String text = this.getDecorationText((GraphicalEditPart)editPart, parameters);
        Image image = null;
        if (!noImage.booleanValue()) {
            image = this.getDecorationImage((GraphicalEditPart)editPart);
        }
        TextLabel mainFigure = new TextLabel(text, image){

            public void validate() {
                String mayBeNewText;
                Image mayBeNewImage;
                super.validate();
                if (!noImage.booleanValue() && !this.equalsExt(mayBeNewImage = InnerViewMapBase.this.getDecorationImage((GraphicalEditPart)editPart), this.getIcon())) {
                    this.setIcon(mayBeNewImage);
                }
                if (!this.equalsExt(mayBeNewText = InnerViewMapBase.this.getDecorationText((GraphicalEditPart)editPart, parameters), this.getText())) {
                    this.setText(mayBeNewText);
                }
            }

            private boolean equalsExt(Object ob1, Object ob2) {
                return ob1 == null ? ob2 == null : ob1.equals(ob2);
            }

            public String toString() {
                return "[" + ((Object)((Object)this)).hashCode() + "]:" + this.getText();
            }
        };
        mainFigure.setFont(this.getDecorationFont());
        if (this.inplaceRequired() && !(resolved = InnerViewMapBase.resolve((GraphicalEditPart)modelNodeEditPart)).hasProperty("$special") && !resolved.hasProperty("$readOnly")) {
            this.registerInplace((IFigure)mainFigure, (ModelElementEditPart)modelNodeEditPart, this.getRenameProperty(parameters), "rename");
        }
        mainFigure.setBorder((Border)ICON_BORDER);
        return mainFigure;
    }

    private String getRenameProperty(IViewMapParameters parameters) {
        if (parameters == null) {
            return "$name";
        }
        String result = parameters.get("$renameProperty");
        if (result == null) {
            return "$name";
        }
        return result;
    }

    private String getDisplayNameProperty(IViewMapParameters parameters) {
        if (parameters == null) {
            return "$name";
        }
        String result = parameters.get("$displayProperty");
        if (result == null) {
            return this.getRenameProperty(parameters);
        }
        return result;
    }

    protected Image getDecorationImage(GraphicalEditPart editPart) {
        Entity modelElement = InnerViewMapBase.resolve(editPart);
        if (modelElement == null || modelElement.isDeleted()) {
            return null;
        }
        return ourLabelProvider.getImage((Object)modelElement);
    }

    protected String getDecorationText(GraphicalEditPart editPart, IViewMapParameters parameters) {
        Entity modelElement = InnerViewMapBase.resolve(editPart);
        String textProperty = this.getDisplayNameProperty(parameters);
        String text = modelElement.getPropertyValue(textProperty);
        return text;
    }

    protected Font getDecorationFont() {
        return JFaceResources.getDefaultFont();
    }

    protected boolean inplaceRequired() {
        return true;
    }

    protected static Entity resolve(GraphicalEditPart ep) {
        Reference reference = (Reference)ep.getModel();
        return reference.getEntity();
    }

    public static Comparator getComparator() {
        return ourComparator;
    }
}

