/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.viewmaps;

import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.selena.gde.DefaultNodeViewMap;
import com.tssap.selena.gde.EditPartElementWrapper;
import com.tssap.selena.gde.GdeListener;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.viewmap.IViewMapParameters;
import com.tssap.selena.internal.model.ui.navigator.ModelLabelProvider;
import com.tssap.selena.internal.viewmaps.DiagramSupport;
import com.tssap.selena.internal.viewmaps.figures.shadows.ShadowShape;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ArchiveViewMap
extends DefaultNodeViewMap {
    private static final String[] DISPLAY_NAME_PROPS = new String[]{"displayName", "displayName", "displayName", "$name"};

    public IFigure createFigure(ModelElementEditPart editPart, IViewMapParameters parameters) {
        ModelNodeEditPart modelNodeEditPart = (ModelNodeEditPart)editPart;
        JarShape mainFigure = new JarShape(this.getJarEntity(modelNodeEditPart), this.is3dLook(modelNodeEditPart), this.getBackgroundColor((ModelElementEditPart)modelNodeEditPart, parameters, ColorConstants.white), this.getForegroundColor((ModelElementEditPart)modelNodeEditPart, parameters, ColorConstants.black));
        modelNodeEditPart.addGdeListener((GdeListener)new DiagramSupport(modelNodeEditPart, (IFigure)mainFigure){

            protected ReferenceCollection getDiagramToOpen() {
                Entity ar = new EditPartElementWrapper((ModelElementEditPart)this.myEP).getResolvedElement();
                if (ar.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.ejbjar.EjbJar")) {
                    return EjbJarModelMetaInfo.getAssociatedReferenceCollection((Entity)ar);
                }
                if (ar.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.webapp.WebApp")) {
                    return WebAppModelMetaInfo.getAssociatedReferenceCollection((Entity)ar);
                }
                String diagramUin = ar.getPropertyValue("DiagramUIN");
                if (diagramUin == null) {
                    return null;
                }
                return ar.getModel().findReferenceCollection(ModelAccess.createUniqueName((String)diagramUin));
            }
        });
        return mainFigure;
    }

    private Entity getJarEntity(ModelNodeEditPart modelNodeEditPart) {
        return ((Reference)modelNodeEditPart.getElement()).getEntity();
    }

    private class JarShape
    extends ShadowShape {
        private static final float BASE_W = 100.0f;
        private static final float BASE_H = 120.0f;
        private static final int GAP = 3;
        private static final String DOTS = "...";
        private Entity myPropertyMap;

        public JarShape(Entity propertyMap, boolean dLook, Color backGround, Color foreGround) {
            super(dLook, backGround, foreGround);
            this.setKeepingProportions(true);
            this.setW2HRatio(0.8333333f);
            this.myPropertyMap = propertyMap;
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, 120);
        }

        protected void outlineShape(Graphics graphics, Rectangle bounds) {
            PointList pl = this.getShapePoints(bounds);
            graphics.drawPolygon(pl);
        }

        protected void fillShape(Graphics graphics, Rectangle bounds) {
            PointList pl = this.getShapePoints(bounds);
            graphics.fillPolygon(pl);
            this.drawTitle(graphics, bounds);
        }

        protected void drawTitle(Graphics graphics, Rectangle bounds) {
            ModelLabelProvider labelProvider = new ModelLabelProvider();
            Image icon = labelProvider.getImage((Object)this.myPropertyMap);
            org.eclipse.swt.graphics.Rectangle iconBounds = icon != null ? icon.getBounds() : new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
            String name = null;
            int i = 0;
            while (name == null && i < DISPLAY_NAME_PROPS.length) {
                name = this.myPropertyMap.getPropertyValue(DISPLAY_NAME_PROPS[i]);
                ++i;
            }
            Dimension nameBounds = FigureUtilities.getTextExtents(name, (Font)this.getFont());
            int TEXT_H = nameBounds.height;
            nameBounds.width += 3;
            nameBounds.width += iconBounds.width;
            nameBounds.height = Math.max(nameBounds.height, iconBounds.height);
            int W_OFF = (bounds.width - nameBounds.width) / 2;
            int H_OFF = (bounds.height - nameBounds.height) / 2;
            Dimension dotsBounds = null;
            if (W_OFF < 3) {
                W_OFF = 0;
                dotsBounds = FigureUtilities.getTextExtents((String)DOTS, (Font)this.getFont());
                nameBounds.width = bounds.width - dotsBounds.width - 6;
                if (nameBounds.width < 3) {
                    throw new RuntimeException("Insufficient space");
                }
            }
            graphics.pushState();
            int x = bounds.x + W_OFF + 3;
            int y = bounds.y + H_OFF;
            graphics.setClip(new Rectangle(x, y, nameBounds.width, nameBounds.height));
            if (icon != null) {
                graphics.drawImage(icon, x, y);
            }
            graphics.drawText(name, x += iconBounds.width + 3, y += (nameBounds.height - TEXT_H) / 2);
            if (dotsBounds != null) {
                x = bounds.x + bounds.width - (dotsBounds.width + 3);
                graphics.setClip(new Rectangle(x, y, dotsBounds.width, nameBounds.height));
                graphics.drawText(DOTS, x, y);
            }
            graphics.popState();
        }

        protected PointList getShapePoints(Rectangle rect) {
            int P_NUM = 6;
            int[] xPoints = new int[12];
            int[] yPoints = new int[12];
            int W = rect.width / 2;
            int H = rect.height;
            int R = (int)((float)W * 0.15f);
            int S = (int)((float)W * 0.3f);
            xPoints[0] = W;
            yPoints[0] = 0;
            xPoints[1] = W;
            yPoints[1] = R;
            xPoints[2] = W - S;
            yPoints[2] = R + S;
            xPoints[3] = W;
            yPoints[3] = R + 2 * S;
            xPoints[4] = W;
            yPoints[4] = H - S;
            xPoints[5] = W - S;
            yPoints[5] = H;
            int i = 0;
            while (i < 6) {
                xPoints[11 - i] = -xPoints[i];
                yPoints[11 - i] = yPoints[i];
                ++i;
            }
            int i2 = 0;
            while (i2 < 12) {
                int n = i2;
                xPoints[n] = xPoints[n] + W;
                int n2 = i2;
                xPoints[n2] = xPoints[n2] + rect.x;
                int n3 = i2++;
                yPoints[n3] = yPoints[n3] + rect.y;
            }
            PointList pl = new PointList(12);
            int i3 = 0;
            while (i3 < 12) {
                pl.addPoint(xPoints[i3], yPoints[i3]);
                ++i3;
            }
            return pl;
        }
    }
}

