/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.commands;

import com.tssap.j2ee.internal.commands.IllegalCommandSourceFlagsException;
import com.tssap.j2ee.internal.commands.LinkCommandSource;
import com.tssap.j2ee.internal.commands.LinkCommandSourceAdapter;
import com.tssap.j2ee.internal.commands.LinkCommandSourceExt;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public final class LinkCommandFactory {
    public static final int IS_CONNECTION_CREATE = 1;
    public static final int IS_CONNECTION_COMPLETE = 2;
    public static final int IS_REDIRECT_SOURCE = 4;
    public static final int IS_REDIRECT_TARGET = 8;
    private static final int[] myIndex2Flags = new int[]{1, 2, 4, 8};
    private static final Map myMap = new HashMap();
    private static final LinkCommandSource NULL_SOURCE = new LinkCommandSourceAdapter(){
        private final String ID = "NULL_SOURCE";
    };

    public static Command getConnectionCreateCommand(String linkMetaclass, CreateConnectionRequest request) {
        return LinkCommandFactory.getCommandSource(linkMetaclass, 1).getConnectionCreateCommand(request);
    }

    public static Command getConnectionCompleteCommand(String linkMetaclass, CreateConnectionRequest request) {
        return LinkCommandFactory.getCommandSource(linkMetaclass, 2).getConnectionCompleteCommand(request);
    }

    public static Command getReconnectSourceCommand(String linkMetaclass, ReconnectRequest request) {
        return LinkCommandFactory.getCommandSource(linkMetaclass, 2).getReconnectSourceCommand(request);
    }

    public static Command getReconnectTargetCommand(String linkMetaclass, ReconnectRequest request) {
        return LinkCommandFactory.getCommandSource(linkMetaclass, 2).getReconnectTargetCommand(request);
    }

    public static int getExistingSourceFlags(String metaclass) {
        LinkCommandSource[] installed = (LinkCommandSource[])myMap.get(metaclass);
        if (installed == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < myIndex2Flags.length) {
            if (installed[i] != null) {
                result |= myIndex2Flags[i];
            }
            ++i;
        }
        return result;
    }

    public static void installCommandSource(String metaclass, int flags, LinkCommandSource source) throws IllegalCommandSourceFlagsException {
        LinkCommandSource[] installed = (LinkCommandSource[])myMap.get(metaclass);
        if (installed == null) {
            installed = new LinkCommandSource[myIndex2Flags.length];
            myMap.put(metaclass, installed);
        }
        LinkCommandFactory.update(installed, flags, source);
    }

    public static void installCommandSource(LinkCommandSourceExt source) throws IllegalCommandSourceFlagsException {
        LinkCommandFactory.installCommandSource(source.getLinkMetaclass(), source.getFlags(), source);
    }

    public static LinkCommandSource getCommandSource(String linkMetaclass, int flag) {
        LinkCommandSource[] installed = (LinkCommandSource[])myMap.get(linkMetaclass);
        if (installed == null) {
            return NULL_SOURCE;
        }
        return LinkCommandFactory.find(installed, flag);
    }

    private static void update(LinkCommandSource[] installed, int flagsToInstall, LinkCommandSource sourceToInstall) throws IllegalCommandSourceFlagsException {
        int i = 0;
        while (i < myIndex2Flags.length) {
            if ((flagsToInstall & myIndex2Flags[i]) != 0) {
                if (installed[i] != null && sourceToInstall != null) {
                    throw new IllegalCommandSourceFlagsException(myIndex2Flags[i], installed[i], sourceToInstall);
                }
                installed[i] = sourceToInstall;
            }
            ++i;
        }
    }

    private static LinkCommandSource find(LinkCommandSource[] installed, int flag) {
        int i = 0;
        while (i < myIndex2Flags.length) {
            if (myIndex2Flags[i] == flag) {
                return installed[i] != null ? installed[i] : NULL_SOURCE;
            }
            ++i;
        }
        return NULL_SOURCE;
    }
}

