/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CharStreamException;
import antlr.CodeGenerator;
import antlr.ExceptionHandler;
import antlr.ExceptionSpec;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaBlockFinishingInfo;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RecognitionException;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.SatherCharFormatter;
import antlr.StringLiteralElement;
import antlr.StringLiteralSymbol;
import antlr.SynPredBlock;
import antlr.Token;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.TokenStreamException;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.actions.sather.ActionLexer;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SatherCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean genAST = false;
    protected boolean saveText = false;
    String labeledElementType;
    String labeledElementASTType;
    String labeledElementInit;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String lt1Value;
    String exceptionThrown;
    String throwNoViable;
    RuleBlock currentRule;
    String currentASTResult;
    Hashtable treeVariableMap = new Hashtable();
    int astVarNumber = 1;
    protected static final String NONUNIQUE = new String();
    public static final int caseSizeThreshold = 127;
    private Vector semPreds;
    private static int satherBlockId = 0;

    public SatherCodeGenerator() {
        this.charFormatter = new SatherCharFormatter();
    }

    protected int addSemPred(String predicate) {
        this.semPreds.appendElement(predicate);
        return this.semPreds.size() - 1;
    }

    public void exitIfError() {
        if (this.tool.hasError) {
            System.out.println("Exiting due to errors.");
            System.exit(1);
        }
    }

    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setGrammarAnalyzer(this.analyzer);
                g.setCodeGenerator(this);
                this.analyzer.setGrammar(g);
                this.setupGrammarParameters(g);
                g.generate();
                this.exitIfError();
            }
            Enumeration tmIter = this.behavior.tokenManagers.elements();
            while (tmIter.hasMoreElements()) {
                TokenManager tm = (TokenManager)tmIter.nextElement();
                if (!tm.isReadOnly()) {
                    this.genTokenTypes(tm);
                    this.genTokenInterchange(tm);
                }
                this.exitIfError();
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void gen(ActionElement action) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAction(" + action + ")");
        }
        if (action.isSemPred) {
            this.genSemPred(action.actionText, action.line);
        } else {
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            ActionTransInfo tInfo = new ActionTransInfo();
            String actionStr = this.processActionForTreeSpecifiers(action.actionText, action.getLine(), this.currentRule, tInfo);
            if (tInfo.refRuleRoot != null) {
                this.println(tInfo.refRuleRoot + " := current_ast.root;");
            }
            this.printAction(actionStr);
            if (tInfo.assignToRoot) {
                this.println("current_ast.root := " + tInfo.refRuleRoot + ";");
                this.println("if ( ~void( " + tInfo.refRuleRoot + " ) and ~void( " + tInfo.refRuleRoot + ".first_child ) ) then");
                ++this.tabs;
                this.println("current_ast.child := " + tInfo.refRuleRoot + ".first_child");
                --this.tabs;
                this.println("else");
                ++this.tabs;
                this.println("current_ast.child := " + tInfo.refRuleRoot + ";");
                --this.tabs;
                this.println("end; -- if");
                this.println("current_ast.advance_child_to_end;");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("end; -- if");
            }
        }
    }

    public void gen(AlternativeBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen(" + blk + ")");
        }
        this.genBlockPreamble(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, true);
        this.genBlockFinish(howToFinish, this.throwNoViable);
        this.println("");
        this.currentASTResult = saveCurrentASTResult;
    }

    public void gen(BlockEndElement end) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleEnd(" + end + ")");
        }
    }

    public void gen(CharLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genChar(" + atom + ")");
        }
        if (atom.getLabel() != null) {
            this.println(atom.getLabel() + " := " + this.lt1Value + ";");
        }
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
    }

    public void gen(CharRangeElement r) {
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " := " + this.lt1Value + ";");
        }
        this.println("match_range( " + r.beginText + ", " + r.endText + " );");
    }

    public void gen(LexerGrammar g) throws IOException {
        GrammarSymbol sym;
        Enumeration ids;
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof LexerGrammar)) {
            Tool.panic("Internal error generating lexer");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println(this.grammar.preambleAction.getText());
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass : "ANTLR_CHAR_SCANNER{TOKEN}";
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + "{TOKEN} < $ANTLR_TOKEN_STREAM{TOKEN} , $ANTLR_FILE_CURSOR is ");
        ++this.tabs;
        this.println("include " + sup + " create -> private char_scanner_create;");
        this.println("include " + this.grammar.tokenManager.getName() + "_TOKENTYPES;");
        this.println("");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("create ( istr : $ISTREAM ) : SAME is");
        ++this.tabs;
        this.println("inp : ANTLR_BYTE_BUFFER := #ANTLR_BYTE_BUFFER( istr );");
        this.println("res : SAME := #SAME( inp );");
        this.println("res.EOF_CHAR := istr.eof_char;");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( bb : ANTLR_BYTE_BUFFER ) : SAME is");
        ++this.tabs;
        this.println("state : ANTLR_LEXER_SHARED_INPUT_STATE := #ANTLR_LEXER_SHARED_INPUT_STATE( bb );");
        this.println("res: SAME := #SAME( state );");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( state : ANTLR_LEXER_SHARED_INPUT_STATE ) : SAME is ");
        ++this.tabs;
        this.println("res : SAME := char_scanner_create( state );");
        this.println("res.literals := #MAP{STR,INT};");
        Enumeration keys = this.grammar.tokenManager.getTokenSymbolKeys();
        while (keys.hasMoreElements()) {
            TokenSymbol sym2;
            String key = (String)keys.nextElement();
            if (key.charAt(0) != '\"' || !((sym2 = this.grammar.tokenManager.getTokenSymbol(key)) instanceof StringLiteralSymbol)) continue;
            StringLiteralSymbol s = (StringLiteralSymbol)sym2;
            this.println("res.literals[ " + s.getId() + " ] := " + s.getTokenType() + ";");
        }
        this.println("res.case_sensitive_literals := " + g.caseSensitiveLiterals + ";");
        this.println("res.case_sensitive := " + g.caseSensitive + ";");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        if (this.grammar.debuggingOutput) {
            this.println("private const sa_rule_names : ARRAY{STR} := |");
            ids = this.grammar.rules.elements();
            boolean ruleNum = false;
            while (ids.hasMoreElements()) {
                sym = (GrammarSymbol)ids.nextElement();
                if (!(sym instanceof RuleSymbol)) continue;
                this.println("  \"" + ((RuleSymbol)sym).getId() + "\",");
            }
            this.println("|;");
        }
        this.genNextToken();
        ids = this.grammar.rules.elements();
        int ruleNum = 0;
        while (ids.hasMoreElements()) {
            sym = (RuleSymbol)ids.nextElement();
            if (!sym.getId().equals("mnextToken")) {
                this.genRule((RuleSymbol)sym, false, ruleNum++);
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.println("");
        --this.tabs;
        this.println("end; -- class");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(OneOrMoreBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen+(" + blk + ")");
        }
        this.genBlockPreamble(blk);
        String cnt = blk.getLabel() != null ? SatherCodeGenerator.getNextSatherPrefix() + "_cnt_" + blk.getLabel() : SatherCodeGenerator.getNextSatherPrefix() + "_cnt" + blk.ID;
        this.println(cnt + " : INT := 0;");
        this.println("loop");
        ++this.tabs;
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)+ loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("-- nongreedy exit test");
            this.println("if ( " + cnt + " >= 1 and " + predictExit + " ) then break! end; -- if");
        }
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "if ( " + cnt + " >= 1 ) then break! else " + this.throwNoViable + " end; -- if");
        this.println(cnt + " := " + cnt + " + 1;");
        --this.tabs;
        this.println("end; -- loop");
        this.currentASTResult = saveCurrentASTResult;
    }

    public void gen(ParserGrammar g) throws IOException {
        GrammarSymbol sym;
        int ruleNum;
        Enumeration ids;
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof ParserGrammar)) {
            Tool.panic("Internal error generating parser");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println(this.grammar.preambleAction.getText());
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass.toUpperCase() : "ANTLR_" + this.grammar.getSuperClass().toUpperCase();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + "{ TOKEN < $ANTLR_TOKEN, AST < $ANTLR_AST{AST} } is");
        ++this.tabs;
        this.println("include " + sup + "{ TOKEN, " + this.labeledElementASTType + " } create -> super_create;");
        this.println("include " + this.grammar.tokenManager.getName() + "_" + CodeGenerator.TokenTypesFileSuffix.toUpperCase() + ";");
        this.println("");
        if (this.grammar.debuggingOutput) {
            this.println("const sa_rule_names : ARRAY{STR} := |");
            ids = this.grammar.rules.elements();
            ruleNum = 0;
            while (ids.hasMoreElements()) {
                sym = (GrammarSymbol)ids.nextElement();
                if (!(sym instanceof RuleSymbol)) continue;
                this.println("  \"" + ((RuleSymbol)sym).getId() + "\",");
            }
            this.println("|;");
        }
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("");
        this.println("create ( token_buf : ANTLR_TOKEN_BUFFER{TOKEN} , k : INT ) : SAME is");
        ++this.tabs;
        this.println("res : SAME := super_create( token_buf, k );");
        this.println("res.token_names := sa_token_names;");
        if (this.grammar.debuggingOutput) {
            this.println("res.rule_names  := sa_rule_names;");
            this.println("res.sem_pred_names := sa_sem_pred_names;");
            this.println("res.setup_debugging( token_buf );");
        }
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( token_buf : ANTLR_TOKEN_BUFFER{TOKEN} ) : SAME is");
        ++this.tabs;
        this.println("return #SAME( token_buf, " + this.grammar.maxk + ");");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( lexer : $ANTLR_TOKEN_STREAM{TOKEN} , k : INT ) : SAME is");
        ++this.tabs;
        this.println("res : SAME := super_create( lexer, k );");
        this.println("res.token_names := sa_token_names;");
        if (this.grammar.debuggingOutput) {
            this.println("res.rule_names := sa_rule_names;");
            this.println("res.sem_pred_names := sa_sem_pred_names;");
            this.println("res.setup_debugging( lexer );");
        }
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create( lexer : $ANTLR_TOKEN_STREAM{TOKEN} ) : SAME is");
        ++this.tabs;
        this.println("res : SAME := #SAME( lexer, " + this.grammar.maxk + ");");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( state : ANTLR_PARSER_SHARED_INPUT_STATE{TOKEN} ) : SAME is ");
        ++this.tabs;
        this.println("res : SAME := super_create( state," + this.grammar.maxk + ");");
        this.println("res.token_names := sa_token_names;");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        ids = this.grammar.rules.elements();
        ruleNum = 0;
        while (ids.hasMoreElements()) {
            sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRule(rs, rs.references.size() == 0, ruleNum++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.println("");
        --this.tabs;
        this.println("end; -- class");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement rr) {
        RuleSymbol rs;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRR(" + rr + ")");
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule)) == null || !rs.isDefined()) {
            this.tool.error("Rule '" + rr.targetRule + "' is not defined", this.grammar.getFilename(), rr.getLine());
            return;
        }
        if (!(rs instanceof RuleSymbol)) {
            this.tool.error("'" + rr.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), rr.getLine());
            return;
        }
        this.genErrorTryForElement(rr);
        if (this.grammar instanceof TreeWalkerGrammar && rr.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println("if ( SYS::is_eq( sa_t , " + this.labeledElementASTType + "::ASTNULL ) ) then");
            ++this.tabs;
            this.println(rr.getLabel() + " := void;");
            --this.tabs;
            this.println("else");
            this.println(rr.getLabel() + " := " + this.lt1Value + ";");
            this.println("end; -- if");
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("sa_save_index := text.length;");
        }
        this.printTabs();
        if (rr.idAssign != null) {
            if (rs.block.returnAction == null) {
                Tool.warning("Rule '" + rr.targetRule + "' has no return type", this.grammar.getFilename(), rr.getLine());
            }
            this._print(rr.idAssign + ":=");
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && rs.block.returnAction != null) {
            Tool.warning("Rule '" + rr.targetRule + "' returns a value", this.grammar.getFilename(), rr.getLine());
        }
        this.GenRuleInvocation(rr);
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("text := text.substring( 0, sa_save_index); -- truncate");
        }
        if (this.syntacticPredLevel == 0) {
            boolean doNoGuessTest;
            boolean bl = doNoGuessTest = this.grammar.hasSyntacticPredicate && (this.grammar.buildAST && rr.getLabel() != null || this.genAST && rr.getAutoGenType() == 1);
            if (doNoGuessTest) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            if (this.grammar.buildAST && rr.getLabel() != null) {
                this.println(rr.getLabel() + "_ast := return_ast;");
            }
            if (this.genAST) {
                switch (rr.getAutoGenType()) {
                    case 1: {
                        this.println("current_ast.add_child( return_ast );");
                        break;
                    }
                    case 2: {
                        this.tool.error("Internal: encountered ^ after rule reference");
                        break;
                    }
                }
            }
            if (this.grammar instanceof LexerGrammar && rr.getLabel() != null) {
                this.println(rr.getLabel() + " := sa_return_token;");
            }
            if (doNoGuessTest) {
                --this.tabs;
                this.println("end;");
            }
        }
        this.genErrorCatchForElement(rr);
    }

    public void gen(StringLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genString(" + atom + ")");
        }
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " := " + this.lt1Value + ";");
        }
        this.genElementAST(atom);
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa_t.next_sibling;");
        }
    }

    public void gen(TokenRangeElement r) {
        this.genErrorTryForElement(r);
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " := " + this.lt1Value + ";");
        }
        this.genElementAST(r);
        this.println("match_range( " + r.beginText + ", " + r.endText + " );");
        this.genErrorCatchForElement(r);
    }

    public void gen(TokenRefElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genTokenRef(" + atom + ")");
        }
        if (this.grammar instanceof LexerGrammar) {
            Tool.panic("Token reference found in lexer");
        }
        this.genErrorTryForElement(atom);
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " := " + this.lt1Value + ";");
        }
        this.genElementAST(atom);
        this.genMatch(atom);
        this.genErrorCatchForElement(atom);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa_t.next_sibling;");
        }
    }

    public void gen(TreeElement t) {
        this.println("sa__t" + t.ID + " : " + this.labeledElementASTType + " := sa_t;");
        if (t.root.getLabel() != null) {
            this.println("if ( SYS::is_eq( sa_t , AST::ASTNULL ) ) then");
            ++this.tabs;
            this.println(t.root.getLabel() + " := void;");
            this.println("else");
            this.println(t.root.getLabel() + " := sa_t;");
            this.println("end; -- if");
        }
        this.genElementAST(t.root);
        if (this.grammar.buildAST) {
            this.println("sa__current_ast" + t.ID + " : ANTLR_AST_PAIR{AST} := current_ast.copy;");
            this.println("current_ast.root := current_ast.child;");
            this.println("current_ast.child := void;");
        }
        this.genMatch(t.root);
        this.println("sa_t := sa_t.first_child;");
        int i = 0;
        while (i < t.getAlternatives().size()) {
            Alternative a = t.getAlternativeAt(i);
            AlternativeElement e = a.head;
            while (e != null) {
                e.generate();
                e = e.next;
            }
            ++i;
        }
        if (this.grammar.buildAST) {
            this.println("current_ast := sa__current_ast" + t.ID + ";");
        }
        this.println("sa_t := sa__t" + t.ID + ";");
        this.println("sa_t := sa_t.next_sibling;");
    }

    public void gen(TreeWalkerGrammar g) throws IOException {
        this.setGrammar(g);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            Tool.panic("Internal error generating tree-walker");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println(this.grammar.preambleAction.getText());
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass.toUpperCase() : "ANTLR_TREE_PARSER";
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + "{AST < $ANTLR_AST{AST} } is");
        this.println("");
        ++this.tabs;
        this.println("include " + sup + "{" + this.labeledElementASTType + "} create -> tree_parser_create;");
        this.println("include " + this.grammar.tokenManager.getName() + "_" + CodeGenerator.TokenTypesFileSuffix.toUpperCase() + ";");
        this.println("");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("attr token_names : ARRAY{STR};");
        this.println("");
        this.println("create : SAME is");
        ++this.tabs;
        this.println("res : SAME := tree_parser_create;");
        this.println("res.token_names := sa_token_names;");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        Enumeration ids = this.grammar.rules.elements();
        int ruleNum = 0;
        String ruleNameInits = "";
        while (ids.hasMoreElements()) {
            GrammarSymbol sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRule(rs, rs.references.size() == 0, ruleNum++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        --this.tabs;
        this.println("end; -- class");
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wc) {
        if (wc.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(wc.getLabel() + " := " + this.lt1Value + ";");
        }
        this.genElementAST(wc);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("if ( void(sa_t) ) then");
            ++this.tabs;
            this.println("raise #ANTLR_MISMATCHED_TOKEN_EXCEPTION;");
            --this.tabs;
            this.println("end;");
        } else if (this.grammar instanceof LexerGrammar) {
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("sa_save_index := text.length;");
            }
            this.println("match_not(EOF_CHAR);");
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("text := text.substring( 0 , sa_save_index);");
            }
        } else {
            this.println("match_not(" + this.getValueString(1) + ");");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa_t.next_sibling;");
        }
    }

    public void gen(ZeroOrMoreBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen*(" + blk + ")");
        }
        this.genBlockPreamble(blk);
        if (blk.getLabel() != null) {
            String label = blk.getLabel();
        } else {
            String label = "_loop" + blk.ID;
        }
        this.println("loop");
        ++this.tabs;
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)* loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("-- nongreedy exit test");
            this.println("if ( " + predictExit + " ) then break! end; -- if");
        }
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "break!;");
        --this.tabs;
        this.println("end; -- loop ");
        this.currentASTResult = saveCurrentASTResult;
    }

    protected void genAlt(Alternative alt, AlternativeBlock blk) {
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && alt.getAutoGen();
        boolean oldsaveTest = this.saveText;
        this.saveText = this.saveText && alt.getAutoGen();
        Hashtable saveMap = this.treeVariableMap;
        this.treeVariableMap = new Hashtable();
        if (alt.exceptionSpec != null) {
            this.println("protect -- for error handling");
            ++this.tabs;
        }
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            elem = elem.next;
        }
        if (this.genAST) {
            if (blk instanceof RuleBlock) {
                RuleBlock rblk = (RuleBlock)blk;
                this.println(rblk.getRuleName() + "_ast := current_ast.root;");
            } else if (blk.getLabel() != null) {
                // empty if block
            }
        }
        if (alt.exceptionSpec != null) {
            --this.tabs;
            this.genErrorHandler(alt.exceptionSpec);
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        this.treeVariableMap = saveMap;
    }

    protected void genBitsets(Vector bitsetList, int maxVocabulary) {
        SatherCharFormatter satherCharFormatter = new SatherCharFormatter();
        this.println("");
        if (this.grammar instanceof LexerGrammar) {
            int i = 0;
            while (i < bitsetList.size()) {
                BitSet p = (BitSet)bitsetList.elementAt(i);
                p.growToInclude(maxVocabulary);
                String boolList = satherCharFormatter.BitSet2BoolList(p, ", ");
                String bitsetName = "sa" + this.getBitsetName(i);
                String bitsetData = bitsetName + "_data_";
                this.println("const " + bitsetData + " : ARRAY{BOOL} := " + "| " + boolList + " |;");
                this.println("const " + bitsetName + " : CHAR_SET := bitset( " + bitsetData + " );");
                ++i;
            }
        } else {
            int i = 0;
            while (i < bitsetList.size()) {
                BitSet p = (BitSet)bitsetList.elementAt(i);
                p.growToInclude(maxVocabulary);
                String charList = satherCharFormatter.BitSet2IntList(p, ", ");
                String bitsetName = "sa" + this.getBitsetName(i);
                String bitsetData = bitsetName + "_data_";
                this.println("const " + bitsetData + " : ARRAY{INT} := " + "| " + charList + " |;");
                this.println("const " + bitsetName + " : INT_SET := int_set( " + bitsetData + " );");
                ++i;
            }
        }
    }

    private void genBlockFinish(JavaBlockFinishingInfo howToFinish, String noViableAction) {
        if (howToFinish.needAnErrorClause && (howToFinish.generatedAnIf || howToFinish.generatedSwitch)) {
            if (howToFinish.generatedAnIf) {
                ++this.tabs;
                this.println("else");
            }
            ++this.tabs;
            this.println(noViableAction);
            --this.tabs;
            if (howToFinish.generatedAnIf) {
                this.println("end; -- if");
                --this.tabs;
            }
            if (howToFinish.generatedSwitch) {
                this.println("end; -- case");
            }
        }
        if (!howToFinish.needAnErrorClause && howToFinish.generatedSwitch) {
            this.println("end; -- case");
        }
        if (howToFinish.postscript != null) {
            this.println(howToFinish.postscript);
        }
    }

    protected void genBlockPreamble(AlternativeBlock blk) {
        if (blk instanceof RuleBlock) {
            RuleBlock rblk = (RuleBlock)blk;
            if (rblk.labeledElements != null) {
                int i = 0;
                while (i < rblk.labeledElements.size()) {
                    AlternativeElement a = (AlternativeElement)rblk.labeledElements.elementAt(i);
                    if (a instanceof RuleRefElement || a instanceof AlternativeBlock && !(a instanceof RuleBlock) && !(a instanceof SynPredBlock)) {
                        if (!(a instanceof RuleRefElement) && ((AlternativeBlock)a).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)a, this.grammar instanceof LexerGrammar)) {
                            this.println(a.getLabel() + " : " + this.labeledElementType + " := " + this.labeledElementInit + ";");
                            if (this.grammar.buildAST) {
                                this.println(a.getLabel() + "_ast : " + this.labeledElementASTType + ";");
                            }
                        } else {
                            if (this.grammar.buildAST) {
                                this.println(a.getLabel() + "_ast : " + this.labeledElementASTType + ";");
                            }
                            if (this.grammar instanceof LexerGrammar) {
                                this.println(a.getLabel() + " : $ANTLR_TOKEN; ");
                            }
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println(a.getLabel() + " : " + this.labeledElementType + " := " + this.labeledElementInit + ";");
                            }
                        }
                    } else {
                        this.println(a.getLabel() + " : " + this.labeledElementType + " := " + this.labeledElementInit + ";");
                        if (this.grammar.buildAST) {
                            this.println(a.getLabel() + "_ast : " + this.labeledElementASTType + ";");
                        }
                    }
                    ++i;
                }
            }
        }
        if (blk.initAction != null) {
            this.printAction(this.processActionForTreeSpecifiers(blk.initAction, 0, this.currentRule, null));
        }
    }

    protected void genCases(BitSet p) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCases(" + p + ")");
        }
        int[] elems = p.toArray();
        int wrap = this.grammar instanceof LexerGrammar ? 4 : 1;
        int j = 1;
        boolean startOfLine = true;
        int i = 0;
        while (i < elems.length) {
            if (j == 1) {
                this.print("");
            } else {
                this._print("  ");
            }
            if (i == 0) {
                this._print("when " + this.getValueString(elems[i]));
            } else {
                this._print(", " + this.getValueString(elems[i]));
            }
            if (j == wrap) {
                this._println("");
                startOfLine = true;
                j = 1;
            } else {
                ++j;
                startOfLine = false;
            }
            ++i;
        }
        if (!startOfLine) {
            this._println("");
        }
    }

    public JavaBlockFinishingInfo genCommonBlock(AlternativeBlock blk, boolean noTestForSingle) {
        int startDepth;
        int nIF = 0;
        boolean createdLL1Switch = false;
        int closingBracesOfIFSequence = 0;
        JavaBlockFinishingInfo finishingInfo = new JavaBlockFinishingInfo();
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCommonBlk(" + blk + ")");
        }
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && blk.getAutoGen();
        boolean oldsaveTest = this.saveText;
        boolean bl = this.saveText = this.saveText && blk.getAutoGen();
        if (blk.not && this.analyzer.subruleCanBeInverted(blk, this.grammar instanceof LexerGrammar)) {
            Lookahead p = this.analyzer.look(1, blk);
            if (blk.getLabel() != null && this.syntacticPredLevel == 0) {
                this.println(blk.getLabel() + " := " + this.lt1Value + ";");
            }
            this.genElementAST(blk);
            String astArgs = "";
            if (this.grammar instanceof TreeWalkerGrammar) {
                astArgs = "sa_t,";
            }
            this.println("match( sa" + astArgs + this.getBitsetName(this.markBitsetForGen(p.fset)) + ");");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("sa_t := sa_t.next_sibling;");
            }
            return finishingInfo;
        }
        if (blk.getAlternatives().size() == 1) {
            Alternative alt = blk.getAlternativeAt(0);
            if (alt.synPred != null) {
                Tool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), blk.getAlternativeAt((int)0).synPred.getLine());
            }
            if (noTestForSingle) {
                if (alt.semPred != null) {
                    this.genSemPred(alt.semPred, blk.line);
                }
                this.genAlt(alt, blk);
                return finishingInfo;
            }
        }
        int nLL1 = 0;
        int i = 0;
        while (i < blk.getAlternatives().size()) {
            Alternative a = blk.getAlternativeAt(i);
            if (SatherCodeGenerator.suitableForCaseExpression(a)) {
                ++nLL1;
            }
            ++i;
        }
        if (nLL1 >= this.makeSwitchThreshold) {
            String testExpr = this.lookaheadString(1);
            createdLL1Switch = true;
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if ( void(sa_t) ) then");
                ++this.tabs;
                this.println("sa_t := AST::ASTNULL;");
                --this.tabs;
                this.println("end; -- if");
            }
            this.println("case ( " + testExpr + " )");
            int i2 = 0;
            while (i2 < blk.alternatives.size()) {
                Alternative alt = blk.getAlternativeAt(i2);
                if (SatherCodeGenerator.suitableForCaseExpression(alt)) {
                    Lookahead p = alt.cache[1];
                    if (p.fset.degree() == 0 && !p.containsEpsilon()) {
                        Tool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), alt.head.getLine());
                    } else {
                        this.genCases(p.fset);
                        this.println("then");
                        ++this.tabs;
                        this.genAlt(alt, blk);
                        --this.tabs;
                    }
                }
                ++i2;
            }
            this.println("else -- default");
            ++this.tabs;
        }
        int altDepth = startDepth = this.grammar instanceof LexerGrammar ? this.grammar.maxk : 0;
        while (altDepth >= 0) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("checking depth " + altDepth);
            }
            int i3 = 0;
            while (i3 < blk.alternatives.size()) {
                block45: {
                    String e;
                    boolean unpredicted;
                    Alternative alt;
                    block48: {
                        block46: {
                            int effectiveDepth;
                            block47: {
                                block44: {
                                    alt = blk.getAlternativeAt(i3);
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("genAlt: " + i3);
                                    }
                                    if (!createdLL1Switch || !SatherCodeGenerator.suitableForCaseExpression(alt)) break block44;
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("ignoring alt because it was in the switch");
                                    }
                                    break block45;
                                }
                                unpredicted = false;
                                if (!(this.grammar instanceof LexerGrammar)) break block46;
                                effectiveDepth = alt.lookaheadDepth;
                                if (effectiveDepth == Integer.MAX_VALUE) {
                                    effectiveDepth = this.grammar.maxk;
                                }
                                while (effectiveDepth >= 1 && alt.cache[effectiveDepth].containsEpsilon()) {
                                    --effectiveDepth;
                                }
                                if (effectiveDepth == altDepth) break block47;
                                if (this.DEBUG_CODE_GENERATOR) {
                                    System.out.println("ignoring alt because effectiveDepth!=altDepth;" + effectiveDepth + "/=" + altDepth);
                                }
                                break block45;
                            }
                            unpredicted = this.lookaheadIsEmpty(alt, effectiveDepth);
                            e = this.getLookaheadTestExpression(alt, effectiveDepth);
                            break block48;
                        }
                        unpredicted = this.lookaheadIsEmpty(alt, this.grammar.maxk);
                        e = this.getLookaheadTestExpression(alt, this.grammar.maxk);
                    }
                    boolean defaultBlock = true;
                    if (alt.cache[1].fset.degree() > 127) {
                        if (nIF == 0) {
                            this.println("if " + e + " then");
                        } else {
                            this.println("elsif " + e + " then");
                        }
                    } else if (unpredicted && alt.semPred == null && alt.synPred == null) {
                        if (nIF != 0) {
                            this.println("else ");
                            defaultBlock = false;
                        }
                        finishingInfo.needAnErrorClause = false;
                    } else {
                        if (alt.semPred != null) {
                            ActionTransInfo tInfo = new ActionTransInfo();
                            String actionStr = this.processActionForTreeSpecifiers(alt.semPred, blk.line, this.currentRule, tInfo);
                            e = (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar) && this.grammar.debuggingOutput ? "(" + e + " and fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.PREDICTING," + this.addSemPred(this.charFormatter.escapeString(actionStr)) + "," + actionStr + "))" : "(" + e + " and (" + actionStr + "))";
                        }
                        if (nIF > 0) {
                            if (alt.synPred != null) {
                                this.println("else");
                                ++this.tabs;
                                this.genSynPred(alt.synPred, e);
                                ++closingBracesOfIFSequence;
                            } else {
                                this.println("elsif " + e + " then");
                            }
                        } else if (alt.synPred != null) {
                            this.genSynPred(alt.synPred, e);
                        } else {
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println("if ( void(sa_t) ) then");
                                ++this.tabs;
                                this.println("sa_t := AST::ASTNULL;");
                                --this.tabs;
                                this.println("end; -- if");
                            }
                            this.println("if " + e + " then");
                        }
                    }
                    ++nIF;
                    ++this.tabs;
                    this.genAlt(alt, blk);
                    --this.tabs;
                    if (!defaultBlock) {
                        this.println("end; -- if");
                    }
                }
                ++i3;
            }
            --altDepth;
        }
        String ps = "";
        int i4 = 1;
        while (i4 <= closingBracesOfIFSequence) {
            ps = ps + "end;";
            ++i4;
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        if (createdLL1Switch) {
            --this.tabs;
            finishingInfo.postscript = ps;
            finishingInfo.generatedSwitch = true;
            finishingInfo.generatedAnIf = nIF > 0;
        } else {
            finishingInfo.postscript = ps;
            finishingInfo.generatedSwitch = false;
            finishingInfo.generatedAnIf = nIF > 0;
        }
        return finishingInfo;
    }

    private static boolean suitableForCaseExpression(Alternative a) {
        return a.lookaheadDepth == 1 && a.semPred == null && !a.cache[1].containsEpsilon() && a.cache[1].fset.degree() <= 127;
    }

    private void genElementAST(AlternativeElement el) {
        if (this.grammar instanceof TreeWalkerGrammar && !this.grammar.buildAST) {
            if (el.getLabel() == null) {
                String elementRef = this.lt1Value;
                String astName = "tmp" + this.astVarNumber + "_ast";
                ++this.astVarNumber;
                this.mapTreeVariable(el, astName);
                this.println(astName + "_in : " + this.labeledElementASTType + " := " + elementRef + ";");
            }
            return;
        }
        if (this.grammar.buildAST && this.syntacticPredLevel == 0) {
            String astName;
            String elementRef;
            boolean doNoGuessTest;
            boolean bl = doNoGuessTest = this.grammar.hasSyntacticPredicate && (el.getLabel() != null || el.getAutoGenType() != 3);
            if (el.getLabel() != null) {
                elementRef = el.getLabel();
                astName = el.getLabel() + "_ast";
            } else {
                elementRef = this.lt1Value;
                astName = "tmp" + this.astVarNumber + "_ast";
                ++this.astVarNumber;
                GrammarAtom ga = (GrammarAtom)el;
                if (ga.getASTNodeType() != null) {
                    this.println(astName + " : " + ga.getASTNodeType() + " := void;");
                } else {
                    this.println(astName + " : " + this.labeledElementASTType + ";");
                }
                this.mapTreeVariable(el, astName);
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(astName + "_in : " + this.labeledElementASTType + ";");
                }
            }
            if (doNoGuessTest) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            String astType = this.labeledElementASTType;
            GrammarAtom atom = (GrammarAtom)el;
            if (atom != null && atom.getASTNodeType() != null) {
                this.labeledElementASTType = astType = atom.getASTNodeType();
            }
            String astCreateString = this.grammar instanceof TreeWalkerGrammar ? astType + "::create_from_ast( " + elementRef + " )" : astType + "::create_from_token( " + elementRef + " )";
            if (el.getLabel() != null) {
                this.println(astName + " := " + astCreateString + ";");
            } else {
                elementRef = this.lt1Value;
                this.println(astName + " := " + astCreateString + ";");
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(astName + "_in := " + elementRef + ";");
                }
            }
            if (this.genAST) {
                switch (el.getAutoGenType()) {
                    case 1: {
                        this.println("current_ast.add_child( " + astName + " );");
                        break;
                    }
                    case 2: {
                        this.println("current_ast.make_root( " + astName + " );");
                        break;
                    }
                }
            }
            if (doNoGuessTest) {
                --this.tabs;
                this.println("end; -- if?");
            }
        }
    }

    private void genErrorCatchForElement(AlternativeElement el) {
        ExceptionSpec ex;
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.lexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            Tool.panic("Enclosing rule not found!");
        }
        if ((ex = rs.block.findExceptionSpec(el.getLabel())) != null) {
            --this.tabs;
            this.println("}*28");
            this.genErrorHandler(ex);
        }
    }

    private void genErrorHandler(ExceptionSpec ex) {
        int i = 0;
        while (i < ex.handlers.size()) {
            ExceptionHandler handler = (ExceptionHandler)ex.handlers.elementAt(i);
            this.println("when " + this.extractTypeOfAction(handler.exceptionTypeAndName) + " then");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            this.printAction(this.processActionForTreeSpecifiers(handler.action.getText(), 0, this.currentRule, null));
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("else");
                ++this.tabs;
                this.println("raise exception");
                --this.tabs;
                this.println("end; -- if");
            }
            --this.tabs;
            ++i;
        }
        this.println("end; -- protect");
    }

    private void genErrorTryForElement(AlternativeElement el) {
        ExceptionSpec ex;
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.lexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            Tool.panic("Enclosing rule not found!");
        }
        if ((ex = rs.block.findExceptionSpec(el.getLabel())) != null) {
            this.println("try { // for error handling");
            ++this.tabs;
        }
    }

    protected void genHeader() {
        this.println("-- $ANTLR 2.7.1: \"" + Tool.fileMinusPath(this.tool.grammarFile) + "\"" + " -> " + "\"" + this.grammar.getClassName() + ".sa\"$");
    }

    private void genLiteralsTest() {
        this.println("sa_ttype := test_literals_table(sa_ttype);");
    }

    private void genLiteralsTestForPartialToken() {
        this.println("sa_ttype := test_literals_table( text.substring( sa_begin, text.length - sa_begin ), sa_ttype );");
    }

    protected void genMatch(BitSet b) {
    }

    protected void genMatch(GrammarAtom atom) {
        if (atom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.genMatchUsingAtomTokenType(atom);
            }
        } else if (atom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.tool.error("cannot ref character literals in grammar: " + atom);
            }
        } else if (atom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(atom);
        }
    }

    protected void genMatchUsingAtomText(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "sa_t,";
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("sa_save_index := text.length;");
        }
        this.print(atom.not ? "match_not(" : "match(");
        this._print(astArgs);
        if (atom.atomText.equals("EOF")) {
            this._print("ANTLR_COMMON_TOKEN::EOF_TYPE");
        } else {
            this._print(atom.atomText);
        }
        this._println(");");
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("text := text.substring( 0 , sa_save_index);");
        }
    }

    protected void genMatchUsingAtomTokenType(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "sa_t,";
        }
        Object mangledName = null;
        String s = astArgs + this.getValueString(atom.getType());
        this.println((atom.not ? "match_not(" : "match(") + s + ");");
    }

    public void genNextToken() {
        boolean hasPublicRules = false;
        int i = 0;
        while (i < this.grammar.rules.size()) {
            RuleSymbol rs = (RuleSymbol)this.grammar.rules.elementAt(i);
            if (rs.isDefined() && rs.access.equals("public")) {
                hasPublicRules = true;
                break;
            }
            ++i;
        }
        if (!hasPublicRules) {
            this.println("");
            this.println("next_token : TOKEN is ");
            ++this.tabs;
            this.println("protect");
            ++this.tabs;
            this.println("upon_eof;");
            --this.tabs;
            this.println("when $ANTLR_CHAR_STREAM_EXCEPTION then");
            ++this.tabs;
            this.println("raise #ANTLR_TOKEN_STREAM_EXCEPTION( exception.str );");
            --this.tabs;
            this.println("end; -- protect");
            this.println("return #ANTLR_COMMON_TOKEN( ANTLR_COMMON_TOKEN::EOF_TYPE, \"\");");
            --this.tabs;
            this.println("end;");
            this.println("");
            return;
        }
        RuleBlock nextTokenBlk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(nextTokenBlk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(nextTokenBlk);
        String filterRule = null;
        if (((LexerGrammar)this.grammar).filterMode) {
            filterRule = ((LexerGrammar)this.grammar).filterRule;
        }
        this.println("");
        this.println("next_token : TOKEN is");
        ++this.tabs;
        this.println("theRetToken : TOKEN;");
        this.println("continue : BOOL := true;");
        this.println("loop");
        ++this.tabs;
        this.println("sa_ttype : INT := ANTLR_COMMON_TOKEN::INVALID_TYPE;");
        if (((LexerGrammar)this.grammar).filterMode) {
            this.println("commit_to_path := false;");
            this.println("continue := true;");
            if (filterRule != null) {
                if (!this.grammar.isDefined(CodeGenerator.lexerRuleName(filterRule))) {
                    this.grammar.tool.error("Filter rule " + filterRule + " does not exist in this lexer");
                } else {
                    RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.lexerRuleName(filterRule));
                    if (!rs.isDefined()) {
                        this.grammar.tool.error("Filter rule " + filterRule + " does not exist in this lexer");
                    } else if (rs.access.equals("public")) {
                        this.grammar.tool.error("Filter rule " + filterRule + " must be protected");
                    }
                }
                this.println("sa_m : INT := mark;");
            }
        }
        this.println("reset_text;");
        this.println("protect   -- for char stream error handling");
        ++this.tabs;
        this.println("protect   -- for lexical error handling");
        ++this.tabs;
        int i2 = 0;
        while (i2 < nextTokenBlk.getAlternatives().size()) {
            Alternative a = nextTokenBlk.getAlternativeAt(i2);
            if (a.cache[1].containsEpsilon()) {
                Tool.warning("found optional path in nextToken()");
            }
            ++i2;
        }
        String newline = System.getProperty("line.separator");
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(nextTokenBlk, false);
        String errFinish = "if ( LA(1) = EOF_CHAR ) then upon_eof; sa_return_token := make_token( ANTLR_COMMON_TOKEN::EOF_TYPE);";
        errFinish = errFinish + newline + "\t\t\t\t";
        errFinish = ((LexerGrammar)this.grammar).filterMode ? (filterRule == null ? errFinish + "\telse consume; continue := false; end; -- if" : errFinish + "\telse" + newline + "\t\t\t\t\t\tcommit;" + newline + "\t\t\t\t\t\tprotect" + newline + "\t\t\t\t\t\t\tm" + filterRule + "(false);" + newline + "\t\t\t\t\t\twhen $ANTLR_RECOGNITION_EXCEPTION then" + newline + "\t\t\t\t\t\t\t-- catastrophic failure" + newline + "\t\t\t\t\t\t\treport_error( exception );" + newline + "\t\t\t\t\t\t\tconsume;" + newline + "\t\t\t\t\t\tend; -- protect" + newline + "\t\t\t\t\t\tcontinue := false;" + newline + "\t\t\t\t\tend; -- if") : errFinish + "\t\telse " + this.throwNoViable + " end; -- if";
        this.genBlockFinish(howToFinish, errFinish);
        if (((LexerGrammar)this.grammar).filterMode && filterRule != null) {
            this.println("if continue then");
            ++this.tabs;
            this.println("commit;");
            --this.tabs;
            this.println("end; -- if");
        }
        this.println("if ( ~void(sa_return_token) and continue ) then;");
        ++this.tabs;
        this.println("sa_ttype := sa_return_token.ttype;");
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.genLiteralsTest();
        }
        this.println("sa_return_token.ttype := sa_ttype;");
        this.println("return sa_return_token;");
        --this.tabs;
        this.println("end; -- if");
        --this.tabs;
        this.println("when $ANTLR_RECOGNITION_EXCEPTION then");
        ++this.tabs;
        if (((LexerGrammar)this.grammar).filterMode) {
            if (filterRule == null) {
                this.println("if ( ~commit_to_path ) then");
                ++this.tabs;
                this.println("consume;");
                --this.tabs;
                this.println("end; -- if");
            } else {
                this.println("if ( ~commit_to_path ) then");
                ++this.tabs;
                this.println("rewind( sa_m );");
                this.println("reset_text;");
                this.println("protect");
                ++this.tabs;
                this.println("m" + filterRule + "(false);");
                --this.tabs;
                this.println("when $ANTLR_RECOGNITION_EXCEPTION then");
                ++this.tabs;
                this.println("-- horrendous failure: error in filter rule");
                this.println("report_error( exception );");
                this.println("consume;");
                --this.tabs;
                this.println("end; -- protect");
                --this.tabs;
                this.println("end; -- if");
            }
        } else if (nextTokenBlk.getDefaultErrorHandler()) {
            this.println("report_error( exception );");
            this.println("consume;");
        } else {
            this.println("raise #ANTLR_TOKEN_STREAM_RECOGNITION_EXCEPTION( exception.str );");
        }
        --this.tabs;
        this.println("end; -- protect");
        --this.tabs;
        this.println("when $ANTLR_CHAR_STREAM_EXCEPTION then");
        ++this.tabs;
        this.println("raise #ANTLR_TOKEN_STREAM_EXCEPTION( exception.message );");
        --this.tabs;
        this.println("end; -- protect");
        --this.tabs;
        this.println("end; -- loop");
        --this.tabs;
        this.println("end; -- next_token");
        this.println("");
    }

    public void genRule(RuleSymbol s, boolean startSymbol, int ruleNum) {
        RuleBlock rblk;
        this.tabs = 1;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRule(" + s.getId() + ")");
        }
        if (!s.isDefined()) {
            this.tool.error("undefined rule: " + s.getId());
            return;
        }
        this.labeledElementASTType = "AST";
        this.currentRule = rblk = s.getBlock();
        this.currentASTResult = s.getId();
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && rblk.getAutoGen();
        this.saveText = rblk.getAutoGen();
        if (s.comment != null) {
            this._println(s.comment);
        }
        this.print(s.getId());
        boolean hasArgs = false;
        if (this.commonExtraParams.length() != 0) {
            hasArgs = true;
            this._print("( " + this.commonExtraParams);
            if (rblk.argAction != null) {
                this._print(",");
            }
        }
        if (rblk.argAction != null && !hasArgs) {
            hasArgs = true;
            this._print("( ");
        }
        if (rblk.argAction != null) {
            this.print(rblk.argAction);
        }
        if (hasArgs) {
            this._print(" )");
        }
        if (rblk.returnAction != null) {
            this._print(" : " + this.extractSatherTypeOfAction(rblk.returnAction));
        }
        this._println(" is");
        ++this.tabs;
        if (rblk.returnAction != null) {
            this.println(rblk.returnAction + ";");
        }
        this.println(this.commonLocalVars);
        if (this.grammar.traceRules) {
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("trace_in(\"" + s.getId() + "\",sa_t);");
            } else {
                this.println("trace_in(\"" + s.getId() + "\");");
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            if (s.getId().equals("mEOF")) {
                this.println("sa_ttype := ANTLR_COMMON_TOKEN::EOF_TYPE;");
            } else {
                this.println("sa_ttype := " + s.getId().substring(1) + ";");
            }
            this.println("sa_save_index : INT;");
        }
        if (this.grammar.debuggingOutput) {
            if (this.grammar instanceof ParserGrammar) {
                this.println("fire_enter_rule( " + ruleNum + ", 0 );");
            } else if (this.grammar instanceof LexerGrammar) {
                this.println("fire_enter_rule( " + ruleNum + ", sa_ttype );");
            }
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            this.println("protect -- debugging output");
            ++this.tabs;
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println(s.getId() + "_ast_in : " + this.labeledElementASTType + " := sa_t;");
        }
        if (this.grammar.buildAST) {
            this.println("return_ast := void;");
            this.println("current_ast ::= #ANTLR_AST_PAIR{AST};");
            this.println(s.getId() + "_ast : " + this.labeledElementASTType + ";");
        }
        this.genBlockPreamble(rblk);
        this.println("");
        ExceptionSpec unlabeledUserSpec = rblk.findExceptionSpec("");
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            this.println("protect -- for error handling");
            ++this.tabs;
        }
        if (rblk.alternatives.size() == 1) {
            Alternative alt = rblk.getAlternativeAt(0);
            String pred = alt.semPred;
            if (pred != null) {
                this.genSemPred(pred, this.currentRule.line);
            }
            if (alt.synPred != null) {
                Tool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), alt.synPred.getLine());
            }
            this.genAlt(alt, rblk);
        } else {
            boolean ok = this.grammar.theLLkAnalyzer.deterministic(rblk);
            JavaBlockFinishingInfo howToFinish = this.genCommonBlock(rblk, false);
            this.genBlockFinish(howToFinish, this.throwNoViable);
        }
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            --this.tabs;
        }
        if (unlabeledUserSpec != null) {
            this.genErrorHandler(unlabeledUserSpec);
        } else if (rblk.getDefaultErrorHandler()) {
            this.println("when " + this.exceptionThrown + " then");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            this.println("report_error( exception );");
            if (!(this.grammar instanceof TreeWalkerGrammar)) {
                Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, rblk.endNode);
                String followSetName = "sa" + this.getBitsetName(this.markBitsetForGen(follow.fset));
                this.println("consume;");
                this.println("consume_until( " + followSetName + " );");
            } else {
                this.println("if ( ~void(sa_t) ) then");
                ++this.tabs;
                this.println("sa_t := sa_t.next_sibling;");
                --this.tabs;
                this.println("end; -- if");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("else");
                ++this.tabs;
                this.println("raise exception;");
                --this.tabs;
                this.println("end; -- if");
            }
            --this.tabs;
            this.println("end; -- protect");
        }
        if (this.grammar.buildAST) {
            this.println("return_ast := " + s.getId() + "_ast;");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_ret_tree := sa_t;");
        }
        if (rblk.getTestLiterals()) {
            if (s.access.equals("protected")) {
                this.genLiteralsTestForPartialToken();
            } else {
                this.genLiteralsTest();
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("if ( sa_create_token and void(sa_token) and sa_ttype /= ANTLR_COMMON_TOKEN::SKIP ) then");
            ++this.tabs;
            this.println("sa_token := make_token( sa_ttype );");
            this.println("sa_token.text := text.substring( sa_begin, text.length - sa_begin );");
            --this.tabs;
            this.println("end; -- if");
            this.println("sa_return_token := sa_token;");
        }
        if (rblk.returnAction != null) {
            this.println("return " + this.extractSatherIdOfAction(rblk.returnAction, rblk.getLine()) + ";");
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            --this.tabs;
            this.println("when $STR then -- assume this will catch everything");
            ++this.tabs;
            String fire = null;
            String trace = null;
            if (this.grammar.debuggingOutput) {
                if (this.grammar instanceof ParserGrammar) {
                    fire = "fire_exit_rule(" + ruleNum + ",0);";
                } else if (this.grammar instanceof LexerGrammar) {
                    fire = "fire_exit_rule(" + ruleNum + ", sa_ttype);";
                }
            }
            if (this.grammar.traceRules) {
                trace = this.grammar instanceof TreeWalkerGrammar ? "trace_out(\"" + s.getId() + "\", sa_t);" : "trace_out(\"" + s.getId() + "\");";
            }
            if (fire != null) {
                this.println(fire);
            }
            if (trace != null) {
                this.println(trace);
            }
            this.println("raise exception;");
            --this.tabs;
            this.println("end; -- protect");
            if (fire != null) {
                this.println(fire);
            }
            if (trace != null) {
                this.println(trace);
            }
        }
        --this.tabs;
        this.println("end; -- rule");
        this.println("");
        this.genAST = savegenAST;
    }

    private void GenRuleInvocation(RuleRefElement rr) {
        this._print(rr.targetRule);
        boolean hasArgs = false;
        if (this.grammar instanceof LexerGrammar) {
            hasArgs = true;
            if (rr.getLabel() != null) {
                this._print("( true");
            } else {
                this._print("( false");
            }
            if (this.commonExtraArgs.length() != 0 || rr.args != null) {
                this._print(",");
            }
        } else if (this.commonExtraArgs.length() != 0 || rr.args != null) {
            hasArgs = true;
            this._print("( ");
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && rr.args != null) {
            this._print(",");
        }
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        if (rr.args != null) {
            ActionTransInfo tInfo = new ActionTransInfo();
            String args = this.processActionForTreeSpecifiers(rr.args, 0, this.currentRule, tInfo);
            if (tInfo.assignToRoot || tInfo.refRuleRoot != null) {
                this.tool.error("Arguments of rule reference '" + rr.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName() + " on line " + rr.getLine());
            }
            this._print(args);
            if (rs.block.argAction == null) {
                Tool.warning("Rule '" + rr.targetRule + "' accepts no arguments", this.grammar.getFilename(), rr.getLine());
            }
        } else if (rs.block.argAction != null) {
            Tool.warning("Missing parameters on reference to rule " + rr.targetRule, this.grammar.getFilename(), rr.getLine());
        }
        if (hasArgs) {
            this._print(" )");
        }
        this._println(";");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa_ret_tree;");
        }
    }

    protected void genSemPred(String pred, int line) {
        ActionTransInfo tInfo = new ActionTransInfo();
        pred = this.processActionForTreeSpecifiers(pred, line, this.currentRule, tInfo);
        String escapedPred = this.charFormatter.escapeString(pred);
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            pred = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + this.addSemPred(escapedPred) + "," + pred + ")";
        }
        this.println("if (~(" + pred + ")) then");
        ++this.tabs;
        this.println("raise #ANTLR_SEMANTIC_EXCEPTION(\"" + escapedPred + "\");");
        --this.tabs;
        this.println("end;");
    }

    protected void genSemPredMap() {
        Enumeration e = this.semPreds.elements();
        this.println("private String _semPredNames[] = {");
        while (e.hasMoreElements()) {
            this.println("\"" + e.nextElement() + "\",");
        }
        this.println("};");
    }

    protected void genSynPred(SynPredBlock blk, String lookaheadExpr) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen=>(" + blk + ")");
        }
        this.println("syn_pred_matched" + blk.ID + " : BOOL := false;");
        this.println("if (" + lookaheadExpr + ") then");
        ++this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa__t" + blk.ID + " " + this.labeledElementASTType + " := sa_t;");
        } else {
            this.println("sa_m" + blk.ID + " : INT := mark;");
        }
        this.println("syn_pred_matched" + blk.ID + " := true;");
        this.println("input_state.guessing := input_state.guessing + 1;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("fireSyntacticPredicateStarted();");
        }
        ++this.syntacticPredLevel;
        this.println("protect");
        ++this.tabs;
        this.gen(blk);
        --this.tabs;
        this.println("when " + this.exceptionThrown + " then");
        ++this.tabs;
        this.println("syn_pred_matched" + blk.ID + " := false;");
        --this.tabs;
        this.println("end; -- protect");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa__t" + blk.ID + ";");
        } else {
            this.println("rewind( sa_m" + blk.ID + " );");
        }
        this.println("input_state.guessing := input_state.guessing - 1;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("if ( syn_pred_matched" + blk.ID + " ) then");
            ++this.tabs;
            this.println("fireSyntacticPredicateSucceeded();");
            --this.tabs;
            this.println("else");
            ++this.tabs;
            this.println("  fireSyntacticPredicateFailed();");
            --this.tabs;
            this.println("end; -- if");
        }
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("end; -- if");
        this.println("if ( syn_pred_matched" + blk.ID + " ) then");
    }

    public void genTokenStrings() {
        this.println("");
        this.println("const sa_token_names : ARRAY{STR} := |");
        ++this.tabs;
        Vector v = this.grammar.tokenManager.getVocabulary();
        int i = 0;
        while (i < v.size()) {
            TokenSymbol ts;
            String s = (String)v.elementAt(i);
            if (s == null) {
                s = "<" + String.valueOf(i) + ">";
            }
            if (!s.startsWith("\"") && !s.startsWith("<") && (ts = this.grammar.tokenManager.getTokenSymbol(s)) != null && ts.getParaphrase() != null) {
                s = Tool.stripFrontBack(ts.getParaphrase(), "\"", "\"");
            }
            this.print(this.charFormatter.literalString(s));
            if (i != v.size() - 1) {
                this._print(",");
            }
            this._println("");
            ++i;
        }
        --this.tabs;
        this.println("|;");
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        this.setupOutput(tm.getName() + "_" + CodeGenerator.TokenTypesFileSuffix.toUpperCase());
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("class " + tm.getName() + "_" + CodeGenerator.TokenTypesFileSuffix.toUpperCase() + " is");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        this.println("const EOF : INT := 1;");
        this.println("const NULL_TREE_LOOKAHEAD : INT := 3;");
        int i = 4;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (s.startsWith("\"")) {
                    StringLiteralSymbol sl = (StringLiteralSymbol)tm.getTokenSymbol(s);
                    if (sl == null) {
                        Tool.panic("String literal " + s + " not in symbol table");
                    } else if (sl.label != null) {
                        this.println("const " + sl.label + " : INT" + " := " + i + ";");
                    } else {
                        String mangledName = this.mangleLiteral(s);
                        if (mangledName != null) {
                            this.println("const " + mangledName + " : INT" + " := " + i + ";");
                            sl.label = mangledName;
                        } else {
                            this.println("-- " + s + " := " + i);
                        }
                    }
                } else if (!s.startsWith("<")) {
                    this.println("const " + s + " : INT" + " := " + i + ";");
                }
            }
            ++i;
        }
        this.println("");
        this.println("bitset ( bool_array : ARRAY{BOOL} ) : CHAR_SET is");
        ++this.tabs;
        this.println("return #CHAR_SET( bool_array );");
        --this.tabs;
        this.println("end;");
        this.println("");
        this.println("int_set ( int_array : ARRAY{INT} ) : INT_SET is");
        ++this.tabs;
        this.println("return #INT_SET( int_array );");
        --this.tabs;
        this.println("end;");
        --this.tabs;
        this.println("end; -- class");
        this.currentOutput.close();
        this.currentOutput = null;
        this.exitIfError();
    }

    public String getASTCreateString(Vector v) {
        if (v.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("ANTLR_AST_UTIL{AST}::make( ( #ANTLR_AST_ARRAY{AST}(" + v.size() + "))");
        int i = 0;
        while (i < v.size()) {
            buf.append(".add(" + v.elementAt(i) + ")");
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public String getASTCreateString(GrammarAtom atom, String str) {
        if (atom != null && atom.getASTNodeType() != null) {
            return atom.getASTNodeType() + "::create(" + str + ")";
        }
        return this.labeledElementASTType + "::create( " + str + " )";
    }

    protected String getLookaheadTestExpression(Lookahead[] look, int k) {
        StringBuffer e = new StringBuffer(100);
        boolean first = true;
        e.append("(");
        int i = 1;
        while (i <= k) {
            BitSet p = look[i].fset;
            if (!first) {
                e.append(") and (");
            }
            first = false;
            if (look[i].containsEpsilon()) {
                e.append("true");
            } else {
                e.append(this.getLookaheadTestTerm(i, p));
            }
            ++i;
        }
        e.append(")");
        return e.toString();
    }

    protected String getLookaheadTestExpression(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        if (maxDepth == 0) {
            return "true";
        }
        return "(" + this.getLookaheadTestExpression(alt.cache, depth) + ")";
    }

    protected String getLookaheadTestTerm(int k, BitSet p) {
        String ts = this.lookaheadString(k);
        int[] elems = p.toArray();
        if (CodeGenerator.elementsAreRange(elems)) {
            return this.getRangeExpression(k, elems);
        }
        int degree = p.degree();
        if (degree == 0) {
            return "true";
        }
        if (degree >= this.bitsetTestThreshold) {
            int bitsetIdx = this.markBitsetForGen(p);
            return "sa" + this.getBitsetName(bitsetIdx) + ".member(" + ts + ")";
        }
        StringBuffer e = new StringBuffer();
        int i = 0;
        while (i < elems.length) {
            String cs = this.getValueString(elems[i]);
            if (i > 0) {
                e.append(" or ");
            }
            e.append(ts);
            e.append("=");
            e.append(cs);
            ++i;
        }
        return e.toString();
    }

    public String getRangeExpression(int k, int[] elems) {
        if (!CodeGenerator.elementsAreRange(elems)) {
            Tool.panic("getRangeExpression called with non-range");
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        return "(" + this.lookaheadString(k) + " >= " + this.getValueString(begin) + " and " + this.lookaheadString(k) + " <= " + this.getValueString(end) + ")";
    }

    private String getValueString(int value) {
        String cs;
        if (this.grammar instanceof LexerGrammar) {
            cs = this.charFormatter.literalChar(value);
        } else {
            TokenSymbol ts = this.grammar.tokenManager.getTokenSymbolAt(value);
            if (ts == null) {
                return "" + value;
            }
            String tId = ts.getId();
            if (ts instanceof StringLiteralSymbol) {
                StringLiteralSymbol sl = (StringLiteralSymbol)ts;
                String label = sl.getLabel();
                if (label != null) {
                    cs = label;
                } else {
                    cs = this.mangleLiteral(tId);
                    if (cs == null) {
                        cs = String.valueOf(value);
                    }
                }
            } else {
                cs = tId;
            }
        }
        return cs;
    }

    protected boolean lookaheadIsEmpty(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        int i = 1;
        while (i <= depth && i <= maxDepth) {
            BitSet p = alt.cache[i].fset;
            if (p.degree() != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String lookaheadString(int k) {
        if (this.grammar instanceof TreeWalkerGrammar) {
            return "sa_t.ttype";
        }
        return "LA(" + k + ")";
    }

    private String mangleLiteral(String s) {
        String mangled = Tool.literalsPrefix;
        int i = 1;
        while (i < s.length() - 1) {
            if (!Character.isLetter(s.charAt(i)) && s.charAt(i) != '_') {
                return null;
            }
            mangled = mangled + s.charAt(i);
            ++i;
        }
        if (Tool.upperCaseMangledLiterals) {
            mangled = mangled.toUpperCase();
        }
        return mangled;
    }

    public String mapTreeId(String idParam, ActionTransInfo transInfo) {
        if (this.currentRule == null) {
            return idParam;
        }
        boolean in_var = false;
        String id = idParam;
        if (this.grammar instanceof TreeWalkerGrammar) {
            if (!this.grammar.buildAST) {
                in_var = true;
            } else if (id.length() > 3 && id.lastIndexOf("_in") == id.length() - 3) {
                id = id.substring(0, id.length() - 3);
                in_var = true;
            }
        }
        int i = 0;
        while (i < this.currentRule.labeledElements.size()) {
            AlternativeElement elt = (AlternativeElement)this.currentRule.labeledElements.elementAt(i);
            if (elt.getLabel().equals(id)) {
                return in_var ? id : id + "_ast";
            }
            ++i;
        }
        String s = (String)this.treeVariableMap.get(id);
        if (s != null) {
            if (s == NONUNIQUE) {
                return null;
            }
            if (s.equals(this.currentRule.getRuleName())) {
                return null;
            }
            return in_var ? s + "_in" : s;
        }
        if (id.equals(this.currentRule.getRuleName())) {
            String r;
            String string = r = in_var ? id + "_ast_in" : id + "_ast";
            if (transInfo != null && !in_var) {
                transInfo.refRuleRoot = r;
            }
            return r;
        }
        return id;
    }

    private void mapTreeVariable(AlternativeElement e, String name) {
        if (e instanceof TreeElement) {
            this.mapTreeVariable(((TreeElement)e).root, name);
            return;
        }
        String elName = null;
        if (e.getLabel() == null) {
            if (e instanceof TokenRefElement) {
                elName = ((TokenRefElement)e).atomText;
            } else if (e instanceof RuleRefElement) {
                elName = ((RuleRefElement)e).targetRule;
            }
        }
        if (elName != null) {
            if (this.treeVariableMap.get(elName) != null) {
                this.treeVariableMap.remove(elName);
                this.treeVariableMap.put(elName, NONUNIQUE);
            } else {
                this.treeVariableMap.put(elName, name);
            }
        }
    }

    private void setupGrammarParameters(Grammar g) {
        if (g instanceof ParserGrammar) {
            this.labeledElementASTType = "AST";
            this.labeledElementType = "$ANTLR_TOKEN";
            this.labeledElementInit = "void";
            this.commonExtraArgs = "";
            this.commonExtraParams = "";
            this.commonLocalVars = "";
            this.lt1Value = "LT(1)";
            this.exceptionThrown = "$ANTLR_RECOGNITION_EXCEPTION";
            this.throwNoViable = "raise ANTLR_NO_VIABLE_ALT_EXCEPTION{AST}::create_from_token(LT(1), file_name );";
        } else if (g instanceof LexerGrammar) {
            this.labeledElementType = "CHAR ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "sa_create_token : BOOL";
            this.commonLocalVars = "sa_ttype : INT; sa_token : TOKEN; sa_begin : INT := text.length;";
            this.lt1Value = "LA(1)";
            this.exceptionThrown = "$ANTLR_RECOGNITION_EXCEPTION";
            this.throwNoViable = "raise #ANTLR_NO_VIABLE_ALT_FOR_CHAR_EXCEPTION( LA(1), file_name, line );";
        } else if (g instanceof TreeWalkerGrammar) {
            this.labeledElementType = this.labeledElementASTType = "AST";
            if (!g.hasOption("ASTLabelType")) {
                g.setOption("ASTLabelType", new Token(6, "AST"));
            }
            this.labeledElementInit = "void";
            this.commonExtraArgs = "sa_t";
            this.commonExtraParams = "sa_t : " + this.labeledElementASTType;
            this.commonLocalVars = "";
            this.lt1Value = "sa_t";
            this.exceptionThrown = "$ANTLR_RECOGNITION_EXCEPTION";
            this.throwNoViable = "raise #ANTLR_NO_VIABLE_ALT_EXCEPTION{AST}(sa_t);";
        } else {
            Tool.panic("Unknown grammar type");
        }
    }

    public void setupOutput(String className) throws IOException {
        this.currentOutput = Tool.openOutputFile(className + ".sa");
    }

    private static synchronized String getNextSatherPrefix() {
        String label = "sa" + satherBlockId;
        ++satherBlockId;
        return label;
    }

    protected String extractSatherTypeOfAction(String s) {
        int s_length = s.length();
        int i = s_length - 1;
        while (i >= 0) {
            if (s.charAt(i) == ':') {
                return s.substring(i + 1, s_length);
            }
            --i;
        }
        Tool.warning("Unable to determine Sather type");
        return "";
    }

    protected String extractSatherIdOfAction(String s, int line) {
        int s_length = s.length();
        int i = s_length - 1;
        while (i >= 0) {
            if (s.charAt(i) == ':') {
                return s.substring(0, i);
            }
            --i;
        }
        Tool.warning("Unable to determine Sather return identifier");
        return "";
    }

    protected String processActionForTreeSpecifiers(String actionStr, int line, RuleBlock currentRule, ActionTransInfo tInfo) {
        if (actionStr == null || actionStr.length() == 0) {
            return null;
        }
        if (this.grammar == null) {
            return actionStr;
        }
        if (this.grammar.buildAST && actionStr.indexOf(64) != -1 || this.grammar instanceof TreeWalkerGrammar || this.grammar instanceof LexerGrammar && actionStr.indexOf(37) != -1) {
            ActionLexer lexer = new ActionLexer(actionStr, currentRule, this, tInfo);
            lexer.setLineOffset(line);
            lexer.setTool(this.tool);
            try {
                lexer.mACTION(true);
                actionStr = lexer.getTokenObject().getText();
            }
            catch (RecognitionException ex) {
                lexer.reportError(ex);
                return actionStr;
            }
            catch (TokenStreamException tex) {
                Tool.panic("Error reading action:" + actionStr);
                return actionStr;
            }
            catch (CharStreamException io) {
                Tool.panic("Error reading action:" + actionStr);
                return actionStr;
            }
        }
        return actionStr;
    }
}

