/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ANTLRTokdefLexer;
import antlr.ANTLRTokdefParser;
import antlr.Grammar;
import antlr.RecognitionException;
import antlr.SimpleTokenManager;
import antlr.StringLiteralSymbol;
import antlr.TokenStreamException;
import antlr.TokenSymbol;
import antlr.Tool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

class ImportVocabTokenManager
extends SimpleTokenManager
implements Cloneable {
    private String filename;
    protected Grammar grammar;

    ImportVocabTokenManager(Grammar grammar, String filename_, String name_, Tool tool_) {
        super(name_, tool_);
        this.grammar = grammar;
        File grammarFile = new File(filename_);
        if (!grammarFile.exists() && !(grammarFile = new File(Tool.getOutputDirectory(), filename_)).exists()) {
            Tool.panic("Cannot find importVocab file '" + this.filename);
        }
        this.filename = filename_;
        this.setReadOnly(true);
        try {
            FileReader fileIn = new FileReader(grammarFile);
            ANTLRTokdefLexer tokdefLexer = new ANTLRTokdefLexer(fileIn);
            ANTLRTokdefParser tokdefParser = new ANTLRTokdefParser(tokdefLexer);
            tokdefParser.setFilename(this.filename);
            tokdefParser.file(this);
        }
        catch (FileNotFoundException fnf) {
            Tool.panic("Cannot find importVocab file '" + this.filename);
        }
        catch (RecognitionException ex) {
            Tool.panic("Error parsing importVocab file '" + this.filename + "': " + ex.toString());
        }
        catch (TokenStreamException ex) {
            Tool.panic("Error reading importVocab file '" + this.filename + "'");
        }
    }

    public Object clone() {
        ImportVocabTokenManager tm = (ImportVocabTokenManager)super.clone();
        tm.filename = this.filename;
        tm.grammar = this.grammar;
        return tm;
    }

    public void define(TokenSymbol ts) {
        super.define(ts);
    }

    public void define(String s, int ttype) {
        TokenSymbol ts = null;
        ts = s.startsWith("\"") ? new StringLiteralSymbol(s) : new TokenSymbol(s);
        ts.setTokenType(ttype);
        super.define(ts);
        this.maxToken = ttype + 1 > this.maxToken ? ttype + 1 : this.maxToken;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int nextTokenType() {
        return super.nextTokenType();
    }
}

