/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.BlockWithImpliedExitPath;
import antlr.CharFormatter;
import antlr.CodeGenerator;
import antlr.FileLineFormatter;
import antlr.Grammar;
import antlr.JavaCharFormatter;
import antlr.Lookahead;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.ToolErrorHandler;

class DefaultToolErrorHandler
implements ToolErrorHandler {
    CharFormatter javaCharFormatter = new JavaCharFormatter();

    DefaultToolErrorHandler() {
    }

    private void dumpSets(Grammar grammar, boolean lexicalAnalysis, int depth, Lookahead[] sets, String linePrefix) {
        int i = 1;
        while (i <= depth) {
            System.out.print(linePrefix + "\tk==" + i + ":");
            if (lexicalAnalysis) {
                String bits = sets[i].fset.toStringWithRanges(",", this.javaCharFormatter);
                if (sets[i].containsEpsilon()) {
                    System.out.print("<end-of-token>");
                    if (bits.length() > 0) {
                        System.out.print(",");
                    }
                }
                System.out.println(bits);
            } else {
                System.out.println(sets[i].fset.toString(",", grammar.tokenManager.getVocabulary()));
            }
            ++i;
        }
    }

    public void warnAltAmbiguity(Grammar grammar, AlternativeBlock blk, boolean lexicalAnalysis, int depth, Lookahead[] sets, int altIdx1, int altIdx2) {
        String fileline = FileLineFormatter.getFormatter().getFormatString(grammar.getFilename(), blk.getLine());
        if (blk instanceof RuleBlock && ((RuleBlock)blk).isLexerAutoGenRule()) {
            System.out.print("warning: lexical nondeterminism between rules ");
            Alternative ai = blk.getAlternativeAt(altIdx1);
            Alternative aj = blk.getAlternativeAt(altIdx2);
            RuleRefElement rri = (RuleRefElement)ai.head;
            RuleRefElement rrj = (RuleRefElement)aj.head;
            String ri = CodeGenerator.reverseLexerRuleName(rri.targetRule);
            String rj = CodeGenerator.reverseLexerRuleName(rrj.targetRule);
            System.out.println(ri + " and " + rj + " upon");
            this.dumpSets(grammar, lexicalAnalysis, depth, sets, fileline);
            return;
        }
        System.out.println(fileline + "warning: " + (lexicalAnalysis ? "lexical " : "") + "nondeterminism upon");
        this.dumpSets(grammar, lexicalAnalysis, depth, sets, fileline);
        System.out.println(fileline + "\tbetween alts " + (altIdx1 + 1) + " and " + (altIdx2 + 1) + " of block");
    }

    public void warnAltExitAmbiguity(Grammar grammar, BlockWithImpliedExitPath blk, boolean lexicalAnalysis, int depth, Lookahead[] sets, int altIdx) {
        String fileline = FileLineFormatter.getFormatter().getFormatString(grammar.getFilename(), blk.getLine());
        System.out.println(fileline + "warning: " + (lexicalAnalysis ? "lexical " : "") + "nondeterminism upon");
        this.dumpSets(grammar, lexicalAnalysis, depth, sets, fileline);
        System.out.println(fileline + "\tbetween alt " + (altIdx + 1) + " and exit branch of block");
    }
}

