/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.viewmanagement;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.viewmanagement.IViewManagementFilter;
import com.tssap.selena.viewmanagement.ViewmanagementPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jface.preference.IPreferenceStore;

public class HiddenReferencePropertyGetProvider
implements PropertyGetProvider {
    private static final IPreferenceStore ourPreferenceStore = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
    private static final String VIEW_MANAGEMENT_OPTIONS = "filter";
    private static final String FILTER_TAG = "filter";
    private static final String CLASS_ATTR = "class";
    private static final String DIAGRAM_METACLASS = "diagramMetaclass";
    private static final String P_HIDDEN_BY_TAG = "HiddenByTag";
    private static final String TRUE = Boolean.TRUE.toString();
    private static Boolean myIsHideByTag;
    private Map myRegisteredFilters;

    public String getPropertyValue(Element element, String propertyName) {
        return this.isConfiguredToHide(element) ? "true" : "false";
    }

    public Property getProperty(Element element, String propertyName) {
        return new PropertyAdapter(propertyName, this.isConfiguredToHide(element) ? "true" : "false", element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.isConfiguredToHide(element);
    }

    public PropertyEnumeration properties(Element element) {
        PropertyEnumeration originalValue = element.properties();
        return originalValue;
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        System.out.println("invoked additional $hidden evaluation: properties (name)");
        return null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        boolean result = this.isConfiguredToHide(element) == Boolean.valueOf(propertyValue).booleanValue();
        return result;
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    private boolean isConfiguredToHide(Element elem) {
        List extensions;
        if (!HiddenReferencePropertyGetProvider.isHideByTag()) {
            boolean originalValue;
            boolean bl = originalValue = elem.getPropertyValue("$hidden") != null;
            if (originalValue) {
                return true;
            }
        }
        if ((extensions = this.getRegisteredFilters(elem.getParent().getPropertyValue("$metaclass"))) == null || extensions.isEmpty()) {
            return elem.hasPropertyValue("$hidden", Boolean.TRUE.toString());
        }
        int i = 0;
        while (i < extensions.size()) {
            IViewManagementFilter iExtension = (IViewManagementFilter)extensions.get(i);
            if (iExtension.isConfiguredToHide(elem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getRegisteredFilters(String metaclass) {
        if (this.myRegisteredFilters == null) {
            this.myRegisteredFilters = new HashMap();
            IExtensionPoint extensionPoint = ViewmanagementPlugin.getDefault().getDescriptor().getExtensionPoint("filter");
            IExtension[] extensions = null;
            if (extensionPoint != null) {
                extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configs = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configs.length) {
                        IConfigurationElement iConfigurationElement = configs[j];
                        if ("filter".equals(iConfigurationElement.getName())) {
                            String metaclasses = iConfigurationElement.getAttributeAsIs(DIAGRAM_METACLASS);
                            if (metaclasses == null) {
                                System.err.println("skipping filter : " + iConfigurationElement.getAttributeAsIs(CLASS_ATTR));
                            } else {
                                IViewManagementFilter filter = null;
                                try {
                                    filter = (IViewManagementFilter)iConfigurationElement.createExecutableExtension(CLASS_ATTR);
                                }
                                catch (ClassCastException cc) {
                                    cc.printStackTrace();
                                    System.err.println("Unable to cast class: " + iConfigurationElement.getAttribute(CLASS_ATTR) + " to IViewManagementFilter");
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                    System.err.println("Unable to instantiate filter class: " + iConfigurationElement.getAttribute(CLASS_ATTR));
                                }
                                catch (NoClassDefFoundError e) {
                                    e.printStackTrace();
                                    System.err.println("Unable to load filter class: " + iConfigurationElement.getAttribute(CLASS_ATTR));
                                }
                                if (filter != null) {
                                    StringTokenizer classes = new StringTokenizer(metaclasses, ",");
                                    while (classes.hasMoreElements()) {
                                        String clazz = classes.nextToken().trim();
                                        HiddenReferencePropertyGetProvider.addFilter(this.myRegisteredFilters, clazz, filter);
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return (List)this.myRegisteredFilters.get(metaclass);
    }

    private static void addFilter(Map filtersMap, String clazz, Object filter) {
        ArrayList<Object> filters = (ArrayList<Object>)filtersMap.get(clazz);
        if (filters == null) {
            filters = new ArrayList<Object>();
            filtersMap.put(clazz, filters);
        }
        filters.add(filter);
    }

    private static boolean isHideByTag() {
        return ourPreferenceStore.getBoolean(P_HIDDEN_BY_TAG);
    }
}

