/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wsddman.impl0;

import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.ImplementationLink;
import com.sap.ide.ws.wsddman.PortName;
import com.sap.ide.ws.wsddman.WebService;
import com.sap.ide.ws.wsddman.impl0.PortNameImpl;
import com.sap.ide.ws.wsddman.impl0.WSConfigurationImpl;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WebServiceImpl
implements WebService {
    public Vector cfgs = new Vector();
    public String guid = "";
    public PortName pname = new PortNameImpl("webservice-name");
    public String standardnamespace = "urn:";
    String ejbtemp = "";
    String internalname = "";
    String viname = "";
    String wsdname = "";

    public Configuration newConfiguration(String name) {
        WSConfigurationImpl cfg = new WSConfigurationImpl(name);
        if (this.ejbtemp.startsWith("(ext)")) {
            cfg.setIsJavaClass(true);
        }
        return cfg;
    }

    public void setName(PortName pn) {
        this.pname = pn;
    }

    public PortName getName() {
        return this.pname;
    }

    public Configuration getConfiguration(String name) {
        int i = 0;
        while (i < this.cfgs.size()) {
            if (((WSConfigurationImpl)this.cfgs.get(i)).getName().equals(name)) {
                return (WSConfigurationImpl)this.cfgs.get(i);
            }
            ++i;
        }
        return null;
    }

    public void addWSConfiguration(Configuration config) {
        this.cfgs.add(config);
        ((WSConfigurationImpl)config).setOwnerName("urn:" + this.wsdname + "/" + this.viname);
        ((WSConfigurationImpl)config).setParent(this);
    }

    public Configuration addConfiguration(String name) {
        WSConfigurationImpl c = (WSConfigurationImpl)this.newConfiguration(name);
        c.setOwnerName("urn:" + this.wsdname + "/" + this.viname);
        this.cfgs.add(c);
        c.setParent(this);
        return c;
    }

    public void removeConfiguration(String name) {
        int i = 0;
        while (i < this.cfgs.size()) {
            if (((WSConfigurationImpl)this.cfgs.get(i)).getName().equals(name)) {
                this.cfgs.remove(i);
            }
            ++i;
        }
    }

    public Configuration[] getConfigurations() {
        Configuration[] c = new Configuration[this.cfgs.size()];
        int i = 0;
        while (i < c.length) {
            c[i] = (Configuration)this.cfgs.get(i);
            ++i;
        }
        return c;
    }

    public void setGUID(String id) {
        this.guid = id;
    }

    public String getGUID() {
        return this.guid;
    }

    public void fillWithData(Node node) {
        Node childnode = node.getFirstChild();
        boolean isjavaclass = false;
        while (childnode != null) {
            Text tx;
            if (childnode.getNodeName().equals("webservice-name")) {
                this.pname = new PortNameImpl("webservice-name");
                ((PortNameImpl)this.pname).fillWithData(childnode);
            } else if (childnode.getNodeName().equals("ws-configuration")) {
                WSConfigurationImpl cfg = new WSConfigurationImpl("");
                cfg.fillWithData(childnode);
                cfg.setParent(this);
                this.cfgs.add(cfg);
            } else if (childnode.getNodeName().equals("guid")) {
                tx = (Text)childnode.getFirstChild();
                this.guid = tx.getData().trim();
            } else if (childnode.getNodeName().equals("webservice-internal-name")) {
                tx = (Text)childnode.getFirstChild();
                this.internalname = tx != null ? tx.getData().trim() : "";
            } else if (childnode.getNodeName().equals("ejb-name-temp")) {
                tx = (Text)childnode.getFirstChild();
                this.ejbtemp = tx.getData().trim();
            } else if (childnode.getNodeName().equals("standard-namespaceURI")) {
                tx = (Text)childnode.getFirstChild();
                this.standardnamespace = tx.getData().trim();
            }
            childnode = childnode.getNextSibling();
        }
        int i = 0;
        while (i < this.cfgs.size()) {
            ((WSConfigurationImpl)this.cfgs.elementAt(i)).setOwnerName("urn:" + this.wsdname + "/" + this.viname);
            ++i;
        }
    }

    public Node createDOMNode(Document d) {
        Text tx;
        Element el;
        Element node = d.createElement("webservice");
        if (this.guid != null) {
            el = d.createElement("guid");
            tx = d.createTextNode(this.guid);
            el.appendChild(tx);
            node.appendChild(el);
        }
        if (this.ejbtemp != null && !this.ejbtemp.equals("")) {
            el = d.createElement("ejb-name-temp");
            tx = d.createTextNode(this.ejbtemp);
            el.appendChild(tx);
            node.appendChild(el);
        }
        if (this.pname != null) {
            node.appendChild(((PortNameImpl)this.pname).createDOMNode(d));
        }
        el = d.createElement("webservice-internal-name");
        if (this.internalname != null && !this.internalname.equals("")) {
            tx = d.createTextNode(this.internalname);
            el.appendChild(tx);
        }
        node.appendChild(el);
        Element standardns = (Element)node.appendChild(d.createElement("standard-namespaceURI"));
        standardns.appendChild(d.createTextNode(this.standardnamespace));
        int i = 0;
        while (i < this.cfgs.size()) {
            node.appendChild(((Configuration)this.cfgs.elementAt(i)).createDOMNode(d));
            ++i;
        }
        return node;
    }

    public String getEJBNameTemp() {
        return this.ejbtemp;
    }

    public void setEJBNameTemp(String newname) {
        this.ejbtemp = newname;
    }

    public String getInternalName() {
        return this.internalname;
    }

    public void setInternalname(String newname) {
        this.internalname = newname;
        this.pname.setLocalName(newname);
    }

    public String getInternalname() {
        return this.internalname;
    }

    public void setStandardNamespace(String newname) {
        this.standardnamespace = newname;
    }

    public void setVIAndWSDNames(String viname, String wsdname) {
        this.viname = viname;
        this.wsdname = wsdname;
    }

    public ImplementationLink getImplementationLink() {
        return null;
    }
}

