/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wsddman.impl0;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.ide.ws.wsddman.Fault;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.PortName;
import com.sap.ide.ws.wsddman.Property;
import com.sap.ide.ws.wsddman.TransportBinding;
import com.sap.ide.ws.wsddman.impl0.FaultImpl;
import com.sap.ide.ws.wsddman.impl0.Header;
import com.sap.ide.ws.wsddman.impl0.InputImpl;
import com.sap.ide.ws.wsddman.impl0.OperationConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.OutputImpl;
import com.sap.ide.ws.wsddman.impl0.PortNameImpl;
import com.sap.ide.ws.wsddman.impl0.PropertyImpl;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TransportBindingImpl
implements TransportBinding {
    String name = "SOAPHTTP_TransportBinding";
    Vector properties = new Vector();
    OperationConfiguration[] relatedconfigs = new OperationConfiguration[0];
    Vector availableheaders = new Vector();
    PortName wsdlbindingname = new PortNameImpl("wsdl-binding-name");
    String displayname = "HTTP SOAP";
    boolean changed = false;

    public TransportBindingImpl(OperationConfiguration[] relconfigs) {
        this.relatedconfigs = relconfigs;
    }

    public TransportBindingImpl() {
    }

    public PortName getWSDLBindingName() {
        return this.wsdlbindingname;
    }

    public Header[] getHeaders() {
        Header[] headers = new Header[this.availableheaders.size()];
        int i = 0;
        while (i < headers.length) {
            headers[i] = (Header)this.availableheaders.elementAt(i);
            ++i;
        }
        return headers;
    }

    public void setHeaders(Header[] headers) {
        this.availableheaders.clear();
        int i = 0;
        while (i < headers.length) {
            this.availableheaders.add(headers[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.relatedconfigs.length) {
            ((OperationConfigurationImpl)this.relatedconfigs[i2]).setAvailableHeaders(this.availableheaders);
            ++i2;
        }
    }

    public void setWSDLBindingName(PortName name) {
        this.wsdlbindingname = name;
    }

    public void processProperties(Document d, Node parent) {
        int i = 0;
        while (i < this.properties.size()) {
            boolean writepermission = true;
            PropertyImpl p = (PropertyImpl)this.properties.elementAt(i);
            if (!p.getName().equals("endpoint-header-schemas") || p.getName().equals("endpoint-header-schemas") && !p.getValue().equals("")) {
                if (this.name.equals("HTTP_TransportBinding") && p.getName().equals("endpoint-header-schemas")) {
                    writepermission = false;
                } else if (!this.name.equals("HTTP_TransportBinding") && p.getName().equals("method")) {
                    writepermission = false;
                }
                if (writepermission) {
                    parent.appendChild(((PropertyImpl)this.properties.elementAt(i)).createDOMNode(d));
                }
            }
            ++i;
        }
    }

    public void fillWithData(Node node) {
        Property p;
        this.displayname = this.name = ((Element)node).getAttribute("name");
        Node childnode = node.getFirstChild();
        while (childnode != null) {
            if (childnode.getNodeName().equals("property")) {
                PropertyImpl property = new PropertyImpl();
                property.fillWithData(childnode);
                this.properties.add(property);
            } else if (childnode.getNodeName().equals("wsdl-binding-name")) {
                this.wsdlbindingname = new PortNameImpl("wsdl-binding-name");
                ((PortNameImpl)this.wsdlbindingname).fillWithData(childnode);
            }
            childnode = childnode.getNextSibling();
        }
        boolean found = false;
        int i = 0;
        while (i < this.properties.size()) {
            p = (Property)this.properties.elementAt(i);
            if (p.getName().equals("endpoint-header-schemas")) {
                found = true;
                if (!p.getValue().trim().equals("")) {
                    try {
                        this.parseSchema(p.getValue(), this.availableheaders);
                    }
                    catch (Exception e) {
                        p.setValue("");
                    }
                }
            } else if (p.getName().equals("method")) {
                ((PropertyImpl)p).setIsWebMethod(true);
            }
            ++i;
        }
        if (!found) {
            p = new PropertyImpl();
            p.setName("endpoint-header-schemas");
            this.properties.add(p);
        }
    }

    public Property[] getProperties() {
        Property[] properties1 = new Property[this.properties.size()];
        int i = 0;
        while (i < properties1.length) {
            properties1[i] = (Property)this.properties.elementAt(i);
            ++i;
        }
        return properties1;
    }

    public void setProperties(Property[] p) {
        this.properties.clear();
        int i = 0;
        while (i < p.length) {
            this.properties.add(p[i]);
            ++i;
        }
    }

    public Node createDOMNode(Document d) {
        Element node = d.createElement("transport-binding");
        node.setAttribute("name", this.name);
        if (this.wsdlbindingname != null) {
            node.appendChild(((PortNameImpl)this.wsdlbindingname).createDOMNode(d));
        }
        this.processProperties(d, node);
        return node;
    }

    public void setRelatedConfigs(OperationConfiguration[] configs) {
        block5: {
            block4: {
                this.relatedconfigs = configs;
                int j = 0;
                while (j < this.relatedconfigs.length) {
                    ((OperationConfigurationImpl)this.relatedconfigs[j]).setAvailableHeaders(this.availableheaders);
                    ++j;
                }
                if (!this.name.equals("HTTP_TransportBinding")) break block4;
                int j2 = 0;
                while (j2 < this.relatedconfigs.length) {
                    InputImpl i = (InputImpl)((OperationConfigurationImpl)this.relatedconfigs[j2]).getTransportBindingConfiguration().getInput();
                    i.setPropertyFilter(i.getNamespaceFilter());
                    OutputImpl o = (OutputImpl)((OperationConfigurationImpl)this.relatedconfigs[j2]).getTransportBindingConfiguration().getOutput();
                    o.setPropertyFilter(o.getNamespaceFilter());
                    Fault[] f = ((OperationConfigurationImpl)this.relatedconfigs[j2]).getTransportBindingConfiguration().getFaults();
                    int k = 0;
                    while (k < f.length) {
                        ((FaultImpl)f[k]).setPropertyFilter(((FaultImpl)f[k]).getNamespaceFilter());
                        ++k;
                    }
                    ++j2;
                }
                break block5;
            }
            if (!this.name.equals("SOAPHTTP_TransportBinding")) break block5;
            int j = 0;
            while (j < this.relatedconfigs.length) {
                InputImpl i = (InputImpl)((OperationConfigurationImpl)this.relatedconfigs[j]).getTransportBindingConfiguration().getInput();
                i.setPropertyFilter(i.getSOAPFilter());
                OutputImpl o = (OutputImpl)((OperationConfigurationImpl)this.relatedconfigs[j]).getTransportBindingConfiguration().getOutput();
                o.setPropertyFilter(o.getSOAPFilter());
                ++j;
            }
        }
    }

    public void parseSchema(String schema, Vector headers) throws Exception {
        StringReader sr = new StringReader(schema);
        InputSource isource = new InputSource(sr);
        DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(isource);
        Element e = doc.getDocumentElement();
        if (e.getNodeName().equals("xs:schema")) {
            String namespace = e.getAttribute("targetNamespace");
            if (namespace == null) {
                namespace = "";
            }
            headers.clear();
            Node childnode = e.getFirstChild();
            while (childnode != null) {
                if (childnode.getNodeName().equals("xs:element")) {
                    Header h = new Header();
                    h.setNamespace(namespace);
                    h.setName("");
                    h.setLocalname(((Element)childnode).getAttribute("name"));
                    headers.add(h);
                }
                childnode = childnode.getNextSibling();
            }
        }
    }

    public void setName(String newname) {
        if (newname.equals("HTTP SOAP")) {
            this.name = "SOAPHTTP_TransportBinding";
            int j = 0;
            while (j < this.relatedconfigs.length) {
                InputImpl i = (InputImpl)((OperationConfigurationImpl)this.relatedconfigs[j]).getTransportBindingConfiguration().getInput();
                i.setPropertyFilter(i.getSOAPFilter());
                OutputImpl o = (OutputImpl)((OperationConfigurationImpl)this.relatedconfigs[j]).getTransportBindingConfiguration().getOutput();
                o.setPropertyFilter(o.getSOAPFilter());
                ++j;
            }
        } else if (newname.equals("HTTP GET") || newname.equals("HTTP POST") || newname.equals("HTTP_TransportBinding")) {
            this.name = "HTTP_TransportBinding";
            if (newname.equals("HTTP GET")) {
                this.findWebMethodProperty().setValue("GET");
            } else {
                this.findWebMethodProperty().setValue("POST");
            }
            int j = 0;
            while (j < this.relatedconfigs.length) {
                InputImpl i = (InputImpl)((OperationConfigurationImpl)this.relatedconfigs[j]).getTransportBindingConfiguration().getInput();
                i.setPropertyFilter(i.getNamespaceFilter());
                OutputImpl o = (OutputImpl)((OperationConfigurationImpl)this.relatedconfigs[j]).getTransportBindingConfiguration().getOutput();
                o.setPropertyFilter(o.getNamespaceFilter());
                Fault[] f = ((OperationConfigurationImpl)this.relatedconfigs[j]).getTransportBindingConfiguration().getFaults();
                int k = 0;
                while (k < f.length) {
                    ((FaultImpl)f[k]).setPropertyFilter(((FaultImpl)f[k]).getNamespaceFilter());
                    ++k;
                }
                ++j;
            }
        } else {
            this.name = newname.equals("HTTP SOAP with Attachments") ? "MIME_TransportBinding" : newname;
        }
        this.displayname = newname;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayname;
    }

    public boolean getChanged() {
        boolean ch = this.changed;
        this.changed = false;
        return ch;
    }

    Property findWebMethodProperty() {
        int i = 0;
        while (i < this.properties.size()) {
            if (((Property)this.properties.elementAt(i)).getName().equals("method")) {
                return (Property)this.properties.elementAt(i);
            }
            ++i;
        }
        PropertyImpl p = new PropertyImpl();
        p.setName("method");
        this.properties.add(p);
        return p;
    }

    public void setWebMethod(String newmethod) {
        Property webmethod = this.findWebMethodProperty();
        if (newmethod.equals("POST") || newmethod.equals("GET")) {
            webmethod.setValue(newmethod);
        }
    }

    public String getWebMethod() {
        Property webmethod = this.findWebMethodProperty();
        return webmethod.getValue();
    }
}

