/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wsddman.impl0;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.wsddman.Property;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PropertyImpl
implements Property {
    public static final String[] SUPPORTED_ENCODINGS = new String[]{"http://schemas.xmlsoap.org/soap/encoding/"};
    String name = "";
    String value = "";
    Vector properties = null;
    boolean isheader = false;
    boolean isheaderproperty = false;
    boolean issecurity = false;
    Vector availableheaders = null;
    boolean changed = false;
    boolean iswebmethodproperty = false;
    boolean isattachments = false;
    boolean isattachment = false;
    boolean isselectedattachment = true;
    boolean isdefault = false;

    public void setDefault(boolean def) {
        this.isdefault = def;
    }

    public boolean isDefault() {
        return this.isdefault;
    }

    public boolean isSelectedAttachment() {
        return this.isselectedattachment;
    }

    public void setSelectedAttachment(boolean selected) {
        this.isselectedattachment = selected;
    }

    public boolean isSecurityRoles() {
        return this.issecurity;
    }

    public boolean isAttachments() {
        return this.isattachments;
    }

    public boolean isAttachment() {
        return this.isattachment;
    }

    public void setIsSecurityRoles(boolean b) {
        this.issecurity = b;
    }

    public void setIsAttachments(boolean b) {
        this.isattachments = b;
    }

    public void setIsAttachment(boolean b) {
        this.isattachment = b;
    }

    public void setIsWebMethod(boolean iswebmethod) {
        this.iswebmethodproperty = iswebmethod;
    }

    public void setIsHeader(boolean isheader) {
        this.isheader = isheader;
    }

    public void setIsHeaderProperty(boolean b) {
        this.isheaderproperty = b;
    }

    public void setAvailableHeaders(Vector v) {
        if (this.name.equals("headers")) {
            this.availableheaders = v;
        }
    }

    public Node createDOMNode(Document d) {
        Element node = d.createElement("property");
        node.setAttribute("name", this.name);
        if (this.name.equals("endpoint-header-schemas")) {
            if (!this.value.equals("")) {
                Element simplecontent = d.createElement("simpleContent");
                CDATASection cdata = d.createCDATASection(this.value);
                simplecontent.appendChild(cdata);
                node.appendChild(simplecontent);
            }
        } else if (this.name.equals("headers") || this.isheader || this.name.equals("security-roles") || this.name.equals("attachment-parts") || this.isattachment) {
            this.processProperties(d, node);
        } else {
            node.setAttribute("value", this.value);
        }
        return node;
    }

    public void fillWithData(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr item = (Attr)attrs.item(i);
            if (item.getName().equals("name")) {
                this.name = item.getValue();
                if (this.name.equals("endpoint-header-schemas")) {
                    Node simplecontent = node.getFirstChild();
                    while (simplecontent != null && !simplecontent.getNodeName().equals("simpleContent")) {
                        simplecontent = simplecontent.getNextSibling();
                    }
                    if (simplecontent != null && simplecontent.getNodeName().equals("simpleContent")) {
                        Node cdata = simplecontent.getFirstChild();
                        while (cdata != null) {
                            if (cdata instanceof CDATASection) {
                                this.value = ((CDATASection)cdata).getData();
                            }
                            cdata = cdata.getNextSibling();
                        }
                    }
                } else if (this.name.equals("headers") || this.isheader || this.name.equals("security-roles") || this.name.equals("attachment-parts") || this.isattachment) {
                    Node childnode = node.getFirstChild();
                    while (childnode != null) {
                        if (childnode.getNodeName().equals("property")) {
                            PropertyImpl property = new PropertyImpl();
                            if (this.properties == null) {
                                this.properties = new Vector();
                            }
                            if (this.name.equals("headers") && !this.isheader) {
                                property.setIsHeader(true);
                            } else if (this.isheader) {
                                property.setIsHeaderProperty(true);
                            } else if (this.name.equals("security-roles")) {
                                property.setIsSecurityRoles(true);
                            } else if (this.name.equals("attachment-parts")) {
                                this.setIsAttachments(true);
                                property.setIsAttachment(true);
                            } else if (this.isattachments) {
                                property.setIsAttachment(true);
                            }
                            property.fillWithData(childnode);
                            this.properties.add(property);
                        }
                        childnode = childnode.getNextSibling();
                    }
                }
            } else if (item.getName().equals("value") && !this.name.equals("endpoint-header-schemas") && !this.name.equals("headers") && !this.isheader) {
                this.value = item.getValue();
            }
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setImageToTreeItem(TreeItem ti, Image image) {
        try {
            ti.setImage(image);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
    }

    public Property[] getProperties() {
        if (this.properties == null) {
            this.properties = new Vector();
        }
        Property[] properties1 = new Property[this.properties.size()];
        int i = 0;
        while (i < properties1.length) {
            properties1[i] = (Property)this.properties.elementAt(i);
            ++i;
        }
        return properties1;
    }

    public void setProperties(Property[] p) {
        if (this.properties == null && (this.name.equals("headers") || this.isheader || this.name.equals("security-roles") || this.name.equals("attachment-parts") || this.isattachment)) {
            this.properties = new Vector();
        } else {
            this.properties.clear();
        }
        int i = 0;
        while (i < p.length) {
            this.properties.add(p[i]);
            ++i;
        }
    }

    public void processProperties(Document d, Node parent) {
        if (this.properties != null) {
            int i = 0;
            while (i < this.properties.size()) {
                boolean includeattachment;
                boolean bl = includeattachment = !((PropertyImpl)this.properties.elementAt(i)).isAttachment() || ((PropertyImpl)this.properties.elementAt(i)).isAttachment() && ((PropertyImpl)this.properties.elementAt(i)).isSelectedAttachment();
                if ((!((PropertyImpl)this.properties.elementAt(i)).getName().equals("headers") || ((PropertyImpl)this.properties.elementAt(i)).getName().equals("attachment-parts") || ((PropertyImpl)this.properties.elementAt(i)).getProperties().length != 0) && includeattachment) {
                    parent.appendChild(((PropertyImpl)this.properties.elementAt(i)).createDOMNode(d));
                }
                ++i;
            }
        }
    }

    public boolean getChanged() {
        boolean ch = this.changed;
        this.changed = false;
        return ch;
    }

    public String toString() {
        if (this.isattachment) {
            return this.name;
        }
        return this.name + ":" + this.value;
    }
}

