/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wsddman.impl0;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.wsddman.Fault;
import com.sap.ide.ws.wsddman.Feature;
import com.sap.ide.ws.wsddman.Input;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.Output;
import com.sap.ide.ws.wsddman.Property;
import com.sap.ide.ws.wsddman.TransportBindingConfiguration;
import com.sap.ide.ws.wsddman.impl0.FaultImpl;
import com.sap.ide.ws.wsddman.impl0.FeatureImpl;
import com.sap.ide.ws.wsddman.impl0.InputImpl;
import com.sap.ide.ws.wsddman.impl0.OutputImpl;
import com.sap.ide.ws.wsddman.impl0.PropertyImpl;
import com.sap.ide.ws.wsddman.impl0.TransportBindingConfigurationImpl;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OperationConfigurationImpl
implements OperationConfiguration {
    public static final String SECURITY_FEATURE_NAME = "http://sap.com/webservices/authorization";
    public static final String USER_ROLE_PROPERTY = "security-roles";
    public String name = "";
    public TransportBindingConfiguration transportbindingcfg = new TransportBindingConfigurationImpl();
    public Vector features = new Vector();
    Vector securityroles = new Vector();
    String documentation = "";
    String namemappedto = "";
    boolean securityrolesallowed = false;
    Vector headers = null;
    private String ownername;

    public void setAvailableHeaders(Vector v) {
        ((InputImpl)this.transportbindingcfg.getInput()).setAvailableHeaders(v);
        ((OutputImpl)this.transportbindingcfg.getOutput()).setAvailableHeaders(v);
        this.headers = v;
    }

    public Node createDOMNode(Document d) {
        boolean hassecurityfeature = false;
        Element node = d.createElement("operation-configuration");
        node.setAttribute("uniqueViName", this.name);
        if (this.documentation != null && !this.documentation.equals("")) {
            Element docu = d.createElement("documentation");
            Text tx = d.createTextNode(this.documentation);
            docu.appendChild(tx);
            node.appendChild(docu);
        }
        node.appendChild(((TransportBindingConfigurationImpl)this.transportbindingcfg).createDOMNode(d));
        int i = 0;
        while (i < this.features.size()) {
            boolean hasroles = true;
            FeatureImpl fi = (FeatureImpl)this.features.elementAt(i);
            if (fi.getName().equals(SECURITY_FEATURE_NAME)) {
                if (!this.securityrolesallowed) {
                    hasroles = false;
                    this.features.remove(fi);
                } else {
                    this.setSecurityRoles(fi, this.securityroles);
                    hassecurityfeature = true;
                }
            }
            if (hasroles) {
                node.appendChild(fi.createDOMNode(d));
            }
            ++i;
        }
        if (!hassecurityfeature && this.securityrolesallowed) {
            FeatureImpl f = new FeatureImpl();
            f.setName(SECURITY_FEATURE_NAME);
            f.setProtocol("SecurityProtocol");
            this.setSecurityRoles(f, this.securityroles);
            this.features.add(f);
            node.appendChild(f.createDOMNode(d));
        }
        return node;
    }

    public void fillWithData(Node node) {
        Node childnode = node.getFirstChild();
        NamedNodeMap attrs = node.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr item = (Attr)attrs.item(i);
            if (item.getName().equals("uniqueViName")) {
                this.name = item.getValue();
            }
            ++i;
        }
        while (childnode != null) {
            if (childnode.getNodeName().equals("transport-binding-configuration")) {
                this.transportbindingcfg = new TransportBindingConfigurationImpl();
                ((TransportBindingConfigurationImpl)this.transportbindingcfg).fillWithData(childnode);
            } else if (childnode.getNodeName().equals("feature")) {
                FeatureImpl feature = new FeatureImpl();
                feature.fillWithData(childnode);
                this.features.add(feature);
                if (feature.getName().equals(SECURITY_FEATURE_NAME)) {
                    this.securityroles = this.getSecurityRoles(feature);
                }
            } else if (childnode.getNodeName().equals("documentation")) {
                Text tx = (Text)childnode.getFirstChild();
                this.documentation = tx.getData().trim();
            }
            childnode = childnode.getNextSibling();
        }
    }

    public String getName() {
        return this.name;
    }

    public TransportBindingConfiguration getTransportBindingConfiguration() {
        return this.transportbindingcfg;
    }

    public Feature[] getFeatures() {
        Feature[] features1 = new Feature[this.features.size()];
        int i = 0;
        while (i < features1.length) {
            features1[i] = (Feature)this.features.elementAt(i);
            ++i;
        }
        return features1;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransportBindingConfiguration(TransportBindingConfiguration cfg) {
        this.transportbindingcfg = cfg;
    }

    public void setFeatures(Feature[] f) {
        this.features.clear();
        int i = 0;
        while (i < f.length) {
            this.features.add(f[i]);
            ++i;
        }
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setImageToTreeItem(TreeItem ti, Image image) {
        try {
            ti.setImage(image);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
    }

    public void setOwnerName(String newname) {
        this.ownername = newname;
        ((InputImpl)this.transportbindingcfg.getInput()).setDefaultProperties();
        ((OutputImpl)this.transportbindingcfg.getOutput()).setDefaultProperties();
        Fault[] f = this.transportbindingcfg.getFaults();
        int i = 0;
        while (i < f.length) {
            ((FaultImpl)f[i]).setDefaultProperties();
            ++i;
        }
    }

    public void removeAllHeaders() {
        Input i = this.transportbindingcfg.getInput();
        Output o = this.transportbindingcfg.getOutput();
        ((InputImpl)i).removeAllHeaders();
        ((OutputImpl)o).removeAllHeaders();
    }

    public String getOwnername() {
        return this.ownername;
    }

    public void setSecurityRoles(Vector roles) {
        this.securityroles = roles;
    }

    public Vector getSecurityRoles() {
        return this.securityroles;
    }

    public boolean getChanged() {
        return false;
    }

    private Vector getSecurityRoles(Feature feature) {
        Property prop = this.findProperty(feature);
        Property[] props = new Property[]{};
        if (prop != null) {
            props = prop.getProperties();
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < props.length) {
            v.add(props[i].getValue());
            ++i;
        }
        return v;
    }

    private Property findProperty(Feature feature) {
        Property[] props;
        if (feature != null && (props = feature.getProperties()) != null) {
            int k = 0;
            while (k < props.length) {
                if (USER_ROLE_PROPERTY.equals(props[k].getName())) {
                    return props[k];
                }
                ++k;
            }
        }
        return null;
    }

    private Property[] getNewProperties(Property[] oldProps, String roles) {
        Property[] newProps = new Property[oldProps.length + 1];
        System.arraycopy(oldProps, 0, newProps, 0, oldProps.length);
        newProps[newProps.length - 1] = new PropertyImpl();
        newProps[newProps.length - 1].setName(USER_ROLE_PROPERTY);
        newProps[newProps.length - 1].setValue(roles);
        return newProps;
    }

    private void setSecurityRoles(Feature feature, Vector roles) {
        String securityroles = "";
        Property[] props = new Property[roles.size()];
        int i = 0;
        while (i < roles.size()) {
            props[i] = new PropertyImpl();
            props[i].setName("role" + (i + 1));
            props[i].setValue((String)roles.elementAt(i));
            ++i;
        }
        if (feature != null) {
            Property prop = this.findProperty(feature);
            if (prop != null) {
                prop.setProperties(props);
            } else {
                feature.setProperties(this.getNewProperties(feature.getProperties(), securityroles));
                Property pr = this.findProperty(feature);
                pr.setProperties(props);
            }
        } else if (roles.size() > 0) {
            feature = new FeatureImpl();
            feature.setName(SECURITY_FEATURE_NAME);
            feature.setProperties(this.getNewProperties(new Property[0], securityroles));
            this.features.add(feature);
        }
    }

    public void setIncomingParameters(Vector parameters, Vector paramtypes) {
        ((InputImpl)this.transportbindingcfg.getInput()).setAttachments(parameters, paramtypes);
    }

    public void setOutgoingParameters(Vector parameters, Vector paramtypes) {
        ((OutputImpl)this.transportbindingcfg.getOutput()).setAttachments(parameters, paramtypes);
    }

    public void setNameMappedTo(String name) {
        this.namemappedto = name;
    }

    public String getNameMappedTo() {
        return this.namemappedto;
    }

    public void setSecurityRolesAllowed(boolean allowed) {
        this.securityrolesallowed = allowed;
    }

    public boolean areSecurityRolesAllowed() {
        return this.securityrolesallowed;
    }
}

