/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wsddman.impl0;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.soapapp.FeatureConstants;
import com.sap.ide.ws.wsddman.Feature;
import com.sap.ide.ws.wsddman.Property;
import com.sap.ide.ws.wsddman.impl0.FeatureImpl;
import com.sap.ide.ws.wsddman.impl0.PropertyImpl;

public class DeployTimeFeatures
implements FeatureConstants {
    boolean none = false;
    boolean httpswithoutauth = false;
    boolean httpbasicauth = false;
    boolean httpsbasicauth = false;
    boolean httpsX509auth = false;
    boolean httpX509auth = false;
    int deployfeaturecount;
    boolean hassession = false;
    boolean mustcreateSSO = true;
    boolean hasSSO2 = false;
    int authmechanism = 0;
    static final int AUTH_MECHANISM_NONE = 0;
    static final int AUTH_MECHANISM_HTTP = 1;
    static final int AUTH_MECHANISM_DOCUMENT = 2;

    void initFeatures(Feature[] features) {
        boolean notrguarantee = false;
        boolean bothtrguarantee = false;
        boolean noauthentication = false;
        boolean defaultauthentication = false;
        boolean strongauthentication = false;
        try {
            int i = 0;
            while (i < features.length) {
                Property[] p;
                if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/transportguarantee")) {
                    p = features[i].getProperties();
                    if (p[0].getName().equals("Level")) {
                        if (p[0].getValue().equals("No")) {
                            notrguarantee = true;
                        } else if (p[0].getValue().equals("Both")) {
                            bothtrguarantee = true;
                        }
                    }
                } else if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/authentication")) {
                    p = features[i].getProperties();
                    if (p[0].getName().equals("AuthenticationLevel")) {
                        if (p[0].getValue().equals("None")) {
                            noauthentication = true;
                        } else if (p[0].getValue().equals("Basic")) {
                            defaultauthentication = true;
                        } else if (p[0].getValue().equals("Strong")) {
                            strongauthentication = true;
                        }
                    } else if (p[0].getName().equals("SupportsSSO2Authentication")) {
                        this.mustcreateSSO = false;
                        if (p[0].getValue().equals("true")) {
                            this.hasSSO2 = true;
                        }
                    }
                } else if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/session/")) {
                    this.hassession = true;
                    ++this.deployfeaturecount;
                }
                ++i;
            }
            if (this.mustcreateSSO) {
                ++this.deployfeaturecount;
            }
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
        notrguarantee = !bothtrguarantee;
        boolean bl = noauthentication = !defaultauthentication && !strongauthentication;
        if (notrguarantee && noauthentication) {
            this.none = true;
        } else if (notrguarantee && defaultauthentication) {
            this.httpbasicauth = true;
        } else if (notrguarantee && strongauthentication) {
            this.httpX509auth = true;
        } else if (bothtrguarantee && noauthentication) {
            this.httpswithoutauth = true;
        } else if (bothtrguarantee && defaultauthentication) {
            this.httpsbasicauth = true;
        } else if (bothtrguarantee && strongauthentication) {
            this.httpsX509auth = true;
        }
    }

    public Feature[] createDeployTimeFeatures(Feature[] designtimefeatures) {
        Property[] properties;
        this.deployfeaturecount = 0;
        this.hassession = false;
        this.initFeatures(designtimefeatures);
        if (!this.none && !this.httpswithoutauth) {
            ++this.deployfeaturecount;
        }
        Feature[] dtfeatures = new Feature[this.deployfeaturecount];
        int deployfeatureindex = 0;
        if (this.none) {
            if (this.mustcreateSSO) {
                ++this.deployfeaturecount;
                dtfeatures = new Feature[this.deployfeaturecount];
            }
        } else if (this.httpswithoutauth) {
            this.deployfeaturecount += 2;
            dtfeatures = new Feature[this.deployfeaturecount];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            deployfeatureindex = 1;
            this.authmechanism = 0;
        } else if (this.httpbasicauth) {
            ++this.deployfeaturecount;
            dtfeatures = new Feature[this.deployfeaturecount];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("BasicAuth");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            deployfeatureindex = 1;
            this.authmechanism = 1;
        } else if (this.httpsbasicauth) {
            this.deployfeaturecount += 2;
            dtfeatures = new Feature[this.deployfeaturecount];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("BasicAuth");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            dtfeatures[1] = new FeatureImpl();
            dtfeatures[1].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[1].setProperties(properties);
            ((FeatureImpl)dtfeatures[1]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[1]).setProtocol("SecurityProtocol");
            this.authmechanism = 1;
            deployfeatureindex = 2;
        } else if (this.httpsX509auth) {
            this.deployfeaturecount += 2;
            dtfeatures = new Feature[this.deployfeaturecount];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("CertAuth");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            dtfeatures[1] = new FeatureImpl();
            dtfeatures[1].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[1].setProperties(properties);
            ((FeatureImpl)dtfeatures[1]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[1]).setProtocol("SecurityProtocol");
            deployfeatureindex = 2;
            this.authmechanism = 2;
        } else if (this.httpX509auth) {
            ++this.deployfeaturecount;
            dtfeatures = new Feature[this.deployfeaturecount];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("CertAuth");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            deployfeatureindex = 1;
            this.authmechanism = 2;
        }
        if (this.hassession) {
            dtfeatures[deployfeatureindex] = new FeatureImpl();
            dtfeatures[deployfeatureindex].setName("http://www.sap.com/webas/630/soap/features/session/");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("SessionMethod");
            properties[0].setValue("httpCookies");
            dtfeatures[deployfeatureindex].setProperties(properties);
            ((FeatureImpl)dtfeatures[deployfeatureindex]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[deployfeatureindex]).setProtocol("HTTP_StatefulProtocol");
            ++deployfeatureindex;
        }
        dtfeatures[deployfeatureindex] = new FeatureImpl();
        dtfeatures[deployfeatureindex].setName("http://www.sap.com/webas/630/soap/features/authentication");
        properties = new Property[]{new PropertyImpl()};
        properties[0].setName("AuthenticationMechanism");
        if (this.authmechanism == 0) {
            properties[0].setValue("None");
        } else if (this.authmechanism == 1 && !this.hasSSO2) {
            properties[0].setValue("HTTP");
        } else {
            properties[0].setValue("Document");
        }
        dtfeatures[deployfeatureindex].setProperties(properties);
        ((FeatureImpl)dtfeatures[deployfeatureindex]).setIsDeployTimeFeature(true);
        ((FeatureImpl)dtfeatures[deployfeatureindex]).setProtocol("SecurityProtocol");
        ++deployfeatureindex;
        if (this.mustcreateSSO) {
            dtfeatures[deployfeatureindex] = new FeatureImpl();
            dtfeatures[deployfeatureindex].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("SupportsSSO2Authentication");
            properties[0].setValue("false");
            dtfeatures[deployfeatureindex].setProperties(properties);
            ((FeatureImpl)dtfeatures[deployfeatureindex]).setProtocol("SecurityProtocol");
        }
        return dtfeatures;
    }

    public boolean mustAddSecurityRoles() {
        return !this.none;
    }
}

