/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.soapapp.java;

import com.sap.ide.ws.cfg.DeploymentConfiguration;
import com.sap.ide.ws.soapapp.FeatureConstants;
import com.sap.ide.ws.soapapp.FeatureDt;
import com.sap.ide.ws.soapapp.InvalidSAConfigurationException;
import com.sap.ide.ws.soapapp.PropertyDt;
import com.sap.ide.ws.soapapp.SOAPApplicationDt;
import com.sap.ide.ws.soapapp.ejb1.EnumImpl;
import com.sap.ide.ws.soapapp.ejb1.EnumValueImpl;
import com.sap.ide.ws.soapapp.ejb1.FeatureDtImpl;
import com.sap.ide.ws.soapapp.ejb1.PropertyDtImpl;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.Feature;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.Property;
import com.sap.ide.ws.wsddman.impl0.DeployTimeFeatures;
import com.sap.ide.ws.wsddman.impl0.FeatureImpl;
import com.sap.ide.ws.wsddman.impl0.OperationConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.PropertyImpl;
import java.util.Vector;

public class JavaSoapApp
implements SOAPApplicationDt,
FeatureConstants {
    public static final String SIMPLE_SOAP_DEFAULT_CFG = "Simple SOAP";
    public static final String BASIC_AUTH_SOAP_DEFAULT_CFG = "Basic Auth SOAP";
    public static final String SECURE_SOAP_DEFAULT_CFG = "Secure SOAP";
    private FeatureDt[] featureList;
    private String[] defConfigurationNames = new String[]{"Simple SOAP", "Basic Auth SOAP", "Secure SOAP"};

    public String getType() {
        return "EP_TYPE_JAVACLASS";
    }

    public String getName() {
        return "Java Class SOAP Application";
    }

    public String getDescription() {
        return "This SOAP Application supports Standard Java Classes as endpoints. It supports the Features: Security and Stateful";
    }

    public JavaSoapApp() {
        this.initialize();
    }

    public FeatureDt[] getFeatures() {
        return this.featureList;
    }

    public void initialize() {
        PropertyDt[] p231 = new PropertyDtImpl[]{};
        PropertyDt[] p241 = new PropertyDtImpl[1];
        Vector<EnumValueImpl> vp241 = new Vector<EnumValueImpl>();
        vp241.add(new EnumValueImpl("No Authentication", "en", "None"));
        vp241.add(new EnumValueImpl("Basic (user/password)", "en", "Basic"));
        vp241.add(new EnumValueImpl("Strong (incl. Certificates)", "en", "Strong"));
        EnumImpl ep241 = new EnumImpl(vp241);
        p241[0] = new PropertyDtImpl("AuthenticationLevel", "Authentication Level", "Select Authentication Level", "en", true, true, "None", ep241);
        PropertyDt[] p242 = new PropertyDtImpl[]{};
        PropertyDt[] p243 = new PropertyDtImpl[1];
        Vector<EnumValueImpl> vp243 = new Vector<EnumValueImpl>();
        vp243.add(new EnumValueImpl("No", "en", "No"));
        vp243.add(new EnumValueImpl("Integrity + Confidentiality", "en", "Both"));
        EnumImpl ep243 = new EnumImpl(vp243);
        p243[0] = new PropertyDtImpl("Level", "Level", "Select Transport Guarantee Level", "en", true, true, "No", ep243);
        PropertyDt[] p244 = new PropertyDtImpl[]{};
        this.featureList = new FeatureDtImpl[5];
        FeatureDtImpl f231 = new FeatureDtImpl("http://www.sap.com/webas/630/soap/features/session/", "Session", "Session", "en", false, p231);
        FeatureDtImpl f241 = new FeatureDtImpl("http://www.sap.com/webas/630/soap/features/authentication", "Authentication", "Authentication", "en", true, p241);
        FeatureDtImpl f242 = new FeatureDtImpl("http://www.sap.com/webas/630/soap/features/authorization", "Authorization", "Authorization", "en", false, p242);
        FeatureDtImpl f243 = new FeatureDtImpl("http://www.sap.com/webas/630/soap/features/transportguarantee", "Transport Guarantee", "Transport Guarantee", "en", true, p243);
        FeatureDtImpl f244 = new FeatureDtImpl("http://www.sap.com/webas/640/soap/features/messageId", "Message ID", "Message ID", "en", false, p244);
        this.featureList[0] = f231;
        this.featureList[1] = f241;
        this.featureList[2] = f242;
        this.featureList[3] = f243;
        this.featureList[4] = f244;
    }

    public boolean checkConfiguration(Object cfg) throws InvalidSAConfigurationException {
        return true;
    }

    public String[] getDefaultConfigurationNames() {
        return this.defConfigurationNames;
    }

    public String getDescriptionForConfiguration(String cfgname) {
        if (cfgname.equals(SIMPLE_SOAP_DEFAULT_CFG)) {
            return "* Transport Binding: SOAP over HTTP\n* Stateless communication\n* No Security";
        }
        if (cfgname.equals(BASIC_AUTH_SOAP_DEFAULT_CFG)) {
            return "* Transport Binding: SOAP over HTTP\n* Stateless communication\n* Authentication: HTTP Basic\n* Authorization: yes\n   * All EJB Security roles assigned to all WebService methods\n* Transport Guarantee: No";
        }
        if (cfgname.equals(SECURE_SOAP_DEFAULT_CFG)) {
            return "* Transport Binding: SOAP over HTTPS\n* Stateless communication\n* Authentication: Certificates\n* Authorization: yes\n   * All EJB Security roles assigned to all WebService methods\n* Transport Guarantee: Integrity and Confidentiality";
        }
        return "No Description Available";
    }

    public void fillAsDefaultConfiguration(Configuration cfg) {
    }

    public void fillAsDefaultConfiguration(String name, Configuration cfg, DeploymentConfiguration dcfg) {
        OperationConfiguration[] cfgs;
        String[] s;
        Property[] props;
        Feature[] newfeatures = cfg.getGlobalFeatures();
        if (name.equals(SIMPLE_SOAP_DEFAULT_CFG)) {
            newfeatures = new Feature[]{new FeatureImpl()};
            newfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            props = new Property[]{new PropertyImpl()};
            props[0].setName("AuthenticationLevel");
            props[0].setValue("None");
            newfeatures[0].setProperties(props);
        } else if (name.equals(BASIC_AUTH_SOAP_DEFAULT_CFG)) {
            newfeatures = new Feature[]{new FeatureImpl()};
            newfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            props = new Property[]{new PropertyImpl()};
            props[0].setName("AuthenticationLevel");
            props[0].setValue("Basic");
            newfeatures[0].setProperties(props);
            s = dcfg.getSecurityRoles();
            cfgs = cfg.getOperationConfigurations();
            int i = 0;
            while (i < cfgs.length) {
                Vector<String> v = new Vector<String>();
                int j = 0;
                while (j < s.length) {
                    v.add(s[j]);
                    ++j;
                }
                ((OperationConfigurationImpl)cfgs[i]).setSecurityRoles(v);
                ++i;
            }
        } else if (name.equals(SECURE_SOAP_DEFAULT_CFG)) {
            newfeatures = new Feature[2];
            newfeatures[0] = new FeatureImpl();
            newfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            props = new Property[]{new PropertyImpl()};
            props[0].setName("AuthenticationLevel");
            props[0].setValue("Strong");
            newfeatures[0].setProperties(props);
            newfeatures[1] = new FeatureImpl();
            newfeatures[1].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            props[0] = new PropertyImpl();
            props[0].setName("Level");
            props[0].setValue("Both");
            newfeatures[1].setProperties(props);
            s = dcfg.getSecurityRoles();
            cfgs = cfg.getOperationConfigurations();
            int i = 0;
            while (i < cfgs.length) {
                Vector<String> v = new Vector<String>();
                int j = 0;
                while (j < s.length) {
                    v.add(s[j]);
                    ++j;
                }
                ((OperationConfigurationImpl)cfgs[i]).setSecurityRoles(v);
                ++i;
            }
        }
        DeployTimeFeatures dtf = new DeployTimeFeatures();
        Feature[] deploytimefeatures = dtf.createDeployTimeFeatures(newfeatures);
        Feature[] allfeatures = new Feature[newfeatures.length + deploytimefeatures.length];
        System.arraycopy(newfeatures, 0, allfeatures, 0, newfeatures.length);
        System.arraycopy(deploytimefeatures, 0, allfeatures, newfeatures.length, deploytimefeatures.length);
        cfg.setGlobalFeatures(allfeatures);
    }

    public String getAccessUrlName(String wsname, String cfgname) {
        return "/" + wsname + "/" + cfgname;
    }
}

