/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.descriptor;

import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.descriptors.DescriptorChangeListener;
import com.sap.ide.ws.core.descriptors.DescriptorHelperFunctions;
import com.sap.ide.ws.core.editors.FileReadOnlyStateHandler;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.resources.EclipseProjectService;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.DeploymentDescriptorManager;
import com.sap.ide.ws.wsddman.impl0.WSDeploymentDescriptorManagerImpl;
import com.tssap.selena.model.elements.ModelAccess;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DescriptorManager
implements IResourceChangeListener {
    private static HashMap mInstanceMap = new HashMap();
    public static final String PATH = "/META-INF/ws-deployment-descriptor.xml";
    private String mProjectName;
    private IProject project;
    private DeploymentDescriptorManager mManager;
    private Vector myChangeListeners = new Vector();
    private IResourceDeltaVisitor myResourceDeltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource instanceof IWorkspaceRoot) {
                return true;
            }
            if (!DescriptorManager.this.getProject().equals((Object)resource.getProject())) {
                return false;
            }
            if (!(resource instanceof IFile)) {
                return true;
            }
            IFile file = (IFile)resource;
            if (!"ws-deployment-descriptor.xml".equals(file.getName())) {
                return true;
            }
            int kind = delta.getKind();
            if (Display.getCurrent() != null) {
                Display.getCurrent().asyncExec(new Runnable(this, kind, file){
                    private final /* synthetic */ int val$kind;
                    private final /* synthetic */ IFile val$file;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$kind = val$kind;
                        this.val$file = val$file;
                    }

                    public void run() {
                        ModelAccess.runCommand((Runnable)new Runnable(this){
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                if ((2.access$100(this.this$2) & 4) > 0) {
                                    DescriptorManager.access$500(1.access$400(2.access$300(this.this$2)), 2.access$200(this.this$2));
                                } else if ((2.access$100(this.this$2) & 1) > 0) {
                                    DescriptorManager.access$600(1.access$400(2.access$300(this.this$2)), 2.access$200(this.this$2));
                                } else if ((2.access$100(this.this$2) & 2) > 0) {
                                    DescriptorManager.access$700(1.access$400(2.access$300(this.this$2)), 2.access$200(this.this$2));
                                }
                            }
                        });
                    }

                    static /* synthetic */ int access$100(2 x0) {
                        return x0.val$kind;
                    }

                    static /* synthetic */ IFile access$200(2 x0) {
                        return x0.val$file;
                    }

                    static /* synthetic */ 1 access$300(2 x0) {
                        return x0.this$1;
                    }
                });
            }
            return true;
        }

        static /* synthetic */ DescriptorManager access$400(1 x0) {
            return x0.DescriptorManager.this;
        }
    };
    static /* synthetic */ Class class$com$sap$ide$ws$core$descriptor$DescriptorManager;

    public static boolean isDescriptorWritable(String descriptorProject) {
        FileReadOnlyStateHandler checkOutHandler = new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName(descriptorProject));
        if (checkOutHandler.isReadOnly()) {
            if (checkOutHandler.isDtrRelevant()) {
                if (!checkOutHandler.checkOutFromDtr()) {
                    MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Info", null, WsCoreUiTexts.getString((String)"WsCore.Messages.Info.fileNotCheckedOut", (String)DescriptorManager.getDescriptorFileByProjectName(descriptorProject).getLocation().toOSString()), 2, new String[]{"Ok"}, 0);
                    dialog.open();
                    return false;
                }
            } else if (!checkOutHandler.changeFileReadOnlyFlag()) {
                MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Info", null, WsCoreUiTexts.getString((String)"WsCore.Messages.Info.fileReadOnlyFlagNotChanged", (String)DescriptorManager.getDescriptorFileByProjectName(descriptorProject).getLocation().toOSString()), 2, new String[]{"Ok"}, 0);
                dialog.open();
                return false;
            }
        }
        return true;
    }

    public static synchronized DescriptorManager getWebServiceDescriptorManager(String projectName) {
        DescriptorManager manager = (DescriptorManager)mInstanceMap.get(projectName);
        if (manager == null) {
            manager = new DescriptorManager(projectName);
            mInstanceMap.put(projectName, manager);
        }
        return manager;
    }

    public static DeploymentDescriptor getDeploymentDescriptor(String projectName) {
        return DescriptorManager.getDeploymentDescriptor(projectName, false);
    }

    public static DeploymentDescriptor getDeploymentDescriptor(String projectName, boolean create) {
        DescriptorManager descriptorManager = DescriptorManager.getWebServiceDescriptorManager(projectName);
        if (descriptorManager != null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            File f = new File(project.getLocation().toString() + PATH);
            if (!f.exists()) {
                if (create) {
                    IProject myProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    try {
                        EclipseProjectService.createFolder((IFolder)myProject.getFolder("META-INF"), (boolean)true, (boolean)true, null);
                    }
                    catch (CoreException e) {
                        WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$core$descriptor$DescriptorManager == null ? (class$com$sap$ide$ws$core$descriptor$DescriptorManager = DescriptorManager.class$("com.sap.ide.ws.core.descriptor.DescriptorManager")) : class$com$sap$ide$ws$core$descriptor$DescriptorManager));
                    }
                    DescriptorHelperFunctions.createWsDeploymentDescriptor((IFile)project.getFile("META-INF" + File.separator + "ws-deployment-descriptor.xml"));
                } else {
                    return null;
                }
            }
            f = new File(project.getLocation().toString() + PATH);
            try {
                return descriptorManager.mManager.loadDeploymentDescirptor(new FileInputStream(f));
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$core$descriptor$DescriptorManager == null ? (class$com$sap$ide$ws$core$descriptor$DescriptorManager = DescriptorManager.class$("com.sap.ide.ws.core.descriptor.DescriptorManager")) : class$com$sap$ide$ws$core$descriptor$DescriptorManager));
            }
        }
        return null;
    }

    public static File getDescriptorFile(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return new File(project.getLocation().toString() + PATH);
    }

    public static boolean isDescriptorReadOnly(String projectName) {
        if (DescriptorManager.getDeploymentDescriptor(projectName) == null) {
            return false;
        }
        return !DescriptorManager.getDescriptorFile(projectName).canWrite();
    }

    public static void saveDeploymentDescriptor(DeploymentDescriptor descriptor, String projectName) {
        IProject project;
        File f;
        if (!DescriptorManager.isDescriptorWritable(projectName)) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Descriptor cannot be written", (String)("Descriptor for project " + projectName + " cannot be written."));
            return;
        }
        DescriptorManager descriptorManager = DescriptorManager.getWebServiceDescriptorManager(projectName);
        if (descriptorManager != null && (f = new File((project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).getLocation().toString() + PATH)).exists()) {
            try {
                FileOutputStream outStream = new FileOutputStream(f);
                descriptorManager.mManager.saveDeploymentDescriptor(descriptor, outStream);
                outStream.flush();
                outStream.close();
                FileInputStream tempFileStream = new FileInputStream(f);
                byte[] buf = new byte[tempFileStream.available()];
                tempFileStream.read(buf);
                IFile file = project.getFile(PATH);
                ByteArrayInputStream source = new ByteArrayInputStream(buf);
                file.setContents((InputStream)source, true, false, (IProgressMonitor)new NullProgressMonitor());
                ((InputStream)source).close();
                tempFileStream.close();
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$core$descriptor$DescriptorManager == null ? (class$com$sap$ide$ws$core$descriptor$DescriptorManager = DescriptorManager.class$("com.sap.ide.ws.core.descriptor.DescriptorManager")) : class$com$sap$ide$ws$core$descriptor$DescriptorManager));
            }
        }
    }

    public static IFile getDescriptorFileByProjectName(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project.getFile(PATH);
    }

    public static void deleteDeploymentDescriptor(String projectName) {
        IFile file = DescriptorManager.getDescriptorFileByProjectName(projectName);
        try {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$core$descriptor$DescriptorManager == null ? (class$com$sap$ide$ws$core$descriptor$DescriptorManager = DescriptorManager.class$("com.sap.ide.ws.core.descriptor.DescriptorManager")) : class$com$sap$ide$ws$core$descriptor$DescriptorManager));
        }
    }

    private DescriptorManager(String projectName) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.mManager = new WSDeploymentDescriptorManagerImpl();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private IProject getProject() {
        return this.project;
    }

    public void addWsdProjectListener(DescriptorChangeListener listener) {
        this.myChangeListeners.add(listener);
    }

    public void removeWsdProjectListener(DescriptorChangeListener listener) {
        this.myChangeListeners.remove(listener);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.getProject() == null) {
            return;
        }
        if (1 == event.getType()) {
            try {
                event.getDelta().accept(this.myResourceDeltaVisitor);
            }
            catch (CoreException ce) {
                WebServiceCorePlugin.logError((Throwable)ce, this.getClass());
            }
        }
    }

    private void fileChanged(IFile file) {
        Iterator listeners = ((AbstractList)this.myChangeListeners).iterator();
        while (listeners.hasNext()) {
            ((DescriptorChangeListener)listeners.next()).wsdDDModified(file);
        }
    }

    private void fileAdded(IFile file) {
        Iterator listeners = ((AbstractList)this.myChangeListeners).iterator();
        while (listeners.hasNext()) {
            ((DescriptorChangeListener)listeners.next()).wsdDDModified(file);
        }
    }

    private void fileRemoved(IFile file) {
        Iterator listeners = ((AbstractList)this.myChangeListeners).iterator();
        while (listeners.hasNext()) {
            ((DescriptorChangeListener)listeners.next()).wsdDDRemoved(file);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$500(DescriptorManager x0, IFile x1) {
        x0.fileChanged(x1);
    }

    static /* synthetic */ void access$600(DescriptorManager x0, IFile x1) {
        x0.fileAdded(x1);
    }

    static /* synthetic */ void access$700(DescriptorManager x0, IFile x1) {
        x0.fileRemoved(x1);
    }
}

