/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sl.util.logging.impl;

import com.sap.sl.util.logging.api.SlUtilLogger;
import com.sap.sl.util.logging.api.SlUtilSeverity;
import com.sap.sl.util.logging.api.TraceLevel;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.TraceFormatter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class SlUtilLoggerImpl
extends SlUtilLogger {
    private Location loc = null;
    private Category cat = null;
    GregorianCalendar cale;
    boolean fileLog = false;
    boolean println = false;
    private final Map fileLogMap = new HashMap();
    private static final TraceFormatter LOG_FILE_FORMATTER = new TraceFormatter("%24d %7s: %m");

    public static SlUtilLogger getLogger(String className, boolean readProperties) {
        if (readProperties) {
            PropertiesConfigurator pC = new PropertiesConfigurator(new File(".\\saplogging.config"));
            pC.configure();
        }
        if (className == null) {
            return new SlUtilLoggerImpl();
        }
        return new SlUtilLoggerImpl(className);
    }

    private SlUtilLoggerImpl() {
        this.loc = Location.getLocation((String)"sl");
        this.cat = Category.getCategory((String)"/SLLogs");
        this.fileLog = true;
    }

    private SlUtilLoggerImpl(String className) {
        String application = null;
        this.loc = Location.getLocation((String)className);
        if (className.indexOf("com.sap.cms.pcs") != -1) {
            application = "/Applications/CMS/PCS";
        }
        if (className.indexOf("com.sap.cms.tcs") != -1) {
            application = "/Applications/CMS/TCS";
        }
        if (className.indexOf("com.sap.sdm") != -1) {
            application = "/Applications/CMS/SDM";
        }
        if (className.indexOf("com.sap.sl.util") != -1) {
            application = "/Applications/SL/UTIL";
        }
        if (application == null) {
            application = "/Applications/SL";
        }
        this.cat = Category.getCategory((String)application);
        this.cale = new GregorianCalendar();
        this.loc.pathT(this.cale.get(11) + ":" + this.cale.get(12) + ":" + this.cale.get(13) + " " + application + " entering class " + className);
    }

    public void startLoggingTo(String logFileName) {
        if (logFileName == null) {
            return;
        }
        if (this.fileLogMap.containsKey(logFileName)) {
            this.loc.addLog((Log)((FileLog)this.fileLogMap.get(logFileName)));
            return;
        }
        FileLog additionalFileLog = new FileLog(logFileName, (Formatter)LOG_FILE_FORMATTER, true);
        this.loc.addLog((Log)additionalFileLog);
        this.fileLogMap.put(logFileName, additionalFileLog);
    }

    public void endLoggingTo(String logFileName) {
        if (logFileName == null) {
            return;
        }
        FileLog additionalFileLog = (FileLog)this.fileLogMap.get(logFileName);
        if (additionalFileLog == null) {
            return;
        }
        this.loc.removeLog((Log)additionalFileLog);
    }

    public void newFile(String file) {
        if (this.fileLog) {
            FileLog fileLog = new FileLog(file);
            fileLog.setFormatter((Formatter)LOG_FILE_FORMATTER);
            this.cat.removeLogs();
            this.cat.addPrivateLog((Log)fileLog);
            this.cat.setEffectiveSeverity(300);
        }
    }

    public Category getCategory() {
        return this.cat;
    }

    public void entering(String method) {
        if (this.loc.getEffectiveSeverity((LogController)this.loc) <= 200) {
            this.cale = new GregorianCalendar();
            this.slutiltrace(TraceLevel.PATH, "", "-> " + this.cale.get(11) + ":" + this.cale.get(12) + ":" + this.cale.get(13) + " -> entering " + method, null);
        }
    }

    public void exiting(String method) {
        this.slutiltrace(TraceLevel.PATH, "", "<--- exiting " + method, null);
    }

    public void exiting(String method, String message) {
        this.slutiltrace(TraceLevel.PATH, "", "<--- exiting " + method + " (" + message + ")", null);
    }

    public void path(String message) {
        this.slutiltrace(TraceLevel.PATH, "", message, null);
    }

    public void path(String user, String message) {
        this.slutiltrace(TraceLevel.PATH, user, message, null);
    }

    public void debug(String message) {
        this.slutiltrace(TraceLevel.DEBUG, "", message, null);
    }

    public void debug(Throwable throwable) {
        this.slutiltrace(TraceLevel.DEBUG, "", "", throwable);
    }

    public void debug(String message, Throwable throwable) {
        this.slutiltrace(TraceLevel.DEBUG, "", message, throwable);
    }

    public void debug(String user, String message) {
        this.slutiltrace(TraceLevel.DEBUG, user, message, null);
    }

    public void debug(String user, String message, Throwable throwable) {
        this.slutiltrace(TraceLevel.DEBUG, user, message, throwable);
    }

    public void trace(TraceLevel traceLevel, String message) {
        this.slutiltrace(traceLevel, "", message, null);
    }

    public void trace(TraceLevel traceLevel, Throwable throwable) {
        this.slutiltrace(traceLevel, "", "", throwable);
    }

    public void trace(TraceLevel traceLevel, String message, Throwable throwable) {
        this.slutiltrace(traceLevel, "", message, throwable);
    }

    public void trace(TraceLevel traceLevel, String user, String message) {
        this.slutiltrace(traceLevel, user, message, null);
    }

    public void trace(TraceLevel traceLevel, String user, String message, Throwable throwable) {
        this.slutiltrace(traceLevel, user, message, throwable);
    }

    public void trace(String message) {
        this.slutiltrace(TraceLevel.DEBUG, "", message, null);
    }

    public void trace(Throwable throwable) {
        this.slutiltrace(TraceLevel.DEBUG, "", "", throwable);
    }

    public void trace(String message, Throwable throwable) {
        this.slutiltrace(TraceLevel.DEBUG, "", message, throwable);
    }

    public void trace(String user, String message) {
        this.slutiltrace(TraceLevel.DEBUG, user, message, null);
    }

    public void trace(String user, String message, Throwable throwable) {
        this.slutiltrace(TraceLevel.DEBUG, user, message, throwable);
    }

    private void slutiltrace(TraceLevel traceLevel, String user, String message, Throwable throwable) {
        if (this.loc.getEffectiveSeverity((LogController)this.loc) <= 200 || this.println) {
            String msg = user.toString().equalsIgnoreCase("") ? message : "User=" + user + " Msg=" + message;
            switch (traceLevel.intValue()) {
                case 1: {
                    if (throwable != null) {
                        msg = msg.toString().equalsIgnoreCase("") ? "Exc=" + throwable.toString() : msg + " Exc=" + throwable.toString();
                    }
                    if (this.println) {
                        System.out.println("SL Path >" + msg);
                    }
                    this.loc.pathT(msg);
                    break;
                }
                case 2: {
                    if (this.loc.getEffectiveSeverity((LogController)this.loc) > 100 && !this.println) break;
                    if (throwable != null) {
                        Exception e = (Exception)throwable;
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        PrintWriter printWriter = new PrintWriter(stream);
                        e.printStackTrace(printWriter);
                        printWriter.flush();
                        String stringException = stream.toString();
                        printWriter.close();
                        msg = msg.toString().equalsIgnoreCase("") ? "Exc=" + stringException : msg + " Exc=" + stringException;
                    }
                    if (this.println) {
                        System.out.println("SL Debug>" + msg);
                    }
                    this.loc.debugT("  " + msg);
                    break;
                }
                default: {
                    if (this.println) {
                        System.out.println("SL Path>" + msg);
                    }
                    this.loc.pathT(msg);
                }
            }
        }
        if (throwable != null) {
            this.cat.logThrowableT(500, this.loc, message, throwable);
        }
    }

    public void info(String message) {
        this.slutilalert(SlUtilSeverity.INFO, "", message, null);
    }

    public void info(Throwable throwable) {
        this.slutilalert(SlUtilSeverity.INFO, "", "", throwable);
    }

    public void info(String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.INFO, "", message, throwable);
    }

    public void info(String user, String message) {
        this.slutilalert(SlUtilSeverity.INFO, user, message, null);
    }

    public void info(String user, String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.INFO, user, message, throwable);
    }

    public void warning(String message) {
        this.slutilalert(SlUtilSeverity.WARNING, "", message, null);
    }

    public void warning(Throwable throwable) {
        this.slutilalert(SlUtilSeverity.WARNING, "", "", throwable);
    }

    public void warning(String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.WARNING, "", message, throwable);
    }

    public void warning(String user, String message) {
        this.slutilalert(SlUtilSeverity.WARNING, user, message, null);
    }

    public void warning(String user, String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.WARNING, user, message, throwable);
    }

    public void error(String message) {
        this.slutilalert(SlUtilSeverity.ERROR, "", message, null);
    }

    public void error(Throwable throwable) {
        this.slutilalert(SlUtilSeverity.ERROR, "", "", throwable);
    }

    public void error(String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.ERROR, "", message, throwable);
    }

    public void error(String user, String message) {
        this.slutilalert(SlUtilSeverity.ERROR, user, message, null);
    }

    public void error(String user, String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.ERROR, user, message, throwable);
    }

    public void fatal(String message) {
        this.slutilalert(SlUtilSeverity.FATAL, "", message, null);
    }

    public void fatal(Throwable throwable) {
        this.slutilalert(SlUtilSeverity.FATAL, "", "", throwable);
    }

    public void fatal(String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.FATAL, "", message, throwable);
    }

    public void fatal(String user, String message) {
        this.slutilalert(SlUtilSeverity.FATAL, user, message, null);
    }

    public void fatal(String user, String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.FATAL, user, message, throwable);
    }

    public void alert(SlUtilSeverity severity, String message) {
        this.slutilalert(severity, "", message, null);
    }

    public void alert(SlUtilSeverity severity, Throwable throwable) {
        this.slutilalert(severity, "", "", throwable);
    }

    public void alert(SlUtilSeverity severity, String message, Throwable throwable) {
        this.slutilalert(severity, "", message, throwable);
    }

    public void alert(SlUtilSeverity severity, String user, String message) {
        this.slutilalert(severity, user, message, null);
    }

    public void alert(SlUtilSeverity severity, String user, String message, Throwable throwable) {
        this.slutilalert(severity, user, message, throwable);
    }

    public void log(String message) {
        this.cat.infoT(this.loc, message);
    }

    public void log(String user, String message) {
        this.cat.infoT(this.loc, "User=" + user + " Msg=" + message);
    }

    public void alert(String message) {
        this.slutilalert(SlUtilSeverity.ERROR, "", message, null);
    }

    public void alert(Throwable throwable) {
        this.slutilalert(SlUtilSeverity.ERROR, "", "", throwable);
    }

    public void alert(String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.ERROR, "", message, throwable);
    }

    public void alert(String user, String message) {
        this.slutilalert(SlUtilSeverity.ERROR, user, message, null);
    }

    public void alert(String user, String message, Throwable throwable) {
        this.slutilalert(SlUtilSeverity.ERROR, user, message, throwable);
    }

    private void slutilalert(SlUtilSeverity severity, String user, String message, Throwable throwable) {
        String msg = user.toString() == "" ? message : "User=" + user + " Msg=" + message;
        if (throwable != null) {
            msg = msg.toString().equalsIgnoreCase("") ? "Exc=" + throwable.toString() : msg + " Exc=" + throwable.toString();
        }
        switch (severity.intValue()) {
            case 1: {
                if (this.println) {
                    System.out.println("SL Fatal>" + msg);
                }
                this.cat.fatalT(this.loc, msg);
                break;
            }
            case 2: {
                if (this.println) {
                    System.out.println("SL Error>" + msg);
                }
                this.cat.errorT(this.loc, msg);
                break;
            }
            case 3: {
                if (this.println) {
                    System.out.println("SL Warning>" + msg);
                }
                this.cat.warningT(this.loc, msg);
                break;
            }
            case 4: {
                if (this.println) {
                    System.out.println("SL Info>" + msg);
                }
                this.cat.infoT(this.loc, msg);
                break;
            }
            default: {
                if (this.println) {
                    System.out.println("SL Error>" + msg);
                }
                this.cat.errorT(this.loc, msg);
            }
        }
        if (throwable != null) {
            this.slutiltrace(TraceLevel.DEBUG, "", "stack trace:", throwable);
        }
    }
}

