/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sl.util.cvers.impl;

import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sl.util.components.api.ComponentFactoryIF;
import com.sap.sl.util.cvers.api.CVersAccessException;
import com.sap.sl.util.cvers.api.CVersFactoryIF;
import com.sap.sl.util.cvers.api.CVersManagerIF;
import com.sap.sl.util.cvers.impl.CVersManager;
import com.sap.sl.util.cvers.impl.CVersTime;
import com.sap.sl.util.cvers.impl.DBConnector;
import com.sap.sl.util.logging.api.SlUtilLogger;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import javax.sql.DataSource;

public class CVersServletManager {
    private static final SlUtilLogger log = SlUtilLogger.getLogger((class$com$sap$sl$util$cvers$impl$CVersDao == null ? (class$com$sap$sl$util$cvers$impl$CVersDao = CVersServletManager.class$("com.sap.sl.util.cvers.impl.CVersDao")) : class$com$sap$sl$util$cvers$impl$CVersDao).getName());
    private Collection compElems = null;
    private ComponentElementIF compElem;
    private CVersManagerIF manager = null;
    private PrintWriter out = null;
    static /* synthetic */ Class class$com$sap$sl$util$cvers$impl$CVersDao;

    private CVersManagerIF getManager(CVersFactoryIF manFactory) throws CVersAccessException {
        this.manager = manFactory.createCVersManager();
        return this.manager;
    }

    public CVersManagerIF getNewManager() throws CVersAccessException {
        return new CVersManager();
    }

    private CVersFactoryIF getCVersFactory() {
        CVersFactoryIF manFactory = CVersFactoryIF.getInstance();
        return manFactory;
    }

    private ComponentFactoryIF getCompFactory() {
        ComponentFactoryIF compFactory = ComponentFactoryIF.getInstance();
        return compFactory;
    }

    public ComponentElementIF[] readCVers() throws CVersAccessException {
        ComponentElementIF[] compElems;
        log.entering("readCVers");
        CVersFactoryIF manFactory = this.getCVersFactory();
        CVersManagerIF manager = this.getManager(manFactory);
        try {
            compElems = manager.readCVers();
        }
        catch (Exception e) {
            log.error("ERROR Manager: readCVers() ", e);
            throw new CVersAccessException("error during DB update " + e.toString());
        }
        log.exiting("readCVers");
        return compElems;
    }

    private void logging(String text) {
        this.out.println(text + "  <br>");
        log.debug(text);
    }

    private ComponentElementIF createCE(int number) {
        ComponentElementIF compElem = ComponentFactoryIF.getInstance().createComponentElement("vendor" + number, "name" + number, "SC", "NO_SUBSYS", "location" + number, "counter" + number, "scVendor" + number, "scName" + number, "R" + number, "SL" + number, "PL" + number, "C", "updateVersion" + number, CVersTime.getTimeStamp("yyyyMMddHHmmss"), "SCTypeID" + number, "SPTypeID" + number, "SPName" + number, "SPVersion" + number, "P4", "perforce300" + number, "123" + number, "//sdt/com.sap.cms/dev/");
        return compElem;
    }

    private void displayContents() throws CVersAccessException {
        ComponentElementIF[] elems = this.manager.readCVers();
        this.out.println("CVERS contains " + elems.length + " entries <br>");
    }

    private void displayComponent(ComponentElementIF element) throws CVersAccessException {
        if (element == null) {
            this.logging("ERROR component name is null, can not be displayed");
            return;
        }
        this.logging("---------------------------------------------");
        this.logging("display vendor ......... " + element.getVendor());
        this.logging("display name ........... " + element.getName());
        this.logging("display componenttype .. " + element.getComponentType());
        this.logging("display subsystem ...... " + element.getSubsystem());
        this.logging("display location ....... " + element.getLocation());
        this.logging("display counter ........ " + element.getCounter());
        this.logging("display scname ......... " + element.getSCName());
        this.logging("display release ........ " + element.getRelease());
        this.logging("display servicelevel ... " + element.getServiceLevel());
        this.logging("display patchlevel ..... " + element.getPatchLevel());
        this.logging("display deltaversion ... " + element.getDeltaVersion());
        this.logging("display updateversion .. " + element.getUpdateVersion());
        this.logging("display scelementypeID . " + element.getSCElementTypeID());
        this.logging("display spelementypeID . " + element.getSPElementTypeID());
        this.logging("display servertype ..... " + element.getServerType());
        this.logging("display servername ..... " + element.getSourceServer());
        this.logging("display changenumber ... " + element.getChangeNumber());
        this.logging("display projectname .... " + element.getProjectName());
    }

    private void checkDeleted(int number) throws CVersAccessException {
        ComponentElementIF element = this.manager.readCVers("vendor" + number, "name" + number, "SC", "NO_SUBSYS");
        if (element == null) {
            this.logging("component name" + number + " was really deleted");
            return;
        }
        this.logging("ERROR component name" + number + " was not deleted");
    }

    private void checkComponent(ComponentElementIF element, int number) throws CVersAccessException {
        this.displayContents();
        if (element == null) {
            this.logging("ERROR component name" + number + " not found in CVERS");
        }
        if (!element.getVendor().equals("vendor" + number)) {
            this.logging("ERROR component name" + number + ": vendor is " + element.getVendor());
        }
        if (!element.getName().equals("name" + number)) {
            this.logging("ERROR component name" + number + ": name is " + element.getName());
        }
        if (!element.getComponentType().equals("SC")) {
            this.logging("ERROR component name" + number + ": type is " + element.getComponentType());
        }
        if (!element.getSubsystem().equals("NO_SUBSYS")) {
            this.logging("ERROR component name" + number + ": subsystem is " + element.getSubsystem());
        }
        if (!element.getLocation().equals("location" + number)) {
            this.logging("ERROR component name" + number + ": location is " + element.getLocation());
        }
        if (!element.getCounter().equals("counter" + number)) {
            this.logging("ERROR component name" + number + ": counter is " + element.getCounter());
        }
        if (!element.getSCName().equals("scName" + number)) {
            this.logging("ERROR component name" + number + ": scname is " + element.getSCName());
        }
        if (!element.getRelease().equals("R" + number)) {
            this.logging("ERROR component name" + number + ": release is " + element.getRelease());
        }
        if (!element.getServiceLevel().equals("SL" + number)) {
            this.logging("ERROR component name" + number + ": servicelevel is " + element.getServiceLevel());
        }
        if (!element.getPatchLevel().equals("PL" + number)) {
            this.logging("ERROR component name" + number + ": patchlevel is " + element.getPatchLevel());
        }
        if (!element.getDeltaVersion().equals("C")) {
            this.logging("ERROR component name" + number + ": deltaversion is " + element.getDeltaVersion());
        }
        if (!element.getUpdateVersion().equals("updateVersion" + number)) {
            this.logging("ERROR component name" + number + ": updateversion is " + element.getUpdateVersion());
        }
        if (!element.getSCElementTypeID().equals("SCTypeID" + number)) {
            this.logging("ERROR component name" + number + ": scelementypeID is " + element.getSCElementTypeID());
        }
        if (!element.getSPElementTypeID().equals("SPTypeID" + number)) {
            this.logging("ERROR component name" + number + ": spelementypeID is " + element.getSPElementTypeID());
        }
        if (!element.getServerType().equals("P4")) {
            this.logging("ERROR component name" + number + ": servertype is " + element.getServerType());
        }
        if (!element.getSourceServer().equals("perforce300" + number)) {
            this.logging("ERROR component name" + number + ": servername is " + element.getSourceServer());
        }
        if (!element.getChangeNumber().equals("123" + number)) {
            this.logging("ERROR component name" + number + ": changenumber is " + element.getChangeNumber());
        }
        if (!element.getProjectName().equals("//sdt/com.sap.cms/dev/")) {
            this.logging("ERROR component name" + number + ": projectname is " + element.getProjectName());
        }
        this.logging("checkComponent finished");
    }

    private void checkComponent(int number) throws CVersAccessException {
        ComponentElementIF element = this.manager.readCVers("vendor" + number, "name" + number, "SC", "NO_SUBSYS");
        this.checkComponent(element, number);
    }

    public void testnew(PrintWriter print) throws CVersAccessException {
        DataSource dataSource;
        this.out = print;
        DBConnector dbConnector = new DBConnector();
        try {
            this.logging("try to get dataSource...");
            dataSource = dbConnector.getDataSource();
        }
        catch (Exception e) {
            log.error("get dataSource failed: ", e);
            throw new CVersAccessException("Get dataSource failed: " + e.toString());
        }
        this.manager = CVersFactoryIF.getInstance().createCVersManager();
        try {
            this.displayContents();
            this.logging("delete entries from last test...");
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                PreparedStatement deleteStatement = connection.prepareStatement("DELETE FROM BC_COMPVERS WHERE VENDOR LIKE 'vendor%' AND NAME LIKE 'name%'");
                deleteStatement.execute();
            }
            catch (Exception e) {
                log.error("error during inital delete ", e);
                throw new CVersAccessException("error during initial delete " + e.toString());
            }
            ComponentElementIF comp1 = this.createCE(1);
            ComponentElementIF comp2 = this.createCE(2);
            ComponentElementIF comp3 = this.createCE(3);
            ComponentElementIF comp4 = this.createCE(4);
            ComponentElementIF[] complist = new ComponentElementIF[1];
            this.displayContents();
            complist[0] = comp1;
            this.logging("insert comp1 into database ...");
            this.manager.writeCVers(complist);
            this.checkComponent(1);
            ComponentElementIF[] complist1 = new ComponentElementIF[]{comp2, comp3, comp4};
            this.logging("insert comp2/3/4 into database ...");
            this.manager.writeCVers(complist1);
            this.checkComponent(1);
            this.checkComponent(2);
            this.checkComponent(3);
            this.checkComponent(4);
            this.logging("update comp1 in database ...");
            this.manager.writeCVers(complist);
            this.checkComponent(1);
            this.manager.writeCVers(complist1);
            this.checkComponent(1);
            this.checkComponent(2);
            this.checkComponent(3);
            this.checkComponent(4);
            this.logging("find all ...");
            ComponentElementIF[] elems = this.manager.readCVers();
            this.logging(elems.length + " components found");
            this.logging("find all SCs ...");
            elems = this.manager.readCVers("SC");
            this.logging(elems.length + " SCs found");
            this.logging("find all DCs ...");
            elems = this.manager.readCVers("DC");
            this.logging(elems.length + " DCs found");
            this.logging("find by component type and subsystem...");
            elems = this.manager.readCVers("SC", "NO_SUBSYS");
            this.logging(elems.length + " SCs by subsystem found");
            elems = this.manager.readCVers("DC", "NO_SUBSYS");
            this.logging(elems.length + " DCs by subsystem found");
            int i = 1;
            while (i < 5) {
                this.logging("find comp" + i + " ...");
                ComponentElementIF element = this.manager.readCVers("vendor" + i, "name" + i, "SC", "NO_SUBSYS");
                this.checkComponent(element, i);
                ++i;
            }
            this.logging("read with wrong key...");
            try {
                this.manager.readCVers("wrongvendor", "wrongname", "SC", "NO_SUBSYS");
                this.logging("ERROR wrong key was found");
            }
            catch (Exception e) {
                this.logging("wrong key was really not found");
            }
            this.logging("read with wrong type...");
            try {
                this.manager.readCVers("vendor1", "name1", "wrongtype", "NO_SUBSYS");
                this.logging("ERROR wrong type was found");
            }
            catch (Exception e) {
                this.logging("wrong type was really not found");
            }
            this.logging("read with wrong key...");
            try {
                this.manager.readCVers("wrongtype");
                this.logging("ERROR wrong key was found");
            }
            catch (Exception e) {
                this.logging("wrong key really not found");
            }
            this.logging("delete comp1");
            this.manager.removeCVers(complist);
            this.checkDeleted(1);
            this.logging("delete comp2,3,4");
            this.manager.removeCVers(complist1);
            this.checkDeleted(2);
            this.checkDeleted(3);
            this.checkDeleted(4);
            this.logging("CVERS test finished");
        }
        catch (Exception exc) {
            this.out.println("ERROR unexpected " + exc.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

