/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sl.util.components.xml.impl;

import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sl.util.components.api.ComponentFactoryIF;
import com.sap.sl.util.components.xml.api.ComponentElementXMLizerException;
import com.sap.sl.util.components.xml.api.ComponentElementXMLizerIF;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentElementXMLizer
extends DefaultHandler
implements ComponentElementXMLizerIF {
    private ComponentElementIF component;
    private String COMPONENTELEMENTTAG = "componentelement";

    public ComponentElementXMLizer(ComponentElementIF component) {
        this.component = component;
    }

    public void fromXML(String xmlelement) throws ComponentElementXMLizerException {
        this.readFromXML(xmlelement);
    }

    public ComponentElementIF getComponentElement() {
        return this.component;
    }

    public String getXML() {
        String xmlelement = "<" + this.COMPONENTELEMENTTAG + " ";
        if (this.component.getName() != null) {
            xmlelement = xmlelement + " name=\"" + this.component.getName() + "\"";
        }
        if (this.component.getVendor() != null) {
            xmlelement = xmlelement + " vendor=\"" + this.component.getVendor() + "\"";
        }
        if (this.component.getComponentType() != null) {
            xmlelement = xmlelement + " componenttype=\"" + this.component.getComponentType() + "\"";
        }
        if (this.component.getSubsystem() != null) {
            xmlelement = xmlelement + " subsystem=\"" + this.component.getSubsystem() + "\"";
        }
        if (this.component.getLocation() != null) {
            xmlelement = xmlelement + " location=\"" + this.component.getLocation() + "\"";
        }
        if (this.component.getCounter() != null) {
            xmlelement = xmlelement + " counter=\"" + this.component.getCounter() + "\"";
        }
        if (this.component.getSCVendor() != null) {
            xmlelement = xmlelement + " scvendor=\"" + this.component.getSCVendor() + "\"";
        }
        if (this.component.getSCName() != null) {
            xmlelement = xmlelement + " scname=\"" + this.component.getSCName() + "\"";
        }
        if (this.component.getRelease() != null) {
            xmlelement = xmlelement + " release=\"" + this.component.getRelease() + "\"";
        }
        if (this.component.getServiceLevel() != null) {
            xmlelement = xmlelement + " servicelevel=\"" + this.component.getServiceLevel() + "\"";
        }
        if (this.component.getPatchLevel() != null) {
            xmlelement = xmlelement + " patchlevel=\"" + this.component.getPatchLevel() + "\"";
        }
        if (this.component.getDeltaVersion() != null) {
            xmlelement = xmlelement + " deltaversion=\"" + this.component.getDeltaVersion() + "\"";
        }
        if (this.component.getUpdateVersion() != null) {
            xmlelement = xmlelement + " updateversion=\"" + this.component.getUpdateVersion() + "\"";
        }
        if (this.component.getApplyTime() != null) {
            xmlelement = xmlelement + " applytime=\"" + this.component.getApplyTime() + "\"";
        }
        if (this.component.getSCElementTypeID() != null) {
            xmlelement = xmlelement + " scelementtypeid=\"" + this.component.getSCElementTypeID() + "\"";
        }
        if (this.component.getSPElementTypeID() != null) {
            xmlelement = xmlelement + " spelementtypeid=\"" + this.component.getSPElementTypeID() + "\"";
        }
        if (this.component.getSPName() != null) {
            xmlelement = xmlelement + " spname=\"" + this.component.getSPName() + "\"";
        }
        if (this.component.getSPVersion() != null) {
            xmlelement = xmlelement + " spversion=\"" + this.component.getSPVersion() + "\"";
        }
        if (this.component.getServerType() != null) {
            xmlelement = xmlelement + " servertype=\"" + this.component.getServerType() + "\"";
        }
        if (this.component.getSourceServer() != null) {
            xmlelement = xmlelement + " sourceserver=\"" + this.component.getSourceServer() + "\"";
        }
        if (this.component.getChangeNumber() != null) {
            xmlelement = xmlelement + " changenumber=\"" + this.component.getChangeNumber() + "\"";
        }
        if (this.component.getProjectName() != null) {
            xmlelement = xmlelement + " projectname=\"" + this.component.getProjectName() + "\"";
        }
        xmlelement = xmlelement + "/> ";
        return xmlelement;
    }

    private void readFromXML(String xmlelement) throws ComponentElementXMLizerException {
        try {
            ComponentElementXMLizer defhand = new ComponentElementXMLizer(this.component);
            SAXParserFactory parserfactory = SAXParserFactory.newInstance();
            parserfactory.setValidating(false);
            SAXParser parser = parserfactory.newSAXParser();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlelement.getBytes());
            parser.parse((InputStream)bais, (DefaultHandler)defhand);
            this.component = defhand.getComponentElement();
        }
        catch (ParserConfigurationException e) {
            throw new ComponentElementXMLizerException("ParserConfigurationException" + e.getMessage());
        }
        catch (SAXException e) {
            throw new ComponentElementXMLizerException("SAXException" + e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new ComponentElementXMLizerException("FactoryConfigurationError" + e.getMessage());
        }
        catch (IOException e) {
            throw new ComponentElementXMLizerException("IOException" + e.getMessage());
        }
    }

    public void startElement(String ns, String localname, String qname, Attributes attributes) throws SAXException {
        String _name;
        String vendor = null;
        String name = null;
        String componenttype = null;
        String subsystem = null;
        String location = null;
        String counter = null;
        String scvendor = null;
        String scname = null;
        String release = null;
        String servicelevel = null;
        String patchlevel = null;
        String deltaversion = null;
        String updateversion = null;
        String applytime = null;
        String scelementtypeid = null;
        String spelementtypeid = null;
        String spname = null;
        String spversion = null;
        String servertype = null;
        String sourceserver = null;
        String changenumber = null;
        String projectname = null;
        String string = _name = "".equals(localname) ? qname : localname;
        if (this.COMPONENTELEMENTTAG.equals(_name)) {
            int ind = attributes.getIndex("name");
            if (ind != -1) {
                name = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("vendor")) != -1) {
                vendor = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("componenttype")) != -1) {
                componenttype = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("subsystem")) != -1) {
                subsystem = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("location")) != -1) {
                location = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("counter")) != -1) {
                counter = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("scvendor")) != -1) {
                scvendor = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("scname")) != -1) {
                scname = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("release")) != -1) {
                release = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("servicelevel")) != -1) {
                servicelevel = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("patchlevel")) != -1) {
                patchlevel = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("deltaversion")) != -1) {
                deltaversion = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("updateversion")) != -1) {
                updateversion = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("applytime")) != -1) {
                applytime = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("scelementtypeid")) != -1) {
                scelementtypeid = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("spelementtypeid")) != -1) {
                spelementtypeid = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("spname")) != -1) {
                spname = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("spversion")) != -1) {
                spversion = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("servertype")) != -1) {
                servertype = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("sourceserver")) != -1) {
                sourceserver = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("changenumber")) != -1) {
                changenumber = attributes.getValue(ind);
            }
            if ((ind = attributes.getIndex("projectname")) != -1) {
                projectname = attributes.getValue(ind);
            }
        } else {
            throw new SAXException("wrong xmlelement");
        }
        this.component = ComponentFactoryIF.getInstance().createComponentElement(vendor, name, componenttype, subsystem, location, counter, scvendor, scname, release, servicelevel, patchlevel, deltaversion, updateversion, applytime, scelementtypeid, spelementtypeid, spname, spversion, servertype, sourceserver, changenumber, projectname);
    }
}

