/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.eclipse;

import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JomRequestUtil {
    private static final IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
    private static Set searchPathClassDirs = new HashSet();
    private static Set searchPathJars = new HashSet();
    private static Set searchPathSrcDirs = new HashSet();
    private static Set allProjects = new HashSet();

    private JomRequestUtil() {
    }

    public static ParameterInterface[] getClassPathParams(IJavaProject project) {
        JomRequestUtil.reset();
        ParameterInterface[] params = new ParameterInterface[3];
        try {
            JomRequestUtil.addToSearchPath(project, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        params[0] = ParameterTool.createParameter((String)"Java libraries", (String)"STRING[]", (Object)searchPathJars.toArray(new String[searchPathJars.size()]));
        params[1] = ParameterTool.createParameter((String)"Source folders", (String)"STRING[]", (Object)searchPathSrcDirs.toArray(new String[searchPathSrcDirs.size()]));
        params[2] = ParameterTool.createParameter((String)"Class folders", (String)"STRING[]", (Object)searchPathClassDirs.toArray(new String[searchPathClassDirs.size()]));
        return params;
    }

    private static void addToSearchPath(IJavaProject project, boolean isDepProject) throws JavaModelException {
        IPath absoluteOutputDir;
        IResource binOutputDir;
        allProjects.add(project.getElementName());
        String[] dependendProjs = project.getRequiredProjectNames();
        if (dependendProjs != null) {
            int i = 0;
            while (i < dependendProjs.length) {
                if (!allProjects.contains(dependendProjs[i])) {
                    JomRequestUtil.addToSearchPath(JavaCore.create((IWorkspaceRoot)wsRoot).getJavaProject(dependendProjs[i]), true);
                }
                ++i;
            }
        }
        if ((binOutputDir = wsRoot.findMember(project.getOutputLocation())) != null && (absoluteOutputDir = binOutputDir.getLocation()) != null) {
            searchPathClassDirs.add(absoluteOutputDir.toString());
        }
        IClasspathEntry[] cpEntries = project.getResolvedClasspath(true);
        int i = 0;
        while (i < cpEntries.length) {
            switch (cpEntries[i].getEntryKind()) {
                case 3: {
                    if (isDepProject) break;
                    JomRequestUtil.addSourceDir(project, cpEntries[i]);
                    break;
                }
                case 1: {
                    JomRequestUtil.addLibrary(project, cpEntries[i]);
                }
            }
            ++i;
        }
    }

    private static void addSourceDir(IJavaProject project, IClasspathEntry entry) throws JavaModelException {
        IResource cpEntryResource = wsRoot.findMember(entry.getPath());
        if (cpEntryResource == null) {
            return;
        }
        IPath absolutePath = cpEntryResource.getLocation();
        if (absolutePath == null) {
            return;
        }
        if (!new File(absolutePath.toString()).exists()) {
            throw new JavaModelException((Throwable)new FileNotFoundException("file " + absolutePath.toString() + " doesn't exist!"), 4);
        }
        searchPathSrcDirs.add(absolutePath.toString());
    }

    private static void addLibrary(IJavaProject project, IClasspathEntry entry) throws JavaModelException {
        IResource cpEntryResource = wsRoot.findMember(entry.getPath());
        boolean isClassesDir = false;
        String absPath = null;
        if (cpEntryResource == null) {
            absPath = entry.getPath().toString();
        } else {
            switch (cpEntryResource.getType()) {
                case 1: {
                    isClassesDir = false;
                    break;
                }
                case 2: 
                case 4: {
                    isClassesDir = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown library type: " + cpEntryResource.getType());
                }
            }
            IPath absolutePath = cpEntryResource.getLocation();
            if (absolutePath != null) {
                absPath = absolutePath.toString();
            }
        }
        if (absPath != null) {
            if (new File(absPath).exists()) {
                if (isClassesDir) {
                    searchPathClassDirs.add(absPath);
                } else {
                    searchPathJars.add(absPath);
                }
            } else {
                throw new JavaModelException((Throwable)new Exception("file " + absPath + " doesn't exist!"), 4);
            }
        }
    }

    private static void reset() {
        allProjects.clear();
        searchPathClassDirs.clear();
        searchPathJars.clear();
        searchPathSrcDirs.clear();
    }
}

