/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.eclipse;

import com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.metadata.IMetaData;
import com.sap.tc.jtools.jlint.jom.eclipse.JomRequest;
import com.sap.tc.jtools.jtci.PerformUnit;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class JomRequestCreator
implements IRequestCreator {
    protected List data = new ArrayList();
    protected List metaData = new ArrayList();
    protected Map testObjectID2JomRequest = new HashMap();

    public EclipseRequest[] createRequests(Test[] tests) {
        if (this.data.size() == 0) {
            return EclipseRequest.EMPTY_REQUEST_ARRAY;
        }
        Collection sortedJavaEls = this.getSortedJavaElements(this.data);
        ArrayList<JomRequest> requestList = new ArrayList<JomRequest>(sortedJavaEls.size());
        Iterator iter = sortedJavaEls.iterator();
        while (iter.hasNext()) {
            List jElList = (List)iter.next();
            requestList.add(new JomRequest("JOM eclipse request", tests, jElList.toArray(new IJavaElement[0])));
        }
        EclipseRequest[] requests = requestList.toArray(new JomRequest[0]);
        int i = 0;
        while (i < requests.length) {
            PerformUnit[] performUnits = requests[i].getPerformUnits();
            int j = 0;
            while (j < performUnits.length) {
                TestObject[] testObjects = performUnits[j].getSources();
                int k = 0;
                while (k < testObjects.length) {
                    this.testObjectID2JomRequest.put(testObjects[k].getID(), requests[i]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return requests;
    }

    protected Collection getSortedJavaElements(List selectedEls) {
        HashMap<IJavaProject, ArrayList<IJavaElement>> projectMap = new HashMap<IJavaProject, ArrayList<IJavaElement>>();
        Iterator iter = selectedEls.iterator();
        while (iter.hasNext()) {
            Object selectedEl = iter.next();
            IJavaElement javaEl = null;
            IJavaProject proj = null;
            if (selectedEl instanceof IJavaElement) {
                javaEl = (IJavaElement)selectedEl;
            } else if (selectedEl instanceof IResource) {
                javaEl = JavaCore.create((IResource)((IResource)selectedEl));
            }
            if (javaEl == null || !javaEl.exists() || (proj = javaEl.getJavaProject()) == null) continue;
            ArrayList<IJavaElement> elementList = (ArrayList<IJavaElement>)projectMap.get(proj);
            if (elementList == null) {
                elementList = new ArrayList<IJavaElement>();
                projectMap.put(proj, elementList);
            }
            elementList.add(javaEl);
        }
        return projectMap.values();
    }

    public IResource[] getResources() {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        Iterator iter = this.data.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            IResource res = null;
            if (obj instanceof IJavaElement) {
                res = ((IJavaElement)obj).getResource();
            } else if (obj instanceof IResource) {
                res = (IResource)obj;
            }
            if (res == null) continue;
            resources.add(res);
        }
        return resources.toArray(new IResource[0]);
    }

    public void addData(Object[] data) {
        this.data.addAll(Arrays.asList(data));
    }

    public void addMetaData(IMetaData[] metaData) {
        this.metaData.addAll(Arrays.asList(metaData));
    }

    public void reset() {
        this.metaData.clear();
        this.data.clear();
    }

    public Object getData(String testObjectID, TestObjectPosition testObjectPosition) {
        JomRequest request = (JomRequest)((Object)this.testObjectID2JomRequest.get(testObjectID));
        if (request == null) {
            return null;
        }
        return request.getData(testObjectID, testObjectPosition);
    }
}

