/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.eclipse;

import com.sap.tc.jtools.jlint.eclipse.launch.EclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jlint.jom.eclipse.JomRequestUtil;
import com.sap.tc.jtools.jtci.FilePosition;
import com.sap.tc.jtools.jtci.PerformUnit;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestObjectSpecification;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JomRequest
extends EclipseRequest {
    private static final int MAX_TESTOBJECT_SIZE = 200;
    private IJavaElement[] javaElements;
    private Map fileName2JavaElement = new HashMap();
    private Map baseDir2FileListMap = new HashMap();
    protected IJavaProject javaProject;
    protected List relativeFileNames;

    public JomRequest(String name, Test[] tests, IJavaElement[] jElements) {
        super(name, tests);
        IJavaProject javaProject = jElements[0].getJavaProject();
        int i = 0;
        while (i < jElements.length) {
            if (!jElements[i].getJavaProject().equals(javaProject)) {
                throw new IllegalArgumentException("all java elements must belong to the same project");
            }
            ++i;
        }
        this.javaProject = javaProject;
        this.javaElements = jElements;
        this.setSearchPathParameters();
        this.addSources();
    }

    private void addSources() {
        int i = 0;
        while (i < this.javaElements.length) {
            try {
                switch (this.javaElements[i].getElementType()) {
                    case 2: {
                        this.traverseSources((IJavaProject)this.javaElements[i]);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.traverseSources(this.javaElements[i]);
                        break;
                    }
                    case 7: {
                        this.traverseSources((IJavaElement)((IType)this.javaElements[i]).getCompilationUnit());
                    }
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            ++i;
        }
        Set entries = this.baseDir2FileListMap.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String baseDir = (String)entry.getKey();
            String[] files = ((List)entry.getValue()).toArray(new String[0]);
            int position = 0;
            while (position < files.length) {
                int length = position + 200 > files.length ? files.length - position : 200;
                String[] filesChunk = new String[length];
                System.arraycopy(files, position, filesChunk, 0, length);
                try {
                    this.addSource((TestObject)new JavaFileArrayTestObject(baseDir, filesChunk));
                }
                catch (InvalidTestObjectSpecification e) {
                    ExceptionHandler.handle((Throwable)e);
                    return;
                }
                position += 200;
            }
        }
    }

    private void setSearchPathParameters() {
        ParameterInterface[] params = JomRequestUtil.getClassPathParams(this.javaProject);
        int i = 0;
        while (i < params.length) {
            this.addParameter(params[i]);
            ++i;
        }
    }

    private void traverseSources(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] pkgFrgRoots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < pkgFrgRoots.length) {
            this.traverseSources((IJavaElement)pkgFrgRoots[i]);
            ++i;
        }
    }

    private void traverseSources(IJavaElement el) throws JavaModelException {
        ICompilationUnit cu;
        if (el == null) {
            return;
        }
        if (el.getElementType() == 3) {
            if (((IPackageFragmentRoot)el).isArchive() || ((IPackageFragmentRoot)el).getKind() != 1) {
                return;
            }
        } else if (el.getElementType() == 4) {
            if (((IPackageFragment)el).getKind() != 1) {
                return;
            }
        } else if (el.getElementType() == 5 && (cu = (ICompilationUnit)el).isWorkingCopy()) {
            el = cu.getOriginalElement();
        }
        String baseDir = el.getAncestor(3).getResource().getLocation().toString();
        String[] sources = this.getAllRelativeFileNames(el);
        if (sources == null || sources.length == 0) {
            return;
        }
        int i = 0;
        while (i < sources.length) {
            this.fileName2JavaElement.put(sources[i], el);
            ++i;
        }
        ArrayList<String> fileList = (ArrayList<String>)this.baseDir2FileListMap.get(baseDir);
        if (fileList == null) {
            fileList = new ArrayList<String>(sources.length);
            this.baseDir2FileListMap.put(baseDir, fileList);
        }
        fileList.addAll(Arrays.asList(sources));
    }

    private String[] getAllRelativeFileNames(IJavaElement el) {
        this.relativeFileNames = new ArrayList();
        this.doElement(el);
        return this.relativeFileNames.toArray(new String[this.relativeFileNames.size()]);
    }

    protected void doElement(IJavaElement el) {
        if (el instanceof ICompilationUnit) {
            ICompilationUnit cUnit = (ICompilationUnit)el;
            int baseDirSegments = 0;
            try {
                baseDirSegments = cUnit.getAncestor(3).getCorrespondingResource().getLocation().segmentCount();
                this.relativeFileNames.add(el.getCorrespondingResource().getLocation().removeFirstSegments(baseDirSegments).setDevice(null).toString());
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return;
        }
        if (el instanceof IParent) {
            IJavaElement[] children = null;
            try {
                children = ((IParent)el).getChildren();
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (null == children) {
                return;
            }
            int i = 0;
            while (i < children.length) {
                this.doElement(children[i]);
                ++i;
            }
        }
    }

    public int testObjectCount() {
        int noOfSrc = 0;
        PerformUnit[] units = this.getPerformUnits();
        int i = 0;
        while (i < units.length) {
            TestObject[] testObjs = units[i].getSources();
            int j = 0;
            while (j < testObjs.length) {
                noOfSrc += testObjs[j].getComponentCount();
                ++j;
            }
            ++i;
        }
        return noOfSrc;
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }

    public Object getData(String testObjectID, TestObjectPosition testObjectPosition) {
        if (!(testObjectPosition instanceof FilePosition)) {
            return null;
        }
        return this.fileName2JavaElement.get(((FilePosition)testObjectPosition).getFile());
    }
}

