/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.eclipse;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.extension.IMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.extension.IMarkerPosition;
import com.sap.tc.jtools.jlint.eclipse.launch.MarkerPosition;
import com.sap.tc.jtools.jtci.FilePosition;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JomMarkerManager
implements IMarkerManager {
    private IJavaProject lastProject;

    public IMarkerPosition getMarkerPosition(TestObjectPosition position, IProject correspondingProject) {
        if (position == null) {
            return new MarkerPosition((IResource)correspondingProject, -1, -1);
        }
        if (!(position instanceof FilePosition)) {
            return null;
        }
        FilePosition fp = (FilePosition)position;
        int line = fp.getLine();
        int col = fp.getColumn();
        IJavaProject jProj = JavaCore.create((IProject)correspondingProject);
        IJavaElement el = null;
        IResource res = null;
        try {
            el = jProj.findElement((IPath)new Path(fp.getFile()));
            if (el != null) {
                res = el.getCorrespondingResource();
            }
        }
        catch (JavaModelException jme) {
            JlinPlugin.log((Throwable)jme);
        }
        if (res == null) {
            res = this.findResource(fp);
        }
        if (res == null) {
            return null;
        }
        return new MarkerPosition(res, line, col);
    }

    private IResource findResource(FilePosition fp) {
        IResource res = null;
        Path pathToFind = new Path(fp.getFile());
        IJavaElement jEl = null;
        try {
            if (this.lastProject != null && (jEl = this.lastProject.findElement((IPath)pathToFind)) != null) {
                return jEl.getCorrespondingResource();
            }
        }
        catch (JavaModelException jme) {
            // empty catch block
        }
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < allProjects.length) {
            IJavaProject jProj = JavaCore.create((IProject)allProjects[i]);
            try {
                jEl = jProj.findElement((IPath)new Path(fp.getFile()));
                if (jEl != null && (res = jEl.getCorrespondingResource()) != null) {
                    this.lastProject = jProj;
                    return res;
                }
            }
            catch (JavaModelException jme) {
                JlinPlugin.log((Throwable)jme);
            }
            ++i;
        }
        return res;
    }
}

