/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import java.util.StringTokenizer;

public final class Version
implements Comparable {
    private static final int INITIAL_HASHCODE = -1;
    public static final Version ZERO = new Version(0, 0, 0);
    public final int major;
    public final int minor;
    public final int patch;
    private final boolean minorUnassigned;
    private final boolean patchUnassigned;
    private String toString;
    private int hashCode = -1;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.patchUnassigned = false;
        this.minorUnassigned = false;
    }

    public Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.patch = 0;
        this.minorUnassigned = false;
        this.patchUnassigned = true;
    }

    public Version(String version, Version defaultVersion) {
        int[] parts = new int[]{0, 0, 0};
        boolean useDefaultVersion = false;
        int tokenCount = 0;
        if (version != null) {
            StringTokenizer tokenizer = new StringTokenizer(version, ".");
            tokenCount = tokenizer.countTokens();
            if (0 < tokenCount && tokenCount < 4) {
                try {
                    int i = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        parts[i++] = Integer.parseInt(token);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (defaultVersion == null) {
                        throw nfe;
                    }
                    useDefaultVersion = true;
                }
            } else {
                if (defaultVersion == null) {
                    throw new NumberFormatException("Illegal version format: " + version);
                }
                useDefaultVersion = true;
            }
        } else {
            if (defaultVersion == null) {
                throw new NullPointerException("Version string and default version are null.");
            }
            useDefaultVersion = true;
        }
        if (useDefaultVersion) {
            this.major = defaultVersion.major;
            this.minor = defaultVersion.minor;
            this.patch = defaultVersion.patch;
            this.minorUnassigned = defaultVersion.minorUnassigned;
            this.patchUnassigned = defaultVersion.patchUnassigned;
        } else {
            this.major = parts[0];
            this.minor = parts[1];
            this.patch = parts[2];
            this.minorUnassigned = tokenCount < 2;
            this.patchUnassigned = tokenCount < 3;
        }
    }

    public int compareTo(Object obj) {
        Version other = (Version)obj;
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        return 0;
    }

    public boolean isLowerThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLowerOrEqualTo(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isHigherThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isHigherOrEqualTo(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
        }
        return false;
    }

    public boolean equals(int major, int minor, int patch) {
        return major == this.major && minor == this.minor && patch == this.patch;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = 31000000 * this.major + 3100 * this.minor + this.patch;
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = Integer.toString(this.major);
            if (!this.minorUnassigned) {
                this.toString = this.toString + "." + this.minor;
                if (!this.patchUnassigned) {
                    this.toString = this.toString + "." + this.patch;
                }
            }
        }
        return this.toString;
    }
}

