/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.util.Util;

public class SystemExplorer {
    public static final String PROPNAME_SAPSYSTEMNAME = "SAPSYSTEMNAME";
    public static final String PROPNAME_DBHOSTNAME = "j2ee.dbhost";
    public static final String SEPNAME_DBHOSTNAME = ".SystemHome.";

    public static String getJ2EEClusterEngineName() throws LcrException {
        String result;
        String sid = null;
        String dbhost = null;
        try {
            sid = System.getProperty(PROPNAME_SAPSYSTEMNAME);
            dbhost = System.getProperty(PROPNAME_DBHOSTNAME);
            result = sid + SEPNAME_DBHOSTNAME + Util.normalizeHostname(dbhost);
        }
        catch (RuntimeException rte) {
            throw new LcrException(rte);
        }
        if (sid == null) {
            throw new LcrException("Missing system property SAPSYSTEMNAME");
        }
        if (dbhost == null) {
            throw new LcrException("Missing system property j2ee.dbhost");
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            String jsysname = SystemExplorer.getJ2EEClusterEngineName();
            System.out.println("J2EE system name = " + jsysname);
        }
        catch (LcrException lce) {
            lce.printStackTrace();
        }
    }
}

