/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import java.util.ArrayList;
import java.util.List;

public class PatchRuleParser {
    public static final String EQUAL_OPERATOR = "EQ";
    public static final String NOT_EQUAL_OPERATOR = "NE";
    public static final String BETWEEN_OPERATOR = "BT";
    public static final String NOT_BETWEEN_OPERATOR = "NB";
    public static final String GREATER_THAN_OPERATOR = "GT";
    public static final String GREATER_EQUAL_OPERATOR = "GE";
    public static final String LOWER_THAN_OPERATOR = "LT";
    public static final String LOWER_EQUAL_OPERATOR = "LE";
    public static final String CONTAINS_PATTERN_OPERATOR = "CP";
    public static final String NO_PATTERN_OPERATOR = "NP";
    private static final char ESCAPECHAR = '\\';
    private static final char DELIMITER = ',';
    private static final char DELIMITER2 = ';';
    private static final char SQBRACKOPEN = '[';
    private static final char SQBRACKCLOSE = ']';
    private static final char CUBRACKOPEN = '{';
    private static final char CUBRACKCLOSE = '}';
    private static final String SQBRACKOPENSTRING = new Character('[').toString();
    private static final String CUBRACKOPENSTRING = new Character('{').toString();
    private static final String CUBRACKCLOSESTRING = new Character('}').toString();
    private static final String DEPENDENT_ROLE = "Dependent";
    private static final String ANTECEDENT_ROLE = "Antecedent";
    private String lastPatchRule = null;
    private List lastSelOptList = new ArrayList();

    public synchronized String writePatchRule(List selOptList) {
        String result;
        if (selOptList == null || selOptList.size() == 0) {
            return null;
        }
        StringBuffer resultBuffer = new StringBuffer(1024);
        this.lastSelOptList.clear();
        int i = 0;
        while (i < selOptList.size()) {
            String[] nextSelOpt = (String[])selOptList.get(i);
            if (nextSelOpt != null && nextSelOpt.length == 8) {
                if (nextSelOpt[0] != null) {
                    resultBuffer.append(nextSelOpt[0]);
                    resultBuffer.append('{');
                    resultBuffer.append(nextSelOpt[1]);
                    resultBuffer.append('[');
                    resultBuffer.append(this.getMaskedValue(nextSelOpt[2]));
                    if (nextSelOpt[3] != null) {
                        resultBuffer.append(',');
                        resultBuffer.append(this.getMaskedValue(nextSelOpt[3]));
                    }
                    resultBuffer.append(']');
                    resultBuffer.append('}');
                }
                if (nextSelOpt[4] != null) {
                    resultBuffer.append(nextSelOpt[4]);
                    resultBuffer.append('{');
                    resultBuffer.append(nextSelOpt[5]);
                    resultBuffer.append('[');
                    resultBuffer.append(this.getMaskedValue(nextSelOpt[6]));
                    if (nextSelOpt[7] != null) {
                        resultBuffer.append(',');
                        resultBuffer.append(this.getMaskedValue(nextSelOpt[7]));
                    }
                    resultBuffer.append(']');
                    resultBuffer.append('}');
                }
                resultBuffer.append(';');
                String[] selOptCopy = new String[nextSelOpt.length];
                System.arraycopy(nextSelOpt, 0, selOptCopy, 0, nextSelOpt.length);
                this.lastSelOptList.add(selOptCopy);
            }
            ++i;
        }
        this.lastPatchRule = result = resultBuffer.toString();
        return result;
    }

    public synchronized List parsePatchRule(String patchRule) {
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        String[] nextSelOptPair = new String[8];
        int pairIndex = 0;
        int remIndex = 0;
        while (remIndex < patchRule.length()) {
            if (patchRule.charAt(remIndex) == ';') {
                resultList.add(nextSelOptPair);
                nextSelOptPair = new String[8];
                pairIndex = 0;
                ++remIndex;
                continue;
            }
            int isel = patchRule.indexOf(CUBRACKOPENSTRING, remIndex);
            if (isel < remIndex) break;
            nextSelOptPair[pairIndex] = patchRule.substring(remIndex, isel);
            int intervalStart = patchRule.indexOf(SQBRACKOPENSTRING, isel + 1);
            if (intervalStart < 0) break;
            nextSelOptPair[pairIndex + 1] = patchRule.substring(isel + 1, intervalStart);
            ValueAndEndIndex lowerVAEI = this.getUnmaskedValue(patchRule, intervalStart + 1);
            nextSelOptPair[pairIndex + 2] = lowerVAEI.value;
            if (patchRule.charAt(lowerVAEI.endIndex) == ',') {
                ValueAndEndIndex upperVAEI = this.getUnmaskedValue(patchRule, lowerVAEI.endIndex + 1);
                nextSelOptPair[pairIndex + 3] = upperVAEI.value;
                remIndex = patchRule.indexOf(CUBRACKCLOSESTRING, upperVAEI.endIndex) + 1;
            } else {
                remIndex = patchRule.indexOf(CUBRACKCLOSESTRING, lowerVAEI.endIndex) + 1;
            }
            if (pairIndex != 0) continue;
            pairIndex = 4;
        }
        this.lastPatchRule = patchRule;
        this.lastSelOptList.clear();
        int i = 0;
        while (i < resultList.size()) {
            String[] nextSelOpt = (String[])resultList.get(i);
            String[] selOptCopy = new String[nextSelOpt.length];
            System.arraycopy(nextSelOpt, 0, selOptCopy, 0, nextSelOpt.length);
            this.lastSelOptList.add(selOptCopy);
            ++i;
        }
        return resultList;
    }

    public synchronized boolean includedInPatchRule(String dependentPatch, String antecedentPatch, String patchRule) {
        if (patchRule == null) {
            return false;
        }
        List theSelOpt = patchRule.equals(this.lastPatchRule) ? this.lastSelOptList : this.parsePatchRule(patchRule);
        int i = 0;
        while (i < theSelOpt.size()) {
            block8: {
                boolean antInside;
                int antIndex;
                int depIndex;
                String[] nextSelOpt;
                block9: {
                    block10: {
                        block6: {
                            block7: {
                                nextSelOpt = (String[])theSelOpt.get(i);
                                depIndex = 0;
                                antIndex = 0;
                                if (nextSelOpt[0] == null) break block6;
                                if (!nextSelOpt[0].equals(DEPENDENT_ROLE)) break block7;
                                depIndex = 1;
                                break block6;
                            }
                            if (!nextSelOpt[0].equals(ANTECEDENT_ROLE)) break block8;
                            antIndex = 1;
                        }
                        if (nextSelOpt[4] == null) break block9;
                        if (!nextSelOpt[4].equals(DEPENDENT_ROLE)) break block10;
                        depIndex = 5;
                        break block9;
                    }
                    if (!nextSelOpt[4].equals(ANTECEDENT_ROLE)) break block8;
                    antIndex = 5;
                }
                boolean depInside = depIndex == 0 ? true : this.isSelected(dependentPatch, nextSelOpt[depIndex], nextSelOpt[depIndex + 1], nextSelOpt[depIndex + 2]);
                boolean bl = antInside = antIndex == 0 ? true : this.isSelected(antecedentPatch, nextSelOpt[antIndex], nextSelOpt[antIndex + 1], nextSelOpt[antIndex + 2]);
                if (depInside && antInside) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isSelected(String elem, String op, String low, String high) {
        if (elem == null || op == null || low == null) {
            return true;
        }
        if (op.equals(EQUAL_OPERATOR)) {
            if (low.equals(elem)) {
                return true;
            }
        } else if (op.equals(GREATER_EQUAL_OPERATOR)) {
            if (low.compareTo(elem) <= 0) {
                return true;
            }
        } else if (op.equals(GREATER_THAN_OPERATOR)) {
            if (low.compareTo(elem) < 0) {
                return true;
            }
        } else if (op.equals(LOWER_EQUAL_OPERATOR)) {
            if (low.compareTo(elem) >= 0) {
                return true;
            }
        } else if (op.equals(LOWER_THAN_OPERATOR)) {
            if (low.compareTo(elem) > 0) {
                return true;
            }
        } else if (op.equals(BETWEEN_OPERATOR)) {
            if (high != null && low.compareTo(elem) <= 0 && high.compareTo(elem) >= 0) {
                return true;
            }
        } else if (!op.equals(CONTAINS_PATTERN_OPERATOR)) {
            if (op.equals(NOT_EQUAL_OPERATOR)) {
                if (!low.equals(elem)) {
                    return true;
                }
            } else if (op.equals(NOT_BETWEEN_OPERATOR)) {
                if (high != null && (low.compareTo(elem) > 0 || high.compareTo(elem) < 0)) {
                    return true;
                }
            } else if (op.equals(NO_PATTERN_OPERATOR)) {
                // empty if block
            }
        }
        return false;
    }

    public boolean excludedFromPatchRule(String dependentPatch, String antecedentPatch, String patchRule) {
        return !this.includedInPatchRule(dependentPatch, antecedentPatch, patchRule);
    }

    public boolean sameRuleElements(String[] elem, String[] otherElem) {
        if (elem[0] == null) {
            if (otherElem[0] != null) {
                return false;
            }
        } else {
            if (otherElem[0] == null) {
                return false;
            }
            if (!(elem[1].equals(otherElem[1]) && elem[2].equals(otherElem[2]) && elem[3].equals(otherElem[3]))) {
                return false;
            }
        }
        if (elem[4] == null) {
            if (otherElem[4] != null) {
                return false;
            }
        } else {
            if (otherElem[4] == null) {
                return false;
            }
            if (!(elem[5].equals(otherElem[5]) && elem[6].equals(otherElem[6]) && elem[7].equals(otherElem[7]))) {
                return false;
            }
        }
        return true;
    }

    public boolean equivalentRuleElements(String[] elem, String[] otherElem, String leftRole, String rightRole) {
        int cmpDep1Index = -1;
        int cmpDep2Index = -1;
        int cmpAnt1Index = -1;
        int cmpAnt2Index = -1;
        if (elem[0] != null) {
            if (elem[0].equals(leftRole)) {
                cmpDep1Index = 0;
            } else if (elem[0].equals(rightRole)) {
                cmpAnt1Index = 0;
            }
        }
        if (elem[4] != null) {
            if (elem[4].equals(leftRole)) {
                cmpDep1Index = 4;
            } else if (elem[4].equals(rightRole)) {
                cmpAnt1Index = 4;
            }
        }
        if (otherElem[0] != null) {
            if (otherElem[0].equals(leftRole)) {
                cmpDep2Index = 0;
            } else if (otherElem[0].equals(rightRole)) {
                cmpAnt2Index = 0;
            }
        }
        if (otherElem[4] != null) {
            if (otherElem[4].equals(leftRole)) {
                cmpDep2Index = 4;
            } else if (otherElem[4].equals(rightRole)) {
                cmpAnt2Index = 4;
            }
        }
        if (cmpDep1Index < 0) {
            if (cmpDep2Index >= 0) {
                return false;
            }
        } else {
            if (cmpDep2Index < 0) {
                return false;
            }
            if (!(elem[cmpDep1Index + 1].equals(otherElem[cmpDep2Index + 1]) && elem[cmpDep1Index + 2].equals(otherElem[cmpDep2Index + 2]) && elem[cmpDep1Index + 3].equals(otherElem[cmpDep2Index + 3]))) {
                return false;
            }
        }
        if (cmpAnt1Index < 0) {
            if (cmpAnt2Index >= 0) {
                return false;
            }
        } else {
            if (cmpAnt2Index < 0) {
                return false;
            }
            if (!(elem[cmpAnt1Index + 1].equals(otherElem[cmpAnt2Index + 1]) && elem[cmpAnt1Index + 2].equals(otherElem[cmpAnt2Index + 2]) && elem[cmpAnt1Index + 3].equals(otherElem[cmpAnt2Index + 3]))) {
                return false;
            }
        }
        return true;
    }

    private String getMaskedValue(String value) {
        StringBuffer result = new StringBuffer(value.length() + 8);
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case ',': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    result.append('\\');
                    result.append(c);
                    break;
                }
                case '\\': {
                    result.append('\\');
                    result.append('\\');
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private ValueAndEndIndex getUnmaskedValue(String value, int startIndex) {
        int end;
        StringBuffer result = new StringBuffer(value.length());
        int stopIndex = end = value.length();
        boolean endOfValue = false;
        int i = startIndex;
        while (i < end) {
            char c = value.charAt(i);
            block0 : switch (c) {
                case ',': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    endOfValue = true;
                    break;
                }
                case '\\': {
                    if (i + 1 >= end) break;
                    char nc = value.charAt(i + 1);
                    switch (nc) {
                        case ',': 
                        case ';': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '{': 
                        case '}': {
                            result.append(nc);
                            ++i;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            if (endOfValue) {
                stopIndex = i;
                break;
            }
            ++i;
        }
        return new ValueAndEndIndex(result.toString(), stopIndex);
    }

    public static void main(String[] args) {
        PatchRuleParser parser = new PatchRuleParser();
        String firstRule = "Antecedent{EQ[SAPKB62011]};Antecedent{BT[SAPKB62001,SAPKB62005]}Dependent{GE[SAPKB62012],};";
        parser.parsePatchRule(firstRule);
        parser.includedInPatchRule(null, "SAPKB62002", firstRule);
        parser.includedInPatchRule("SAPKB62011", null, firstRule);
        String secondRule = "Antecedent{LE[SAPKY46C02]};xxx";
        parser.includedInPatchRule(null, "SAPKY46C01", secondRule);
        String[] selOpt1 = new String[]{ANTECEDENT_ROLE, BETWEEN_OPERATOR, "SAPKY46C01", "SAPKY46C20", null, null, null, null};
        String[] selOpt2 = new String[]{ANTECEDENT_ROLE, EQUAL_OPERATOR, "UNFUG{},\\[]", null, null, null, null, null};
        String[] selOpt3 = new String[]{ANTECEDENT_ROLE, EQUAL_OPERATOR, "\\\\", null, null, null, null, null};
        String[] selOpt4 = new String[]{DEPENDENT_ROLE, LOWER_EQUAL_OPERATOR, "SAPKY46C28", null, null, null, null, null};
        ArrayList<String[]> selOpts = new ArrayList<String[]>();
        selOpts.add(selOpt1);
        selOpts.add(selOpt2);
        selOpts.add(selOpt3);
        selOpts.add(selOpt4);
        String rule = parser.writePatchRule(selOpts);
        parser.parsePatchRule(rule);
    }

    class ValueAndEndIndex {
        String value;
        int endIndex;

        ValueAndEndIndex(String aValue, int anEndIndex) {
            this.value = aValue;
            this.endIndex = anEndIndex;
        }
    }
}

