/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;

public class MemUsage {
    private static final Runtime rt = Runtime.getRuntime();
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$util$MemUsage == null ? (class$com$sap$lcr$api$util$MemUsage = MemUsage.class$("com.sap.lcr.api.util.MemUsage")) : class$com$sap$lcr$api$util$MemUsage).getName());
    private static long usedBefore = 0L;
    static /* synthetic */ Class class$com$sap$lcr$api$util$MemUsage;

    private MemUsage() {
    }

    public static void log(String text) {
        if (CIMTraceUtil.traceLevel < 3) {
            return;
        }
        if (!Util.isLogging(logger, Level.DEBUG)) {
            return;
        }
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        long used = total - free;
        logger.debug(text);
        logger.debug("  total memory: " + total);
        logger.debug("   free memory: " + free);
        logger.debug("       -> used: " + used);
        if (usedBefore != 0L) {
            logger.debug("    difference: " + (used - usedBefore) + "(may be wrong because of multi-threading)");
        }
        usedBefore = used;
    }

    public static void out(String text) {
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        long used = total - free;
        System.out.println(text);
        System.out.println("  total memory: " + total);
        System.out.println("   free memory: " + free);
        System.out.println("       -> used: " + used);
        if (usedBefore != 0L) {
            System.out.println("    difference: " + (used - usedBefore) + "(may be wrong because of multi-threading)");
        }
        usedBefore = used;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

